/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.ptp.remote.core.NullInputStream;

public class LocalProcess
extends AbstractRemoteProcess {
    private static int refCount = 0;
    private Process localProcess;
    private InputStream procStdout;
    private InputStream procStderr;
    private Thread stdoutReader;
    private Thread stderrReader;

    public LocalProcess(Process proc, boolean merge) throws IOException {
        this.localProcess = proc;
        if (merge) {
            PipedOutputStream pipedOutput = new PipedOutputStream();
            this.procStderr = new NullInputStream();
            this.procStdout = new PipedInputStream(pipedOutput);
            this.stderrReader = new Thread(new ProcOutputMerger(proc.getErrorStream(), pipedOutput));
            this.stdoutReader = new Thread(new ProcOutputMerger(proc.getInputStream(), pipedOutput));
            this.stderrReader.start();
            this.stdoutReader.start();
        } else {
            this.procStderr = this.localProcess.getErrorStream();
            this.procStdout = this.localProcess.getInputStream();
        }
    }

    public void destroy() {
        this.localProcess.destroy();
    }

    public int exitValue() {
        return this.localProcess.exitValue();
    }

    public InputStream getErrorStream() {
        return this.procStderr;
    }

    public InputStream getInputStream() {
        return this.procStdout;
    }

    public OutputStream getOutputStream() {
        return this.localProcess.getOutputStream();
    }

    public int waitFor() throws InterruptedException {
        return this.localProcess.waitFor();
    }

    public boolean isCompleted() {
        try {
            this.localProcess.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    private class ProcOutputMerger
    implements Runnable {
        private static final int BUF_SIZE = 8192;
        private InputStream input;
        private OutputStream output;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcOutputMerger(InputStream input, OutputStream output) {
            this.input = input;
            OutputStream outputStream = this.output = output;
            synchronized (outputStream) {
                refCount = refCount + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] b = new byte[8192];
            try {
                int len;
                while ((len = this.input.read(b)) > 0) {
                    this.output.write(b, 0, len);
                }
            }
            catch (IOException iOException) {}
            OutputStream outputStream = this.output;
            synchronized (outputStream) {
                int n = refCount - 1;
                refCount = n;
                if (n == 0) {
                    try {
                        this.output.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

