/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPBasicBlock;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.OMPCFGResult;

public class OMPCFG {
    private static final boolean traceOn = false;
    protected PASTOMPPragma pragma_ = null;
    protected IASTStatement statement_ = null;
    protected OMPCFGNode rootNode_ = null;
    protected OMPCFGNode termNode_ = null;
    protected OMPCFGResult.Chain rootChain_ = null;
    protected LinkedList unconnectedChains_ = null;
    protected LinkedList unresolvedChains_ = null;
    protected Hashtable labelMap_ = null;
    protected Stack graphStack_ = new Stack();
    protected HashSet usedNodes_ = new HashSet();
    protected PrintStream graphOut_ = null;
    protected int currentNumber_ = 0;

    public OMPCFG(PASTOMPPragma pragma, IASTStatement statement, OMPCFGResult.Chain rootChain, LinkedList unconnectedChains, LinkedList unresolvedChains, Hashtable labelMap) {
        this.pragma_ = pragma;
        this.statement_ = statement;
        this.rootNode_ = rootChain.getHeadNode();
        this.termNode_ = rootChain.getTailNode();
        this.rootChain_ = rootChain;
        this.unconnectedChains_ = unconnectedChains;
        this.unresolvedChains_ = unresolvedChains;
        this.labelMap_ = labelMap;
        this.numberNodes();
    }

    public IASTStatement getStatement() {
        return this.statement_;
    }

    public PASTOMPPragma getPragma() {
        return this.pragma_;
    }

    public OMPCFGNode getRoot() {
        return this.rootNode_;
    }

    public OMPCFGNode getTermNode() {
        return this.termNode_;
    }

    public void printCFG(PrintStream printOut) {
        this.graphOut_ = printOut;
        this.usedNodes_.clear();
        this.numberNodes();
        this.visitGraph();
    }

    private void numberNodes() {
        this.currentNumber_ = 0;
        this.graphStack_.clear();
        this.graphStack_.push(this.rootNode_);
        while (!this.graphStack_.isEmpty()) {
            OMPCFGNode node = (OMPCFGNode)this.graphStack_.pop();
            node.setId(this.currentNumber_++);
            OMPCFGNode[] nodes = node.getOutNodes();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i].getId() == -1) {
                    this.graphStack_.push(nodes[i]);
                }
                ++i;
            }
        }
    }

    private void visitGraph() {
        this.graphStack_.clear();
        this.graphStack_.push(this.rootNode_);
        while (!this.graphStack_.isEmpty()) {
            OMPCFGNode node = (OMPCFGNode)this.graphStack_.pop();
            this.printNode(node);
            this.usedNodes_.add(node);
            OMPCFGNode[] nodes = node.getOutNodes();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] instanceof OMPCFGNode && !this.usedNodes_.contains(nodes[i])) {
                    this.graphStack_.push(nodes[i]);
                }
                ++i;
            }
        }
    }

    private void printNode(OMPCFGNode node) {
        int i;
        node.getId();
        if (node instanceof OMPBasicBlock) {
            OMPBasicBlock obb = (OMPBasicBlock)node;
            IASTStatement[] stmts = obb.getStatements();
            i = 0;
            while (i < stmts.length) {
                ++i;
            }
        }
        OMPCFGNode[] nodes = node.getOutNodes();
        int i2 = 0;
        while (i2 < nodes.length) {
            nodes[i2].getId();
            ++i2;
        }
        OMPCFGNode[] inodes = node.getInNodes();
        i = 0;
        while (i < inodes.length) {
            inodes[i].getId();
            ++i;
        }
    }

    private String getShortClassName(Class c) {
        String n = c.toString();
        int lastIndex = n.lastIndexOf(46);
        return n.substring(lastIndex + 1);
    }
}

