/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.core.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class FileEnumeration
implements Enumeration {
    File[] files;
    int currentFile;

    public FileEnumeration(File root) throws IOException {
        if (!root.exists()) {
            throw new FileNotFoundException();
        }
        if (root.isFile()) {
            this.files = new File[1];
            this.files[0] = root;
        } else if (root.isDirectory()) {
            this.files = root.listFiles();
            if (this.files == null) {
                throw new IOException(NLS.bind((String)"Cannot list directory {0}", (Object)root.getAbsolutePath()));
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        this.currentFile = 0;
    }

    FileEnumeration(String root) throws IOException {
        this(new File(root));
    }

    public boolean hasMoreElements() {
        return this.currentFile < this.files.length;
    }

    public Object nextElement() {
        if (this.currentFile < this.files.length) {
            return this.files[this.currentFile++];
        }
        return null;
    }

    public static void main(String[] args) {
        FileEnumeration enumeration = null;
        try {
            enumeration = new FileEnumeration("c:/command");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        while (enumeration.hasMoreElements()) {
        }
    }
}

