/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.xlc.ui.properties;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RemoteDirectoryFieldEditor
extends DirectoryFieldEditor {
    protected IHost connectionHost;
    private IRemoteFile currentRemoteFile;
    private String currentRemoteFilename;

    public RemoteDirectoryFieldEditor(String name, String labelText, Composite parent, IHost connectionHost) {
        super(name, labelText, parent);
        this.connectionHost = connectionHost;
    }

    protected String changePressed() {
        String remotePath = this.browseRemoteLocation(this.getShell(), this.getTextControl().getText());
        if (remotePath != null) {
            this.getTextControl().setText(remotePath);
        }
        this.doCheckState();
        return remotePath;
    }

    public String browseRemoteLocation(Shell shell, String path) {
        ISystemFilterReference ref;
        ISubSystem targetSubSystem;
        ISubSystemConfiguration factory;
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell);
        dlg.setShowNewConnectionPrompt(false);
        if (this.connectionHost != null) {
            dlg.setDefaultSystemConnection(this.connectionHost, true);
            this.updateCurrentRemoteFile();
            if (this.currentRemoteFile != null) {
                dlg.setPreSelection((Object)this.currentRemoteFile);
            }
        }
        dlg.open();
        Object output = dlg.getOutputObject();
        if (output instanceof ISystemFilterReference && (factory = (targetSubSystem = (ref = (ISystemFilterReference)output).getSubSystem()).getSubSystemConfiguration()).supportsDropInFilters()) {
            output = targetSubSystem.getTargetForFilter(ref);
        }
        String outputLocation = null;
        if (output instanceof IRemoteFile) {
            IRemoteFile rmtFile = (IRemoteFile)output;
            outputLocation = rmtFile.getAbsolutePath();
        }
        return outputLocation;
    }

    private void updateCurrentRemoteFile() {
        String dirName = this.getTextControl().getText();
        if (this.currentRemoteFilename == null || !this.currentRemoteFilename.equals(dirName)) {
            IRemoteFileSubSystem remoteFileSubSystem;
            this.currentRemoteFilename = dirName;
            this.currentRemoteFile = null;
            if (this.connectionHost != null && (remoteFileSubSystem = RemoteFileUtility.getFileSubSystem((IHost)this.connectionHost)) != null) {
                try {
                    this.currentRemoteFile = remoteFileSubSystem.getRemoteFileObject(this.currentRemoteFilename, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (SystemMessageException systemMessageException) {}
            }
        }
    }

    protected boolean doCheckState() {
        this.updateCurrentRemoteFile();
        if (this.currentRemoteFile != null) {
            return this.currentRemoteFile.exists();
        }
        return false;
    }
}

