/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPFunction
extends PlatformObject
implements ICPPFunction,
ICPPInternalFunction {
    protected ICPPASTFunctionDeclarator[] declarations;
    protected ICPPASTFunctionDeclarator definition;
    protected ICPPFunctionType type = null;
    private static final int FULLY_RESOLVED = 1;
    private static final int RESOLUTION_IN_PROGRESS = 2;
    private int bits = 0;

    public CPPFunction(ICPPASTFunctionDeclarator declarator) {
        if (declarator != null) {
            IASTNode parent = ASTQueries.findOutermostDeclarator(declarator).getParent();
            if (parent instanceof IASTFunctionDefinition) {
                this.definition = declarator;
            } else {
                this.declarations = new ICPPASTFunctionDeclarator[]{declarator};
            }
            IASTName name = this.getASTName();
            name.setBinding(this);
        }
    }

    private void resolveAllDeclarations() {
        if ((this.bits & 3) == 0) {
            this.bits |= 2;
            IASTTranslationUnit tu = null;
            if (this.definition != null) {
                tu = this.definition.getTranslationUnit();
            } else if (this.declarations != null) {
                tu = this.declarations[0].getTranslationUnit();
            } else {
                IScope scope = this.getScope();
                try {
                    IASTNode node = ASTInternal.getPhysicalNodeOfScope(scope);
                    if (node != null) {
                        tu = node.getTranslationUnit();
                    }
                }
                catch (DOMException dOMException) {}
            }
            if (tu != null) {
                CPPVisitor.getDeclarations(tu, this);
            }
            this.declarations = (ICPPASTFunctionDeclarator[])ArrayUtil.trim(ICPPASTFunctionDeclarator.class, this.declarations);
            this.bits |= 1;
            this.bits &= 0xFFFFFFFD;
        }
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public void addDefinition(IASTNode node) {
        ICPPASTFunctionDeclarator dtor = this.extractFunctionDtor(node);
        if (dtor != null) {
            this.updateParameterBindings(dtor);
            this.definition = dtor;
        }
    }

    public void addDeclaration(IASTNode node) {
        ICPPASTFunctionDeclarator dtor = this.extractFunctionDtor(node);
        if (dtor != null) {
            this.updateParameterBindings(dtor);
            if (this.declarations == null) {
                this.declarations = new ICPPASTFunctionDeclarator[]{dtor};
                return;
            }
            this.declarations = this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (ICPPASTFunctionDeclarator[])ArrayUtil.prepend(ICPPASTFunctionDeclarator.class, this.declarations, dtor) : (ICPPASTFunctionDeclarator[])ArrayUtil.append(ICPPASTFunctionDeclarator.class, this.declarations, dtor);
        }
    }

    private ICPPASTFunctionDeclarator extractFunctionDtor(IASTNode node) {
        if (node instanceof IASTName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        if (!((node = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node)) instanceof ICPPASTFunctionDeclarator)) {
            return null;
        }
        return (ICPPASTFunctionDeclarator)node;
    }

    public IParameter[] getParameters() {
        ICPPASTFunctionDeclarator dtor = this.getPreferredDtor();
        IASTParameterDeclaration[] params = dtor.getParameters();
        int size = params.length;
        IParameter[] result = new IParameter[size];
        if (size > 0) {
            int i = 0;
            while (i < size) {
                IASTParameterDeclaration p = params[i];
                IASTName name = ASTQueries.findInnermostDeclarator(p.getDeclarator()).getName();
                IBinding binding = name.resolveBinding();
                result[i] = binding instanceof IParameter ? (IParameter)binding : new CPPParameter.CPPParameterProblem(p, 5, name.toCharArray());
                ++i;
            }
        }
        return result;
    }

    public IScope getFunctionScope() {
        this.resolveAllDeclarations();
        if (this.definition != null) {
            return this.definition.getFunctionScope();
        }
        return this.declarations[0].getFunctionScope();
    }

    public String getName() {
        return this.getASTName().toString();
    }

    public char[] getNameCharArray() {
        return this.getASTName().getSimpleID();
    }

    protected IASTName getASTName() {
        IASTDeclarator dtor = this.definition != null ? this.definition : this.declarations[0];
        IASTName name = (dtor = ASTQueries.findInnermostDeclarator(dtor)).getName();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        return name;
    }

    public IScope getScope() {
        IASTName n = this.getASTName();
        IScope scope = CPPVisitor.getContainingScope(n);
        if (scope instanceof ICPPClassScope) {
            IASTNode node;
            ICPPASTDeclSpecifier declSpec = null;
            if (this.definition != null) {
                node = ASTQueries.findOutermostDeclarator(this.definition).getParent();
                IASTFunctionDefinition def = (IASTFunctionDefinition)node;
                declSpec = (ICPPASTDeclSpecifier)def.getDeclSpecifier();
            } else {
                node = ASTQueries.findOutermostDeclarator(this.declarations[0]).getParent();
                IASTSimpleDeclaration decl = (IASTSimpleDeclaration)node;
                declSpec = (ICPPASTDeclSpecifier)decl.getDeclSpecifier();
            }
            if (declSpec.isFriend()) {
                try {
                    while (scope instanceof ICPPClassScope) {
                        scope = scope.getParent();
                    }
                }
                catch (DOMException dOMException) {}
            }
        }
        return scope;
    }

    public ICPPFunctionType getType() {
        if (this.type == null) {
            this.type = (ICPPFunctionType)CPPVisitor.createType(this.definition != null ? this.definition : this.declarations[0]);
        }
        return this.type;
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTName n;
        IASTParameterDeclaration[] paramDecls;
        IASTDeclarator dtor = param.getDeclarator();
        while (dtor.getNestedDeclarator() != null) {
            dtor = dtor.getNestedDeclarator();
        }
        IASTName name = dtor.getName();
        IBinding binding = name.getBinding();
        if (binding != null) {
            return binding;
        }
        IASTStandardFunctionDeclarator fdtor = (IASTStandardFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        binding = new CPPParameter(name);
        IASTParameterDeclaration temp = null;
        if (this.definition != null && (paramDecls = this.definition.getParameters()).length > i && (n = ASTQueries.findInnermostDeclarator((temp = paramDecls[i]).getDeclarator()).getName()) != name) {
            n.setBinding(binding);
            ASTInternal.addDeclaration(binding, n);
        }
        if (this.declarations != null) {
            int j = 0;
            while (j < this.declarations.length && this.declarations[j] != null) {
                IASTName n2;
                IASTParameterDeclaration[] paramDecls2 = this.declarations[j].getParameters();
                if (paramDecls2.length > i && (n2 = ASTQueries.findInnermostDeclarator((temp = paramDecls2[i]).getDeclarator()).getName()) != name) {
                    n2.setBinding(binding);
                    ASTInternal.addDeclaration(binding, n2);
                }
                ++j;
            }
        }
        return binding;
    }

    protected void updateParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        ICPPASTFunctionDeclarator orig = this.definition != null ? this.definition : this.declarations[0];
        IASTParameterDeclaration[] ops = orig.getParameters();
        IASTParameterDeclaration[] nps = fdtor.getParameters();
        CPPParameter temp = null;
        int i = 0;
        while (i < ops.length) {
            temp = (CPPParameter)ASTQueries.findInnermostDeclarator(ops[i].getDeclarator()).getName().getBinding();
            if (temp != null && nps.length > i) {
                IASTDeclarator dtor = nps[i].getDeclarator();
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                IASTName name = dtor.getName();
                name.setBinding(temp);
                ASTInternal.addDeclaration(temp, name);
            }
            ++i;
        }
    }

    public boolean isStatic() {
        return this.isStatic(true);
    }

    public boolean isStatic(boolean resolveAll) {
        if (resolveAll && (this.bits & 1) == 0) {
            this.resolveAllDeclarations();
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public static boolean hasStorageClass(ICPPInternalFunction function, int storage) {
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)function.getDefinition();
        IASTNode[] ds = function.getDeclarations();
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = (ICPPASTFunctionDeclarator)ds[i]) != null);
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isInline() throws DOMException {
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)this.getDefinition();
        ICPPASTFunctionDeclarator[] ds = (ICPPASTFunctionDeclarator[])this.getDeclarations();
        int i = -1;
        do {
            if (dtor == null) continue;
            IASTNode parent = dtor.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec == null || !declSpec.isInline()) continue;
            return true;
        } while (ds != null && ++i < ds.length && (dtor = ds[i]) != null);
        return false;
    }

    public boolean isExternC() throws DOMException {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTNode[] ds = this.getDeclarations();
        if (ds != null) {
            IASTNode[] iASTNodeArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode element = iASTNodeArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isExtern() {
        return CPPFunction.hasStorageClass(this, 2);
    }

    public boolean isAuto() {
        return CPPFunction.hasStorageClass(this, 4);
    }

    public boolean isRegister() {
        return CPPFunction.hasStorageClass(this, 5);
    }

    public boolean takesVarArgs() {
        ICPPASTFunctionDeclarator dtor = this.getPreferredDtor();
        return dtor != null ? dtor.takesVarArgs() : false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        return result.toString();
    }

    public IBinding getOwner() throws DOMException {
        return CPPVisitor.findNameOwner(this.getASTName(), false);
    }

    public IType[] getExceptionSpecification() throws DOMException {
        ICPPASTFunctionDeclarator declarator = this.getPreferredDtor();
        if (declarator != null) {
            IASTTypeId[] astTypeIds = declarator.getExceptionSpecification();
            if (astTypeIds.equals(ICPPASTFunctionDeclarator.NO_EXCEPTION_SPECIFICATION)) {
                return null;
            }
            if (astTypeIds.equals(IASTTypeId.EMPTY_TYPEID_ARRAY)) {
                return IType.EMPTY_TYPE_ARRAY;
            }
            IType[] typeIds = new IType[astTypeIds.length];
            int i = 0;
            while (i < astTypeIds.length) {
                typeIds[i] = CPPVisitor.createType(astTypeIds[i]);
                ++i;
            }
            return typeIds;
        }
        return null;
    }

    protected ICPPASTFunctionDeclarator getPreferredDtor() {
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)this.getDefinition();
        if (dtor != null) {
            return dtor;
        }
        ICPPASTFunctionDeclarator[] dtors = (ICPPASTFunctionDeclarator[])this.getDeclarations();
        if (dtors != null) {
            ICPPASTFunctionDeclarator[] iCPPASTFunctionDeclaratorArray = dtors;
            int n = dtors.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTFunctionDeclarator declarator = iCPPASTFunctionDeclaratorArray[n2];
                if (declarator != null) {
                    return declarator;
                }
                ++n2;
            }
        }
        return null;
    }

    public static class CPPFunctionProblem
    extends ProblemBinding
    implements ICPPFunction {
        public CPPFunctionProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IParameter[] getParameters() throws DOMException {
            throw new DOMException(this);
        }

        public IScope getFunctionScope() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPFunctionType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isInline() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExternC() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public boolean takesVarArgs() throws DOMException {
            throw new DOMException(this);
        }

        public IType[] getExceptionSpecification() throws DOMException {
            throw new DOMException(this);
        }
    }
}

