/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.core.runtime.PlatformObject;

public class CPPEnumeration
extends PlatformObject
implements IEnumeration,
ICPPInternalBinding {
    private IASTName enumName;

    public CPPEnumeration(IASTName name) {
        this.enumName = name;
        name.setBinding(this);
    }

    public IASTNode[] getDeclarations() {
        return null;
    }

    public IASTNode getDefinition() {
        return this.enumName;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        return this.enumName.getSimpleID();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.enumName);
    }

    public IASTNode getPhysicalNode() {
        return this.enumName;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public IEnumerator[] getEnumerators() {
        IASTEnumerationSpecifier.IASTEnumerator[] enums = ((IASTEnumerationSpecifier)this.enumName.getParent()).getEnumerators();
        IEnumerator[] bindings = new IEnumerator[enums.length];
        int i = 0;
        while (i < enums.length) {
            bindings[i] = (IEnumerator)enums[i].getName().resolveBinding();
            ++i;
        }
        return bindings;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public void addDefinition(IASTNode node) {
    }

    public void addDeclaration(IASTNode node) {
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexType) {
            return type.isSameType(this);
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public IBinding getOwner() throws DOMException {
        return CPPVisitor.findDeclarationOwner(this.enumName, true);
    }
}

