/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class CPPScope
implements ICPPScope,
ICPPASTInternalScope {
    protected static final char[] CONSTRUCTOR_KEY = "!!!CTOR!!!".toCharArray();
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private IASTNode physicalNode;
    private boolean isCached = false;
    protected CharArrayObjectMap bindings = null;

    public CPPScope(IASTNode physicalNode) {
        this.physicalNode = physicalNode;
    }

    public IScope getParent() throws DOMException {
        return CPPVisitor.getContainingNonTemplateScope(this.physicalNode);
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) throws DOMException {
        char[] c;
        if (!name.isActive()) {
            return;
        }
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if (name instanceof ICPPASTQualifiedName) {
            if (!(this.physicalNode instanceof ICPPASTCompositeTypeSpecifier) && !(this.physicalNode instanceof ICPPASTNamespaceDefinition)) {
                return;
            }
            if (!this.canDenoteScopeMember((ICPPASTQualifiedName)name)) {
                return;
            }
        }
        if ((c = name.getLookupKey()).length == 0) {
            return;
        }
        Object o = this.bindings.get(c);
        if (o != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(name);
            } else {
                ObjectSet<Object> temp = new ObjectSet<Object>(2);
                temp.put(o);
                temp.put(name);
                this.bindings.put(c, temp);
            }
        } else {
            this.bindings.put(c, name);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canDenoteScopeMember(ICPPASTQualifiedName name) {
        IScope scope = this;
        IASTName[] na = name.getNames();
        try {
            int i = na.length - 2;
            while (true) {
                if (i < 0) {
                    if (name.isFullyQualified() && scope != null) {
                        return ASTInternal.getPhysicalNodeOfScope(scope) instanceof IASTTranslationUnit;
                    }
                    return true;
                }
                if (scope == null) {
                    return false;
                }
                IName scopeName = scope.getScopeName();
                if (scopeName == null) {
                    return false;
                }
                if (!CharArrayUtils.equals(scopeName.getSimpleID(), na[i].getSimpleID())) {
                    return false;
                }
                scope = scope.getParent();
                --i;
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public IBinding getBinding(IASTName name, boolean forceResolve, IIndexFileSet fileSet) throws DOMException {
        IBinding binding = this.getBindingInAST(name, forceResolve);
        if (binding == null && forceResolve) {
            IIndex index;
            IASTTranslationUnit tu = name.getTranslationUnit();
            IIndex iIndex = index = tu == null ? null : tu.getIndex();
            if (index != null) {
                ICPPNamespace nsbindingAdapted;
                ICPPASTNamespaceDefinition nsdef;
                IASTName nsname;
                IBinding nsbinding;
                char[] nchars = name.getLookupKey();
                if (this.physicalNode instanceof IASTTranslationUnit) {
                    try {
                        Object[] bindings = index.findBindings(nchars, IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE, NPM);
                        if (fileSet != null) {
                            bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                        }
                        if ((binding = CPPSemantics.resolveAmbiguities(name, bindings)) instanceof ICPPUsingDeclaration) {
                            binding = CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition && (nsbinding = (nsname = (nsdef = (ICPPASTNamespaceDefinition)this.physicalNode).getName()).resolveBinding()) instanceof ICPPNamespace && (nsbindingAdapted = (ICPPNamespace)((Object)index.adaptBinding(nsbinding))) != null) {
                    return nsbindingAdapted.getNamespaceScope().getBinding(name, forceResolve, fileSet);
                }
            }
        }
        return binding;
    }

    public IBinding getBindingInAST(IASTName name, boolean forceResolve) throws DOMException {
        Object[] bs = this.getBindingsInAST(name, forceResolve, false, false, true);
        return CPPSemantics.resolveAmbiguities(name, bs);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        return this.getBindings(name, resolve, prefixLookup, fileSet, true);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet, boolean checkPointOfDecl) throws DOMException {
        IIndex index;
        Object[] result = this.getBindingsInAST(name, resolve, prefixLookup, checkPointOfDecl, true);
        IASTTranslationUnit tu = name.getTranslationUnit();
        if (tu != null && (index = tu.getIndex()) != null) {
            if (this.physicalNode instanceof IASTTranslationUnit) {
                try {
                    Object[] bindings;
                    IndexFilter filter = IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE;
                    char[] nchars = name.getLookupKey();
                    Object[] objectArray = bindings = prefixLookup ? index.findBindingsForPrefix(nchars, true, filter, null) : index.findBindings(nchars, filter, null);
                    if (fileSet != null) {
                        bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                    }
                    result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, bindings);
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
            } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition) {
                ICPPASTNamespaceDefinition ns = (ICPPASTNamespaceDefinition)this.physicalNode;
                try {
                    IIndexBinding binding = index.findBinding(ns.getName());
                    if (binding instanceof ICPPNamespace) {
                        ICPPNamespaceScope indexNs = ((ICPPNamespace)((Object)binding)).getNamespaceScope();
                        Object[] bindings = indexNs.getBindings(name, resolve, prefixLookup);
                        if (fileSet != null) {
                            bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                        }
                        result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, bindings);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    public IBinding[] getBindingsInAST(IASTName name, boolean forceResolve, boolean prefixLookup, boolean checkPointOfDecl, boolean expandUsingDirectives) throws DOMException {
        this.populateCache();
        char[] c = name.getLookupKey();
        Object[] result = null;
        Object obj = null;
        if (prefixLookup) {
            Object[] keys = this.bindings != null ? this.bindings.keyArray() : new Object[]{};
            ObjectSet<Object> all = new ObjectSet<Object>(16);
            int i = 0;
            while (i < keys.length) {
                char[] key = (char[])keys[i];
                if (key != CONSTRUCTOR_KEY && CharArrayUtils.equals(key, 0, c.length, c, true)) {
                    obj = this.bindings.get(key);
                    if (obj instanceof ObjectSet) {
                        all.addAll((ObjectSet)obj);
                    } else if (obj != null) {
                        all.put(obj);
                    }
                }
                ++i;
            }
            obj = all;
        } else {
            Object object = obj = this.bindings != null ? this.bindings.get(c) : null;
        }
        if (obj != null) {
            if (obj instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)obj;
                int j = 0;
                while (j < os.size()) {
                    result = this.addCandidate(os.keyAt(j), name, forceResolve, checkPointOfDecl, expandUsingDirectives, (IBinding[])result);
                    ++j;
                }
            } else {
                result = this.addCandidate(obj, name, forceResolve, checkPointOfDecl, expandUsingDirectives, (IBinding[])result);
            }
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    private IBinding[] addCandidate(Object candidate, IASTName name, boolean forceResolve, boolean checkPointOfDecl, boolean expandUsingDirectives, IBinding[] result) {
        IBinding binding;
        IASTTranslationUnit tu;
        if (!(!checkPointOfDecl || CPPSemantics.declaredBefore(candidate, name, (tu = name.getTranslationUnit()) != null && tu.getIndex() != null) || this instanceof ICPPClassScope && LookupData.checkWholeClassScope(name))) {
            return result;
        }
        if (candidate instanceof IASTName) {
            IASTName candName = (IASTName)candidate;
            IASTName simpleName = candName.getLastName();
            if (simpleName instanceof ICPPASTTemplateId) {
                simpleName = ((ICPPASTTemplateId)simpleName).getTemplateName();
            }
            if (forceResolve && candName != name && simpleName != name) {
                candName.resolvePreBinding();
                binding = simpleName.resolvePreBinding();
            } else {
                binding = simpleName.getPreBinding();
            }
        } else {
            binding = (IBinding)candidate;
        }
        if (expandUsingDirectives && binding instanceof ICPPUsingDeclaration) {
            Object[] delegates = ((ICPPUsingDeclaration)binding).getDelegates();
            result = (IBinding[])ArrayUtil.addAll(IBinding.class, result, delegates);
        } else {
            result = (IBinding[])ArrayUtil.append(IBinding.class, result, binding);
        }
        return result;
    }

    public final void populateCache() {
        if (!this.isCached) {
            CPPSemantics.populateCache(this);
            this.isCached = true;
        }
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public void addBinding(IBinding binding) {
        char[] c;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((c = binding.getNameCharArray()).length == 0) {
            return;
        }
        Object o = this.bindings.get(c);
        if (o != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(binding);
            } else {
                ObjectSet<Object> set = new ObjectSet<Object>(2);
                set.put(o);
                set.put(binding);
                this.bindings.put(c, set);
            }
        } else {
            this.bindings.put(c, binding);
        }
    }

    public final IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY, true);
    }

    public IName getScopeName() throws DOMException {
        return null;
    }

    public String toString() {
        IName name = null;
        try {
            name = this.getScopeName();
        }
        catch (DOMException dOMException) {}
        String n = name != null ? name.toString() : "<unnamed scope>";
        return String.valueOf(this.getKind().toString()) + ' ' + n + ' ' + '(' + super.toString() + ')';
    }

    public static class CPPScopeProblem
    extends ProblemBinding
    implements ICPPScope {
        public CPPScopeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public CPPScopeProblem(IASTName name, int id) {
            super(name, id);
        }
    }
}

