/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ObjectMap;

public class CPPTemplateParameterMap
implements ICPPTemplateParameterMap {
    public static final CPPTemplateParameterMap EMPTY = new CPPTemplateParameterMap(0);
    private final ObjectMap fMap;

    public CPPTemplateParameterMap(int initialSize) {
        this.fMap = new ObjectMap(initialSize);
    }

    public boolean contains(ICPPTemplateParameter templateParameter) {
        return this.fMap.containsKey(templateParameter.getParameterID());
    }

    public void put(ICPPTemplateParameter param, ICPPTemplateArgument value) {
        this.fMap.put(param.getParameterID(), value);
    }

    public void put(int parameterID, ICPPTemplateArgument value) {
        this.fMap.put(parameterID, value);
    }

    public ICPPTemplateArgument getArgument(ICPPTemplateParameter param) {
        if (param == null) {
            return null;
        }
        return (ICPPTemplateArgument)this.fMap.get(param.getParameterID());
    }

    public ICPPTemplateArgument getArgument(int paramID) {
        return (ICPPTemplateArgument)this.fMap.get(paramID);
    }

    public void putAll(ICPPTemplateParameterMap map) {
        if (map instanceof CPPTemplateParameterMap) {
            ObjectMap omap = ((CPPTemplateParameterMap)map).fMap;
            int i = 0;
            while (i < omap.size()) {
                this.fMap.put(omap.keyAt(i), omap.getAt(i));
                ++i;
            }
        } else assert (false);
    }

    public ICPPTemplateArgument[] values() {
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[this.fMap.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICPPTemplateArgument)this.fMap.getAt(i);
            ++i;
        }
        return result;
    }

    public Integer[] getAllParameterPositions() {
        return this.fMap.keyArray(Integer.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        int i = 0;
        while (i < this.fMap.size()) {
            Integer key = (Integer)this.fMap.keyAt(i);
            if (key != null) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                ICPPTemplateArgument value = (ICPPTemplateArgument)this.fMap.getAt(i);
                sb.append('#');
                sb.append(key >> 16);
                sb.append(',');
                sb.append((int)(key & 0xFFFF));
                sb.append(": ");
                sb.append(ASTTypeUtil.getArgumentString(value, true));
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

