/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameterSpecialization
extends PDOMCPPSpecialization
implements ICPPParameter {
    private static final int NEXT_PARAM = 40;
    private static final int TYPE = 44;
    protected static final int RECORD_SIZE = 48;

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPParameter param, PDOMCPPParameter specialized, long typeRecord) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)param), specialized);
        Database db = this.getDB();
        db.putRecPtr(this.record + 40L, 0L);
        db.putRecPtr(this.record + 44L, typeRecord);
    }

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, PDOMNode parent, ICPPParameter param, PDOMCPPParameter specialized, IType type) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)param), specialized);
        Database db = this.getDB();
        db.putRecPtr(this.record + 40L, 0L);
        try {
            if (type == null) {
                type = param.getType();
            }
            if (type != null) {
                PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, type);
                db.putRecPtr(this.record + 44L, typeNode != null ? typeNode.getRecord() : 0L);
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 48;
    }

    public int getNodeType() {
        return 32;
    }

    public void setNextParameter(PDOMCPPParameterSpecialization nextParam) throws CoreException {
        long rec = nextParam != null ? nextParam.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 40L, rec);
    }

    public PDOMCPPParameterSpecialization getNextParameter() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 40L);
        return rec != 0L ? new PDOMCPPParameterSpecialization((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    public IType getType() throws DOMException {
        try {
            PDOMNode node = ((PDOMLinkage)this.getLinkage()).getNode(this.getDB().getRecPtr(this.record + 44L));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    private ICPPParameter getParameter() {
        return (ICPPParameter)this.getSpecializedBinding();
    }

    public boolean hasDefaultValue() {
        return this.getParameter().hasDefaultValue();
    }

    public boolean isAuto() throws DOMException {
        return this.getParameter().isAuto();
    }

    public boolean isRegister() throws DOMException {
        return this.getParameter().isRegister();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IValue getInitialValue() {
        return null;
    }
}

