/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.TodoTaskParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;

public class TodoTaskUpdater
implements ITodoTaskUpdater {
    private static final String SOURCE_ID = "CDT";
    private static final String[] TASK_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "priority", "charStart", "charEnd", "lineNumber", "userEditable", "sourceId"};
    private final TodoTaskParser taskParser;

    public TodoTaskUpdater() {
        String value = CCorePlugin.getOption((String)"org.eclipse.cdt.core.taskTags");
        if (value == null) {
            value = "TODO,FIXME,XXX";
        }
        String[] tags = this.split(value, ",");
        char[][] taskTags = new char[tags.length][];
        int i = 0;
        while (i < tags.length) {
            taskTags[i] = tags[i].toCharArray();
            ++i;
        }
        value = CCorePlugin.getOption((String)"org.eclipse.cdt.core.taskPriorities");
        if (value == null) {
            value = "normal";
        }
        String[] priorities = this.split(value, ",");
        int[] taskPriorities = new int[taskTags.length];
        int i2 = 0;
        while (i2 < taskPriorities.length) {
            String priority;
            String string = priority = i2 < priorities.length ? priorities[i2] : "normal";
            taskPriorities[i2] = "high".equals(priority) ? 2 : ("low".equals(priority) ? 0 : 1);
            ++i2;
        }
        value = CCorePlugin.getOption((String)"org.eclipse.cdt.core.taskCaseSensitive");
        if (value == null) {
            value = "false";
        }
        boolean isTaskCaseSensitive = Boolean.valueOf(value);
        this.taskParser = new TodoTaskParser(taskTags, taskPriorities, isTaskCaseSensitive);
    }

    public void updateTasks(IASTComment[] comments, IIndexFileLocation[] filesToUpdate) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        class TaskList {
            IFile fFile;
            List<TodoTaskParser.Task> fTasks;

            public TaskList(IFile file) {
                this.fFile = file;
            }

            public void add(TodoTaskParser.Task task) {
                if (this.fTasks == null) {
                    this.fTasks = new ArrayList<TodoTaskParser.Task>();
                }
                this.fTasks.add(task);
            }
        }
        final HashMap<IPath, TaskList> pathToTaskList = new HashMap<IPath, TaskList>();
        HashSet<IProject> projects = new HashSet<IProject>();
        IIndexFileLocation[] iIndexFileLocationArray = filesToUpdate;
        int n = filesToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IIndexFileLocation indexFileLocation = iIndexFileLocationArray[n2];
            String filepath = indexFileLocation.getFullPath();
            if (filepath != null && (file = workspaceRoot.getFile((IPath)new Path(filepath))) != null && file.exists()) {
                projects.add(file.getProject());
                pathToTaskList.put(IndexLocationFactory.getAbsolutePath(indexFileLocation), new TaskList(file));
            }
            ++n2;
        }
        if (comments.length > 0) {
            TodoTaskParser.Task[] tasks;
            TodoTaskParser.Task[] taskArray = tasks = this.taskParser.parse(comments);
            int n3 = tasks.length;
            n = 0;
            while (n < n3) {
                TodoTaskParser.Task task = taskArray[n];
                TaskList list = (TaskList)pathToTaskList.get(new Path(task.getFileLocation()));
                if (list != null) {
                    list.add(task);
                }
                ++n;
            }
        }
        if (!pathToTaskList.isEmpty()) {
            Job job = new Job(Messages.TodoTaskUpdater_UpdateJob){

                protected IStatus run(IProgressMonitor monitor) {
                    MultiStatus status = new MultiStatus("org.eclipse.cdt.core", 0, Messages.TodoTaskUpdater_UpdateJob, null);
                    for (TaskList tasklist : pathToTaskList.values()) {
                        IFile file = tasklist.fFile;
                        try {
                            if (!file.exists()) continue;
                            file.deleteMarkers("org.eclipse.cdt.core.task", false, 2);
                            List<TodoTaskParser.Task> tasks = tasklist.fTasks;
                            if (tasks == null) continue;
                            for (TodoTaskParser.Task task : tasks) {
                                TodoTaskUpdater.this.applyTask(task, (IResource)file);
                            }
                        }
                        catch (CoreException e) {
                            if (!file.exists()) continue;
                            status.add(e.getStatus());
                        }
                    }
                    return status;
                }
            };
            job.setRule((ISchedulingRule)new MultiRule((ISchedulingRule[])projects.toArray(new IProject[projects.size()])));
            job.setSystem(true);
            job.schedule();
        }
    }

    private void applyTask(TodoTaskParser.Task task, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.cdt.core.task");
        String description = NLS.bind((String)Messages.TodoTaskUpdater_taskFormat, (Object)task.getTag(), (Object)task.getMessage());
        marker.setAttributes(TASK_MARKER_ATTRIBUTE_NAMES, new Object[]{description, new Integer(task.getPriority()), new Integer(task.getStart()), new Integer(task.getEnd()), new Integer(task.getLineNumber()), Boolean.FALSE, SOURCE_ID});
    }

    private String[] split(String value, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
        int size = tokenizer.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    public static void removeTasksFor(final IResource resource) {
        if (resource == null || !resource.exists()) {
            return;
        }
        Job job = new Job(Messages.TodoTaskUpdater_DeleteJob){

            protected IStatus run(IProgressMonitor monitor) {
                block3: {
                    try {
                        if (!resource.exists()) {
                            return Status.CANCEL_STATUS;
                        }
                        resource.deleteMarkers("org.eclipse.cdt.core.task", false, 2);
                    }
                    catch (CoreException e) {
                        if (!resource.exists()) break block3;
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)resource);
        job.setSystem(true);
        job.schedule();
    }
}

