/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.ui;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.AbstractTargetControl;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.ui.Messages;
import org.eclipse.ptp.cell.simulator.SimulatorPlugin;
import org.eclipse.ptp.cell.simulator.conf.Parameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.simulator.extensions.Architecture;
import org.eclipse.ptp.cell.simulator.extensions.ArchitectureManager;
import org.eclipse.ptp.cell.simulator.extensions.LaunchProfile;
import org.eclipse.ptp.cell.simulator.extensions.LaunchProfileManager;
import org.eclipse.ptp.remotetools.environment.wizard.AbstractEnvironmentDialogPage;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrame;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrameMold;
import org.eclipse.ptp.utils.ui.swt.ComboGroup;
import org.eclipse.ptp.utils.ui.swt.ComboGroupItem;
import org.eclipse.ptp.utils.ui.swt.ComboMold;
import org.eclipse.ptp.utils.ui.swt.ControlsRelationshipHandler;
import org.eclipse.ptp.utils.ui.swt.FileGroup;
import org.eclipse.ptp.utils.ui.swt.FileMold;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.GenericControlMold;
import org.eclipse.ptp.utils.ui.swt.SpinnerGroup;
import org.eclipse.ptp.utils.ui.swt.SpinnerMold;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ConfigurationPage
extends AbstractEnvironmentDialogPage {
    CommonConfigurationBean bean;
    private boolean hasError = false;
    private String targetName;
    private boolean availableAutomaticWorkDirectory;
    private boolean availableRemoteConnection;
    private boolean availableAutomaticNetwork;
    private boolean availableAutomaticPort;
    TabFolder tabFolder;
    TabItem targetConnectionTabItem;
    TabItem showattributesMap;
    TabItem emulatedHardwareTabItem;
    TabItem simulatorOptionsTabItem;
    TabItem connectivityTabItem;
    TabItem launchTabItem;
    TextGroup targetNameText;
    AuthenticationFrame targetConnectionFrame;
    Frame hardwareConfig;
    ComboGroup architectureId;
    SpinnerGroup memorySize;
    Frame filesystemInfo;
    ComboGroup rootImagePersistence;
    FileGroup rootImageJournalPath;
    JournalFileEnabler rootJournalFileEnabler;
    FileGroup kernelImagePath;
    FileGroup filesystemImagePath;
    Button extraImageInit;
    ControlsRelationshipHandler additionalStorageControlsHandler;
    JournalFileEnabler extraJournalFileEnabler;
    FileGroup extraImagePath;
    ComboGroup extraImageFilesystem;
    TextGroup extraImageMountpoint;
    ComboGroup extraImagePersistence;
    FileGroup extraImageJournalPath;
    Frame simulatorOptions;
    Button showSimulatorGUI;
    Button consoleShowLinux;
    Button consoleShowSimulator;
    Button automaticWorkDirectory;
    FileGroup workDirectory;
    ControlsRelationshipHandler workDirectoryControlHandler;
    FileGroup simulatorBaseDirectory;
    ComboGroup launchProfileId;
    TextGroup extraCommandLineSwitches;
    TextGroup customizationScript;
    Button automaticPortConfig;
    TextGroup consoleSocketPort;
    TextGroup javaAPISocketPort;
    ControlsRelationshipHandler portAutoControlsHandler;
    Frame sshConnectionConfig;
    Button automaticNetwork;
    TextGroup macSimulator;
    TextGroup ipSimulator;
    TextGroup ipHost;
    ControlsRelationshipHandler connAutoControlsHandler;
    Frame authenticationInfo;
    Button automaticAutentication;
    TextGroup simulatorUserName;
    TextGroup simulatorPassword;
    TextGroup simulatorTimeout;
    ComboGroup simulatorCipherType;
    ControlsRelationshipHandler authAutoControlsHandler;
    Frame launchFrame;
    TextGroup systemWorkspaceGroup;
    private TextModifyListener textModifyListener;
    private ButtonSelectionListener buttonSelectionListener;
    private TargetConnectionModifyListener targetConnectionModifyListener;

    public ConfigurationPage(String targetName, CommonConfigurationBean bean) {
        super(targetName);
        this.bean = bean;
        this.targetName = targetName;
    }

    public void createControl(Composite parent) {
        if (this.availableRemoteConnection) {
            this.setDescription(Messages.ConfigurationPage_DialogDescription_RemoteSimulator);
            this.setTitle(Messages.ConfigurationPage_DialogTitle_RemoteSimulator);
        } else {
            this.setDescription(Messages.ConfigurationPage_DialogDescription_LocalSimulator);
            this.setTitle(Messages.ConfigurationPage_DialogTitle_LocalSimulator);
        }
        this.setErrorMessage(null);
        GridLayout topLayout = new GridLayout();
        Composite topControl = new Composite(parent, 0);
        this.setControl((Control)topControl);
        topControl.setLayout((Layout)topLayout);
        TextMold targetMold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL, Messages.ConfigurationPage_LabelTargetName);
        this.targetNameText = new TextGroup(topControl, targetMold);
        this.targetNameText.setString(this.targetName);
        this.tabFolder = new TabFolder(topControl, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(768));
        if (this.availableRemoteConnection) {
            this.targetConnectionTabItem = new TabItem(this.tabFolder, 0);
            this.targetConnectionTabItem.setText(Messages.ConfigurationPage_TabItemTitleRemoteHost);
            Composite tcComp = this.generateTabItemComposite(this.targetConnectionTabItem);
            this.createRemoteHostFrame(tcComp);
        }
        this.emulatedHardwareTabItem = new TabItem(this.tabFolder, 0);
        this.emulatedHardwareTabItem.setText(Messages.ConfigurationPage_TabItemTitleHardwareProperties);
        Composite hwComp = this.generateTabItemComposite(this.emulatedHardwareTabItem);
        this.createHardwareConfigFrame(hwComp);
        this.createFileSystemInfoFrame(hwComp);
        this.simulatorOptionsTabItem = new TabItem(this.tabFolder, 0);
        this.simulatorOptionsTabItem.setText(Messages.ConfigurationPage_TabItemTitleSimulatorProperties);
        this.createSimulatorOptionsFrame(this.generateTabItemComposite(this.simulatorOptionsTabItem));
        this.connectivityTabItem = new TabItem(this.tabFolder, 0);
        this.connectivityTabItem.setText(Messages.ConfigurationPage_TabItemTitleConnectivityProperties);
        Composite sshComp = this.generateTabItemComposite(this.connectivityTabItem);
        this.createSSHConnectionInfoFrame(sshComp);
        this.createSSHAuthenticationFrame(sshComp);
        this.launchTabItem = new TabItem(this.tabFolder, 0);
        this.launchTabItem.setText(Messages.ConfigurationPage_TabItemLaunchProperties);
        Composite launchComp = this.generateTabItemComposite(this.launchTabItem);
        this.createLaunchFrame(launchComp);
        this.textModifyListener = new TextModifyListener();
        this.buttonSelectionListener = new ButtonSelectionListener();
        this.fillControls();
        this.validateFields();
        this.registerListeners();
    }

    private Composite createLaunchFrame(Composite launchComp) {
        Frame frame = new Frame(launchComp, Messages.ConfigurationPage_Launch_FrameTitle);
        TextMold mold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_Launch_LabelSystemWorkspace);
        this.systemWorkspaceGroup = new TextGroup(frame.getComposite(), mold);
        return frame;
    }

    private Composite createRemoteHostFrame(Composite tcComp) {
        AuthenticationFrameMold amold = new AuthenticationFrameMold(Messages.ConfigurationPage_RemoteTarget_FrameTitle);
        amold.setLabelHideAdvancedOptions(Messages.ConfigurationPage_RemoteTarget_LabelHideAdvancedOptions);
        amold.setLabelHostAddress(Messages.ConfigurationPage_RemoteTarget_LabelHostAddress);
        amold.setLabelHostPort(Messages.ConfigurationPage_RemoteTarget_LabelHostPort);
        amold.setLabelIsPasswordBased(Messages.ConfigurationPage_RemoteTarget_LabelIsPasswordBased);
        amold.setLabelIsPublicKeyBased(Messages.ConfigurationPage_RemoteTarget_LabelIsPublicKeyBased);
        amold.setLabelPassphrase(Messages.ConfigurationPage_RemoteTarget_LabelPassphrase);
        amold.setLabelPassword(Messages.ConfigurationPage_RemoteTarget_LabelPassword);
        amold.setLabelPublicKeyPath(Messages.ConfigurationPage_RemoteTarget_LabelPublicKeyPath);
        amold.setLabelPublicKeyPathButton(Messages.ConfigurationPage_RemoteTarget_LabelPublicKeyPathButton);
        amold.setLabelPublicKeyPathTitle(Messages.ConfigurationPage_RemoteTarget_LabelPublicKeyPathTitle);
        amold.setLabelShowAdvancedOptions(Messages.ConfigurationPage_RemoteTarget_LabelShowAdvancedOptions);
        amold.setLabelTimeout(Messages.ConfigurationPage_RemoteTarget_LabelTimeout);
        amold.setLabelUserName(Messages.ConfigurationPage_RemoteTarget_LabelUserName);
        this.targetConnectionFrame = new AuthenticationFrame(tcComp, amold);
        this.targetConnectionFrame.setLayoutData((Object)new GridData(768));
        return this.targetConnectionFrame;
    }

    private Composite generateTabItemComposite(TabItem tabitem) {
        Composite comp = new Composite((Composite)this.tabFolder, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        comp.setLayout((Layout)glayout);
        comp.setLayoutData((Object)new GridData(1808));
        tabitem.setControl((Control)comp);
        return comp;
    }

    private void createSSHConnectionInfoFrame(Composite parent) {
        FrameMold fmold = new FrameMold(Messages.ConfigurationPage_SshConnection_FrameTitle, 2, false);
        this.sshConnectionConfig = new Frame(parent, fmold);
        this.automaticNetwork = new Button(this.sshConnectionConfig.getTopUserReservedComposite(), 32);
        this.automaticNetwork.setText(Messages.ConfigurationPage_SshConnection_LabelAutomaticNetwork);
        GridData netGridData = new GridData(32);
        netGridData.horizontalSpan = 2;
        this.automaticNetwork.setLayoutData((Object)netGridData);
        TextMold tmold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_SshConnection_LabelMacAddres);
        this.macSimulator = new TextGroup(this.sshConnectionConfig.getTopUserReservedComposite(), tmold);
        tmold.setLabel(Messages.ConfigurationPage_SshConnection_LabelSimulatorIP);
        this.ipSimulator = new TextGroup(this.sshConnectionConfig.getTopUserReservedComposite(), tmold);
        tmold.setLabel(Messages.ConfigurationPage_SshConnection_LabelHostIP);
        this.ipHost = new TextGroup(this.sshConnectionConfig.getTopUserReservedComposite(), tmold);
        Control[] cList = new Control[]{this.macSimulator, this.ipSimulator, this.ipHost};
        this.connAutoControlsHandler = new ControlsRelationshipHandler(this.automaticNetwork, cList, false);
        this.connAutoControlsHandler.manageDependentControls(this.automaticNetwork);
    }

    private void createSSHAuthenticationFrame(Composite parent) {
        FrameMold authMold = new FrameMold(Messages.ConfigurationPage_Authentication_FrameTitle, 2, true);
        this.authenticationInfo = new Frame(parent, authMold);
        this.automaticAutentication = new Button(this.authenticationInfo.getTopUserReservedComposite(), 32);
        this.automaticAutentication.setText(Messages.ConfigurationPage_Authentication_LabelAutomaticAuthentication);
        GridData authGridData = new GridData(32);
        authGridData.horizontalSpan = 2;
        this.automaticAutentication.setLayoutData((Object)authGridData);
        TextMold tmold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_Authentication_LabelLogin);
        this.simulatorUserName = new TextGroup(this.authenticationInfo.getTopUserReservedComposite(), tmold);
        tmold.setLabel(Messages.ConfigurationPage_Authentication_LabelPassword);
        tmold.addBitmask(TextMold.PASSWD_FIELD);
        this.simulatorPassword = new TextGroup(this.authenticationInfo.getTopUserReservedComposite(), tmold);
        tmold.removeBitmask(TextMold.PASSWD_FIELD);
        tmold.setLabel(Messages.ConfigurationPage_Authentication_LabelTimeout);
        tmold.addBitmask(TextMold.LIMIT_SIZE | TextMold.WIDTH_PROPORTIONAL_NUM_CHARS);
        tmold.setTextFieldWidth(6);
        this.simulatorTimeout = new TextGroup(this.authenticationInfo.getBottomUserReservedComposite(), tmold);
        ComboMold cmold = new ComboMold(ComboMold.GRID_DATA_SPAN | ComboMold.GRID_DATA_ALIGNMENT_FILL | ComboMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_Authentication_CipherType);
        this.simulatorCipherType = new ComboGroup(this.authenticationInfo.getBottomUserReservedComposite(), (GenericControlMold)cmold);
        Control[] cList = new Control[]{this.simulatorUserName, this.simulatorPassword};
        this.authAutoControlsHandler = new ControlsRelationshipHandler(this.automaticAutentication, cList, false);
        this.authAutoControlsHandler.manageDependentControls(this.automaticAutentication);
    }

    private void createSimulatorOptionsFrame(Composite parent) {
        FrameMold fmold = new FrameMold(Messages.ConfigurationPage_SimulatorOptions_FrameTitle, 2, true);
        this.simulatorOptions = new Frame(parent, fmold);
        this.showSimulatorGUI = new Button(this.simulatorOptions.getTopUserReservedComposite(), 32);
        this.showSimulatorGUI.setText(Messages.ConfigurationPage_SimulatorOptions_LabelShowGUI);
        this.showSimulatorGUI.setLayoutData((Object)new GridData(768));
        this.consoleShowLinux = new Button(this.simulatorOptions.getTopUserReservedComposite(), 32);
        this.consoleShowLinux.setText(Messages.ConfigurationPage_SimulatorOptions_LabelShowLinuxConsole);
        this.consoleShowLinux.setLayoutData((Object)new GridData(768));
        this.consoleShowSimulator = new Button(this.simulatorOptions.getTopUserReservedComposite(), 32);
        this.consoleShowSimulator.setText(Messages.ConfigurationPage_SimulatorOptions_LabelShowTCLConsole);
        this.consoleShowSimulator.setLayoutData((Object)new GridData(768));
        new Label(this.simulatorOptions.getTopUserReservedComposite(), 0);
        if (this.availableAutomaticWorkDirectory) {
            this.automaticWorkDirectory = new Button(this.simulatorOptions.getTopUserReservedComposite(), 32);
            this.automaticWorkDirectory.setText(Messages.DefaultWorkingDirectoryButtonText);
            this.automaticWorkDirectory.setLayoutData((Object)new GridData(768));
        }
        FileMold fsmold = new FileMold(FileMold.GRID_DATA_ALIGNMENT_FILL | FileMold.GRID_DATA_GRAB_EXCESS_SPACE | FileMold.GRID_DATA_SPAN | FileMold.DIRECTORY_SELECTION, Messages.ConfigurationPage_SimulatorOptions_LabelWorkingDirectory, Messages.ConfigurationPage_SimulatorOptions_WorkingDirectoryDialog_Title, Messages.ConfigurationPage_SimulatorOptions_WorkingDirectoryDialog_Description);
        this.workDirectory = new FileGroup(this.simulatorOptions.getTopUserReservedComposite(), fsmold);
        this.workDirectory.setButtonEnabled(!this.availableRemoteConnection);
        if (this.automaticWorkDirectory != null) {
            this.workDirectoryControlHandler = new ControlsRelationshipHandler(this.automaticWorkDirectory, (Control)this.workDirectory, false);
            this.workDirectoryControlHandler.manageDependentControls(this.automaticWorkDirectory);
        }
        fsmold.setLabel(Messages.ConfigurationPage_SimulatorOptions_LabelInstallationPath);
        fsmold.setDialogLabel(Messages.ConfigurationPage_SimulatorOptions_InstallationPathDialog_Title);
        fsmold.setDialogMessage(Messages.ConfigurationPage_SimulatorOptions_InstallationPathDialog_Description);
        this.simulatorBaseDirectory = new FileGroup(this.simulatorOptions.getBottomUserReservedComposite(), fsmold);
        this.simulatorBaseDirectory.setButtonEnabled(!this.availableRemoteConnection);
        ComboMold cmold = new ComboMold(ComboMold.GRID_DATA_ALIGNMENT_FILL | ComboMold.GRID_DATA_GRAB_EXCESS_SPACE | ComboMold.GRID_DATA_SPAN, Messages.ConfigurationPage_SimulatorOptions_LabelLaunchProfile);
        this.launchProfileId = new ComboGroup(this.simulatorOptions.getBottomUserReservedComposite(), (GenericControlMold)cmold);
        LaunchProfileManager lManager = SimulatorPlugin.getLaunchProfileManager();
        LaunchProfile[] profilss = lManager.getLaunchProfiles();
        int i = 0;
        while (i < profilss.length) {
            ComboGroupItem citem = new ComboGroupItem(profilss[i].getId(), profilss[i].getName());
            this.launchProfileId.add(citem);
            ++i;
        }
        TextMold tmold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.GRID_DATA_SPAN, Messages.ConfigurationPage_SimulatorOptions_LabelExtraCommandLineSwitches);
        this.extraCommandLineSwitches = new TextGroup(this.simulatorOptions.getBottomUserReservedComposite(), tmold);
        tmold.addBitmask(TextMold.LABELABOVE | TextMold.MULTILINE_TEXT);
        tmold.setNumberOfLines(6);
        tmold.setLabel(Messages.ConfigurationPage_SimulatorOptions_LabelCustoScript);
        this.customizationScript = new TextGroup(this.simulatorOptions.getBottomUserReservedComposite(), tmold);
        this.automaticPortConfig = new Button(this.simulatorOptions.getBottomUserReservedComposite(), 32);
        this.automaticPortConfig.setText(Messages.ConfigurationPage_SimulatorOptions_LabelAutomaticPorts);
        GridData portOptGD = new GridData(32);
        portOptGD.horizontalSpan = 2;
        this.automaticPortConfig.setLayoutData((Object)portOptGD);
        TextMold tmoldSimple = new TextMold(TextMold.WIDTH_PROPORTIONAL_NUM_CHARS | TextMold.LIMIT_SIZE, Messages.ConfigurationPage_SimulatorOptions_LabelConsolePort);
        tmoldSimple.setTextFieldWidth(6);
        this.consoleSocketPort = new TextGroup(this.simulatorOptions.getBottomUserReservedComposite(), tmoldSimple);
        if (Parameters.doUseJavaAPI()) {
            tmoldSimple.setLabel(Messages.ConfigurationPage_SimulatorOptions_LabelJavaAPIPort);
            this.javaAPISocketPort = new TextGroup(this.simulatorOptions.getBottomUserReservedComposite(), tmoldSimple);
        }
        Control[] portAutoSlaves = null;
        if (Parameters.doUseJavaAPI()) {
            portAutoSlaves = new Control[]{this.consoleSocketPort, this.javaAPISocketPort};
            if (Parameters.doHandleJavaApiGuiIssue()) {
                this.showSimulatorGUI.setEnabled(false);
            }
        } else {
            portAutoSlaves = new Control[]{this.consoleSocketPort};
        }
        this.portAutoControlsHandler = new ControlsRelationshipHandler(this.automaticPortConfig, portAutoSlaves, false);
        this.portAutoControlsHandler.manageDependentControls(this.automaticPortConfig);
    }

    private void createFileSystemInfoFrame(Composite parent) {
        FrameMold fmold = new FrameMold(Messages.ConfigurationPage_FileSystem_FrameTitle, 1, true);
        this.filesystemInfo = new Frame(parent, fmold);
        ComboGroupItem[] storageTypes = new ComboGroupItem[]{new ComboGroupItem("discard", Messages.ConfigurationPage_FileSystem_OptionNonPersistent), new ComboGroupItem("write", Messages.ConfigurationPage_FileSystem_OptionPersistent), new ComboGroupItem("journal", Messages.ConfigurationPage_FileSystem_OptionJournaled)};
        String storageTypeTooltip = Messages.ConfigurationPage_FileSystem_ToolTipRootImagePersistence;
        ComboMold storageTypeComboMold = new ComboMold(ComboMold.GRID_DATA_GRAB_EXCESS_SPACE | ComboMold.GRID_DATA_ALIGNMENT_FILL | ComboMold.HASTOOLTIP, Messages.ConfigurationPage_FileSystem_LabelRootImagePersistence);
        storageTypeComboMold.setTooltip(storageTypeTooltip);
        this.rootImagePersistence = new ComboGroup(this.filesystemInfo.getTopUserReservedComposite(), (GenericControlMold)storageTypeComboMold);
        this.rootImagePersistence.add(storageTypes[0]);
        this.rootImagePersistence.add(storageTypes[1]);
        this.rootImagePersistence.add(storageTypes[2]);
        FileMold fsmold = new FileMold(FileMold.GRID_DATA_ALIGNMENT_FILL | FileMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.ConfigurationPage_FileSystem_LabelJournalFile, Messages.ConfigurationPage_FileSystem_JournalFileDialogTitle, Messages.ConfigurationPage_FileSystem_JournalFileDialogDescription);
        this.rootImageJournalPath = new FileGroup(this.filesystemInfo.getTopUserReservedComposite(), fsmold);
        this.rootImageJournalPath.setButtonEnabled(!this.availableRemoteConnection);
        this.rootJournalFileEnabler = new JournalFileEnabler(this.rootImagePersistence, this.rootImageJournalPath);
        fsmold.setLabel(Messages.ConfigurationPage_FileSystem_LabelKernelImage);
        fsmold.setDialogLabel(Messages.ConfigurationPage_FileSystem_KernelFileDialog_Title);
        fsmold.setDialogMessage(Messages.ConfigurationPage_FileSystem_KernelFileDialog_Description);
        this.kernelImagePath = new FileGroup(this.filesystemInfo.getTopUserReservedComposite(), fsmold);
        this.kernelImagePath.setButtonEnabled(!this.availableRemoteConnection);
        fsmold.setLabel(Messages.ConfigurationPage_FileSystem_LabelRoot);
        fsmold.setDialogLabel(Messages.ConfigurationPage_FileSystem_RootFileDialog_Title);
        fsmold.setDialogMessage(Messages.ConfigurationPage_FileSystem_RootFileDialog_Description);
        this.filesystemImagePath = new FileGroup(this.filesystemInfo.getTopUserReservedComposite(), fsmold);
        this.filesystemImagePath.setButtonEnabled(!this.availableRemoteConnection);
        this.extraImageInit = new Button(this.filesystemInfo.getBottomUserReservedComposite(), 32);
        this.extraImageInit.setText(Messages.ConfigurationPage_FileSystem_LabelEnableExtraStorage);
        this.extraImageInit.setLayoutData((Object)new GridData(768));
        FileMold imagePathMold = new FileMold(FileMold.GRID_DATA_GRAB_EXCESS_SPACE | FileMold.GRID_DATA_ALIGNMENT_FILL, Messages.ConfigurationPage_FileSystem_LabelExtraImagePath, Messages.ConfigurationPage_FileSystem_ExtraImagePathFileDialog_Title, Messages.ConfigurationPage_FileSystem_ExtraImagePathFileDialog_Description);
        this.extraImagePath = new FileGroup(this.filesystemInfo.getBottomUserReservedComposite(), imagePathMold);
        ComboMold fsTypeMold = new ComboMold(ComboMold.GRID_DATA_GRAB_EXCESS_SPACE | ComboMold.GRID_DATA_ALIGNMENT_FILL, Messages.ConfigurationPage_FileSystem_LabelExtraFilesystemType);
        this.extraImageFilesystem = new ComboGroup(this.filesystemInfo.getBottomUserReservedComposite(), (GenericControlMold)fsTypeMold);
        ComboGroupItem[] fsTypes = new ComboGroupItem[]{new ComboGroupItem("ext3", Messages.ConfigurationPage_FileSystem_TypeOption_Ext3), new ComboGroupItem("ext2", Messages.ConfigurationPage_FileSystem_TypeOption_Ext2), new ComboGroupItem("iso9660", Messages.ConfigurationPage_FileSystem_TypeOption_Iso9660)};
        this.extraImageFilesystem.add(fsTypes[0]);
        this.extraImageFilesystem.add(fsTypes[1]);
        this.extraImageFilesystem.add(fsTypes[2]);
        TextMold tmold = new TextMold(TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.GRID_DATA_ALIGNMENT_FILL, Messages.ConfigurationPage_FileSystem_LabelExtraMountPoint);
        this.extraImageMountpoint = new TextGroup(this.filesystemInfo.getBottomUserReservedComposite(), tmold);
        this.extraImageMountpoint.setButtonEnabled(!this.availableRemoteConnection);
        this.extraImagePersistence = new ComboGroup(this.filesystemInfo.getBottomUserReservedComposite(), (GenericControlMold)storageTypeComboMold);
        this.extraImagePersistence.add(storageTypes[0]);
        this.extraImagePersistence.add(storageTypes[1]);
        this.extraImagePersistence.add(storageTypes[2]);
        fsmold.setLabel(Messages.ConfigurationPage_FileSystem_LabelExtraJournalFile);
        fsmold.setDialogLabel(Messages.ConfigurationPage_FileSystem_ExtraJournalFileDialog_Title);
        fsmold.setDialogLabel(Messages.ConfigurationPage_FileSystem_ExtraJournalFileDialog_Description);
        this.extraImageJournalPath = new FileGroup(this.filesystemInfo.getBottomUserReservedComposite(), fsmold);
        this.extraImageJournalPath.setButtonEnabled(!this.availableRemoteConnection);
        Control[] cList = new Control[]{this.extraImagePath, this.extraImageFilesystem, this.extraImageMountpoint, this.extraImagePersistence};
        this.additionalStorageControlsHandler = new ControlsRelationshipHandler(this.extraImageInit, cList, true);
        this.additionalStorageControlsHandler.manageDependentControls(this.extraImageInit);
        this.extraJournalFileEnabler = new JournalFileEnabler(this.extraImagePersistence, this.extraImageJournalPath, this.extraImageInit);
    }

    private void createHardwareConfigFrame(Composite parent) {
        FrameMold fmold = new FrameMold(Messages.ConfigurationPage_Hardware_FrameTitle, 2, false);
        this.hardwareConfig = new Frame(parent, fmold);
        ComboMold cmold = new ComboMold(ComboMold.GRID_DATA_GRAB_EXCESS_SPACE | ComboMold.GRID_DATA_ALIGNMENT_FILL, Messages.ConfigurationPage_Hardware_LabelArchitectureType);
        this.architectureId = new ComboGroup(this.hardwareConfig.getTopUserReservedComposite(), (GenericControlMold)cmold);
        ArchitectureManager aManager = SimulatorPlugin.getArchitectureManager();
        Architecture[] archs = aManager.getArchitectures();
        int i = 0;
        while (i < archs.length) {
            ComboGroupItem citem = new ComboGroupItem(archs[i].getId(), archs[i].getName());
            this.architectureId.add(citem);
            ++i;
        }
        SpinnerMold smold = new SpinnerMold(0, Messages.ConfigurationPage_Hardware_LabelMemorySize, 0, Integer.MAX_VALUE, 1);
        this.memorySize = new SpinnerGroup(this.hardwareConfig.getTopUserReservedComposite(), (GenericControlMold)smold);
    }

    public void validateFields() {
        try {
            if (this.targetConnectionFrame != null) {
                this.targetConnectionFrame.validateFields();
            }
            CommonConfigFactory factory = this.bean.createFactory();
            factory.createTargetConfig();
            ISimulatorParameters parameters = factory.createSimulatorParameters();
            parameters.verify();
            this.hasError = false;
            this.setErrorMessage(null);
        }
        catch (CoreException e) {
            this.hasError = true;
            this.setErrorMessage(e.getLocalizedMessage());
        }
        catch (IllegalConfigurationException e) {
            this.hasError = true;
            this.setErrorMessage(e.getLocalizedMessage());
        }
    }

    public Map getAttributes() {
        return this.bean.getMap();
    }

    public boolean isValid() {
        this.validateFields();
        return !this.hasError;
    }

    public String getName() {
        return this.targetName;
    }

    private void readTextControls() {
        this.targetName = this.targetNameText.getString();
        ControlAttributes attributes = this.bean.getAttributes();
        attributes.setStringAttribute("memory-size", String.valueOf(this.memorySize.getValue()));
        attributes.setStringAttribute("simulator-base-directory", this.simulatorBaseDirectory.getString());
        attributes.setStringAttribute("work-directory", this.workDirectory.getString());
        attributes.setStringAttribute("extra-command-line-switches", this.extraCommandLineSwitches.getString());
        attributes.setStringAttribute("username", this.simulatorUserName.getString());
        attributes.setStringAttribute("password", this.simulatorPassword.getString());
        attributes.setStringAttribute("timeout", this.simulatorTimeout.getString());
        attributes.setStringAttribute("simulator-cipher-type", this.simulatorCipherType.getSelectionId());
        attributes.setStringAttribute("ip-host", this.ipHost.getString());
        attributes.setStringAttribute("ip-simulator", this.ipSimulator.getString());
        attributes.setStringAttribute("mac-simulator", this.macSimulator.getString());
        attributes.setStringAttribute("extra-image-path", this.extraImagePath.getString());
        attributes.setStringAttribute("extra-image-journal-path", this.extraImageJournalPath.getString());
        attributes.setStringAttribute("kernel-image-path", this.kernelImagePath.getString());
        attributes.setStringAttribute("root-image-path", this.filesystemImagePath.getString());
        attributes.setStringAttribute("root-image-journal-path", this.rootImageJournalPath.getString());
        if (this.javaAPISocketPort != null) {
            attributes.setStringAttribute("java-api-socket-port", this.javaAPISocketPort.getString());
        }
        attributes.setStringAttribute("console-socket-port", this.consoleSocketPort.getString());
        attributes.setStringAttribute("customization-script", this.customizationScript.getString());
        attributes.setStringAttribute("profile-id", this.launchProfileId.getSelectedItem().getId());
        attributes.setStringAttribute("architecture-id", this.architectureId.getSelectedItem().getId());
        attributes.setStringAttribute("extra-image-persistence", this.extraImagePersistence.getSelectedItem().getId());
        attributes.setStringAttribute("extra-image-type", this.extraImageFilesystem.getSelectionId());
        attributes.setStringAttribute("extra-image-path", this.extraImagePath.getString());
        attributes.setStringAttribute("extra-image-mountpoint", this.extraImageMountpoint.getString());
        attributes.setStringAttribute("root-image-persistence", this.rootImagePersistence.getSelectedItem().getId());
        attributes.setStringAttribute("system-workspace-dir", this.systemWorkspaceGroup.getString());
    }

    private void readButtonControls() {
        ControlAttributes attributes = this.bean.getAttributes();
        attributes.setBooleanAttribute("extra-image-init", this.extraImageInit.getSelection());
        attributes.setBooleanAttribute("show-simulator-gui", this.showSimulatorGUI.getSelection());
        attributes.setBooleanAttribute("automatic-authentication", this.automaticAutentication.getSelection());
        attributes.setBooleanAttribute("automatic-portconfig", this.automaticPortConfig.getSelection());
        attributes.setBooleanAttribute("automatic-network", this.automaticNetwork.getSelection());
        attributes.setBooleanAttribute("console-show-linux", this.consoleShowLinux.getSelection());
        attributes.setBooleanAttribute("console-show-simulator", this.consoleShowSimulator.getSelection());
        attributes.setStringAttribute("memory-size", String.valueOf(this.memorySize.getValue()));
        if (this.automaticWorkDirectory != null) {
            attributes.setBooleanAttribute("automatic-work-directory", this.automaticWorkDirectory.getSelection());
        }
    }

    private void readTargetConnectionControls() {
        ControlAttributes attributes = this.bean.getAttributes();
        attributes.setStringAttribute("remote-login-username", this.targetConnectionFrame.getUserName());
        attributes.setStringAttribute("remote-login-password", this.targetConnectionFrame.getPassword());
        attributes.setStringAttribute("remote-connection-address", this.targetConnectionFrame.getHostAddress());
        attributes.setStringAttribute("remote-connection-port", Integer.toString(this.targetConnectionFrame.getHostPort()));
        attributes.setStringAttribute("remote-key-path", this.targetConnectionFrame.getPublicKeyPath());
        attributes.setStringAttribute("remote-key-passphrase", this.targetConnectionFrame.getPassphrase());
        attributes.setStringAttribute("remote-timeout", Integer.toString(this.targetConnectionFrame.getTimeout()));
        attributes.setStringAttribute("remote-cipher-type", this.targetConnectionFrame.getSelectedCipherType().getId());
        attributes.setBooleanAttribute("remote-is-password-auth", this.targetConnectionFrame.isPasswordBased());
    }

    private void registerListeners() {
        Text[] textArray = null;
        textArray = this.javaAPISocketPort != null ? new Text[]{this.targetNameText.getText(), this.rootImageJournalPath.getText(), this.kernelImagePath.getText(), this.filesystemImagePath.getText(), this.extraImagePath.getText(), this.extraImageJournalPath.getText(), this.extraImageMountpoint.getText(), this.workDirectory.getText(), this.simulatorBaseDirectory.getText(), this.extraCommandLineSwitches.getText(), this.customizationScript.getText(), this.consoleSocketPort.getText(), this.javaAPISocketPort.getText(), this.macSimulator.getText(), this.ipSimulator.getText(), this.ipHost.getText(), this.simulatorUserName.getText(), this.simulatorPassword.getText(), this.simulatorTimeout.getText()} : new Text[]{this.targetNameText.getText(), this.rootImageJournalPath.getText(), this.kernelImagePath.getText(), this.filesystemImagePath.getText(), this.extraImagePath.getText(), this.extraImageMountpoint.getText(), this.extraImageJournalPath.getText(), this.workDirectory.getText(), this.simulatorBaseDirectory.getText(), this.extraCommandLineSwitches.getText(), this.customizationScript.getText(), this.consoleSocketPort.getText(), this.macSimulator.getText(), this.ipSimulator.getText(), this.ipHost.getText(), this.simulatorUserName.getText(), this.simulatorPassword.getText(), this.simulatorTimeout.getText()};
        Button[] btnArray = new Button[]{this.extraImageInit, this.showSimulatorGUI, this.consoleShowLinux, this.consoleShowSimulator, this.automaticNetwork, this.automaticAutentication, this.automaticPortConfig};
        Combo[] cbArray = new Combo[]{this.architectureId.getCombo(), this.rootImagePersistence.getCombo(), this.extraImagePersistence.getCombo(), this.launchProfileId.getCombo(), this.simulatorCipherType.getCombo(), this.extraImageFilesystem.getCombo()};
        int i = 0;
        while (i < textArray.length) {
            Text text = textArray[i];
            text.addModifyListener((ModifyListener)this.textModifyListener);
            ++i;
        }
        i = 0;
        while (i < btnArray.length) {
            Button button = btnArray[i];
            button.addSelectionListener((SelectionListener)this.buttonSelectionListener);
            ++i;
        }
        i = 0;
        while (i < cbArray.length) {
            Combo combo = cbArray[i];
            combo.addModifyListener((ModifyListener)this.textModifyListener);
            ++i;
        }
        this.memorySize.getSpinner().addModifyListener((ModifyListener)this.textModifyListener);
        this.memorySize.getSpinner().addSelectionListener((SelectionListener)this.buttonSelectionListener);
        if (this.targetConnectionFrame != null) {
            this.targetConnectionModifyListener = new TargetConnectionModifyListener();
            this.targetConnectionFrame.addModifyListener((ModifyListener)this.targetConnectionModifyListener);
        }
        if (this.automaticWorkDirectory != null) {
            this.automaticWorkDirectory.addSelectionListener((SelectionListener)this.buttonSelectionListener);
        }
    }

    private void fillControls() {
        ControlAttributes attributes = this.bean.getAttributes();
        this.simulatorBaseDirectory.setString(attributes.getString("simulator-base-directory"));
        this.workDirectory.setString(attributes.getString("work-directory"));
        if (this.automaticWorkDirectory != null) {
            this.automaticWorkDirectory.setSelection(attributes.getBoolean("automatic-work-directory"));
            this.workDirectoryControlHandler.manageDependentControls(this.automaticWorkDirectory);
        }
        this.architectureId.selectIndexUsingID(attributes.getString("architecture-id"));
        this.memorySize.setValue(attributes.getInteger("memory-size"));
        this.launchProfileId.setSelectionIndex(attributes.getInteger("profile-id"));
        this.extraCommandLineSwitches.setString(attributes.getString("extra-command-line-switches"));
        this.showSimulatorGUI.setSelection(attributes.getBoolean("show-simulator-gui"));
        this.automaticAutentication.setSelection(attributes.getBoolean("automatic-authentication"));
        this.authAutoControlsHandler.manageDependentControls(this.automaticAutentication);
        this.simulatorUserName.setString(attributes.getString("username"));
        this.simulatorPassword.setString(attributes.getString("password"));
        this.simulatorTimeout.setString(String.valueOf(attributes.getInteger("timeout")));
        Map cipherMap = AbstractTargetControl.getCipherTypesMap();
        Set cKeySet = cipherMap.keySet();
        for (String key : cKeySet) {
            String value = (String)cipherMap.get(key);
            this.simulatorCipherType.add(new ComboGroupItem(key, value));
        }
        this.simulatorCipherType.selectIndexUsingID(attributes.getString("simulator-cipher-type"));
        if (this.availableAutomaticNetwork) {
            this.automaticNetwork.setSelection(attributes.getBoolean("automatic-network"));
        } else {
            this.automaticNetwork.setSelection(false);
            this.automaticNetwork.setEnabled(false);
        }
        this.connAutoControlsHandler.manageDependentControls(this.automaticNetwork);
        this.ipHost.setString(attributes.getString("ip-host"));
        this.ipSimulator.setString(attributes.getString("ip-simulator"));
        this.macSimulator.setString(attributes.getString("mac-simulator"));
        this.extraImageInit.setSelection(attributes.getBoolean("extra-image-init"));
        this.additionalStorageControlsHandler.manageDependentControls(this.extraImageInit);
        this.extraImagePath.setString(attributes.getString("extra-image-path"));
        this.extraImagePersistence.setSelectionIndex(attributes.getInteger("extra-image-persistence"));
        this.extraImageJournalPath.setString(attributes.getString("extra-image-journal-path"));
        this.extraImagePath.setString(attributes.getString("extra-image-path"));
        this.extraImageMountpoint.setString(attributes.getString("extra-image-mountpoint"));
        this.extraImageFilesystem.selectIndexUsingID(attributes.getString("extra-image-type"));
        this.kernelImagePath.setString(attributes.getString("kernel-image-path"));
        this.filesystemImagePath.setString(attributes.getString("root-image-path"));
        this.rootImagePersistence.selectIndexUsingID(attributes.getString("root-image-persistence"));
        this.rootImageJournalPath.setString(attributes.getString("root-image-journal-path"));
        if (this.javaAPISocketPort != null) {
            this.javaAPISocketPort.setString(String.valueOf(attributes.getInteger("java-api-socket-port")));
        }
        this.consoleSocketPort.setString(String.valueOf(attributes.getInteger("console-socket-port")));
        this.consoleShowLinux.setSelection(attributes.getBoolean("console-show-linux"));
        this.consoleShowSimulator.setSelection(attributes.getBoolean("console-show-simulator"));
        if (this.availableAutomaticPort) {
            this.automaticPortConfig.setSelection(attributes.getBoolean("automatic-portconfig"));
        } else {
            this.automaticPortConfig.setSelection(false);
            this.automaticPortConfig.setEnabled(false);
        }
        this.portAutoControlsHandler.manageDependentControls(this.automaticPortConfig);
        if (this.availableRemoteConnection) {
            this.targetConnectionFrame.setHostPort(attributes.getInteger("remote-connection-port"));
            this.targetConnectionFrame.setHostAddress(attributes.getString("remote-connection-address"));
            this.targetConnectionFrame.setUserName(attributes.getString("remote-login-username"));
            this.targetConnectionFrame.setPassword(attributes.getString("remote-login-password"));
            this.targetConnectionFrame.setPublicKeyPath(attributes.getString("remote-key-path"));
            this.targetConnectionFrame.setPassphrase(attributes.getString("remote-key-passphrase"));
            this.targetConnectionFrame.setTimeout(attributes.getInteger("remote-timeout"));
            Map cMap = AbstractTargetControl.getCipherTypesMap();
            Set ckSet = cipherMap.keySet();
            ComboGroup cipherGroup = this.targetConnectionFrame.getCipherTypeGroup();
            for (String key : ckSet) {
                String value = (String)cMap.get(key);
                cipherGroup.add(new ComboGroupItem(key, value));
            }
            cipherGroup.selectIndexUsingID(attributes.getString("remote-cipher-type"));
            this.targetConnectionFrame.setPasswordBased(attributes.getBoolean("remote-is-password-auth"));
        }
        this.systemWorkspaceGroup.setString(attributes.getString("system-workspace-dir"));
    }

    public void setAvailableAutomaticNetwork(boolean availableAutomaticNetwork) {
        this.availableAutomaticNetwork = availableAutomaticNetwork;
    }

    public void setAvailableAutomaticPort(boolean availableAutomaticPort) {
        this.availableAutomaticPort = availableAutomaticPort;
    }

    public void setAvailableRemoteConnection(boolean availableRemoteConnection) {
        this.availableRemoteConnection = availableRemoteConnection;
    }

    public void setAvailableAutomaticWorkDirectory(boolean availableAutomaticWorkDirectory) {
        this.availableAutomaticWorkDirectory = availableAutomaticWorkDirectory;
    }

    class ButtonSelectionListener
    extends SelectionAdapter {
        int counter = 0;

        ButtonSelectionListener() {
        }

        public synchronized void enable() {
            ++this.counter;
        }

        public synchronized void disable() {
            --this.counter;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.counter < 0) {
                return;
            }
            ConfigurationPage.this.readButtonControls();
            ConfigurationPage.this.getContainer().updateButtons();
        }
    }

    class JournalFileEnabler {
        ComboGroup typeGroup;
        FileGroup journalGroup;
        Button masterButton;

        JournalFileEnabler(ComboGroup typeGroup, FileGroup journalGroup) {
            this(typeGroup, journalGroup, null);
        }

        JournalFileEnabler(ComboGroup typeGroup, FileGroup journalGroup, Button masterButton) {
            this.typeGroup = typeGroup;
            this.journalGroup = journalGroup;
            this.masterButton = masterButton;
            typeGroup.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    JournalFileEnabler.this.update();
                }
            });
            if (masterButton != null) {
                masterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        JournalFileEnabler.this.update();
                    }
                });
            }
            this.update();
        }

        public void update() {
            if (this.masterButton != null && !this.masterButton.getSelection()) {
                this.journalGroup.setEnabled(false);
                return;
            }
            String id = this.typeGroup.getSelectionId();
            if (id == null) {
                this.journalGroup.setEnabled(false);
            } else {
                this.journalGroup.setEnabled(id.equals("journal"));
            }
        }
    }

    class TargetConnectionModifyListener
    implements ModifyListener {
        int counter = 0;

        TargetConnectionModifyListener() {
        }

        public synchronized void enable() {
            ++this.counter;
        }

        public synchronized void disable() {
            --this.counter;
        }

        public void modifyText(ModifyEvent e) {
            if (this.counter < 0) {
                return;
            }
            ConfigurationPage.this.readTargetConnectionControls();
            ConfigurationPage.this.getContainer().updateButtons();
        }
    }

    class TextModifyListener
    implements ModifyListener {
        int counter = 0;

        TextModifyListener() {
        }

        public synchronized void enable() {
            ++this.counter;
        }

        public synchronized void disable() {
            --this.counter;
        }

        public void modifyText(ModifyEvent e) {
            if (this.counter < 0) {
                return;
            }
            ConfigurationPage.this.readTextControls();
            ConfigurationPage.this.getContainer().updateButtons();
        }
    }
}

