/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ptp.cell.simulator.internal.SimulatorControl;
import org.eclipse.ptp.cell.utils.stream.ILineStreamListener;

class StderrListener
implements ILineStreamListener {
    SimulatorControl control;
    Pattern patternStdout = Pattern.compile("\\s*\\d+\\s*:\\s*\\(\\s*\\d+\\s*\\)\\s*:.*");

    StderrListener(SimulatorControl control) {
        this.control = control;
    }

    public void newLine(String line) {
        if (line.startsWith("WARNING:")) {
            if (line.endsWith("no console connection made")) {
                this.control.notifyError("Could not connect console to simulator.");
            } else if (line.endsWith("unable to bind socket")) {
                this.control.notifyError("Could not connect console to simulator.");
            } else if (line.endsWith("init: couldn't allocated tun")) {
                this.control.notifyError("Could not allocate tun/tap network.");
            } else {
                this.forwardUnhandledError(line);
            }
        } else {
            Matcher matcher = this.patternStdout.matcher(line);
            if (!(matcher.matches() || line.indexOf("Execution stopped: Mambo Error") > 0 || line.indexOf("finished running") > 0 && line.indexOf("instructions") > 0)) {
                this.forwardLine(line);
            }
        }
    }

    private void forwardLine(String line) {
        this.control.receiveProcessErrorLine(line);
    }

    private void forwardUnhandledError(String line) {
        this.control.receiveProcessErrorLine(line);
    }

    public void streamClosed() {
        this.control.notifyEvent(303);
    }

    public void streamError(Exception e) {
        this.control.notifyEvent(303);
    }
}

