/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.core;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.preferences.ui.PreferenceConstants;
import org.eclipse.ptp.cell.sputiming.Activator;
import org.eclipse.ptp.cell.sputiming.core.CommonOperations;
import org.eclipse.ptp.cell.sputiming.core.ExternalTools;
import org.eclipse.ptp.cell.sputiming.core.Messages;
import org.eclipse.ptp.cell.sputiming.debug.Debug;
import org.eclipse.ptp.cell.sputiming.execution.CompilerParameters;
import org.eclipse.ptp.cell.sputiming.execution.SPUTimingExecution;
import org.eclipse.ptp.cell.sputiming.execution.SPUTimingParameters;
import org.eclipse.ui.console.IOConsole;

public class PopupActionDelegate {
    IFile selectedFile;
    private IProject project;
    private CommonOperations commonOperations;

    public PopupActionDelegate(IFile selectedFile) {
        this.selectedFile = selectedFile;
        this.project = selectedFile.getProject();
        this.commonOperations = new CommonOperations(this.project, selectedFile.getLocation());
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("SPU Timing", 3);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Source file: ''{0}''; Project: ''{1}''", new Object[]{this.selectedFile.toString(), this.project.getName()});
        this.checkBuildInfo();
        IManagedBuildInfo managedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Got managed build info for project: name {0}", new Object[]{managedBuildInfo.getConfigurationName()});
        this.checkSPEProjectType();
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Valid SPE project.");
        IConfiguration activeConfiguration = managedBuildInfo.getSelectedConfiguration() != null ? managedBuildInfo.getSelectedConfiguration() : managedBuildInfo.getDefaultConfiguration();
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Got active configuration: id {0}; base id: {1}; name: {2}", new Object[]{activeConfiguration.getId(), activeConfiguration.getBaseId(), activeConfiguration.getName()});
        ITool compilerTool = this.getCompilerTool(activeConfiguration, managedBuildInfo);
        String compilerCmd = this.getCompilerCommand(activeConfiguration, compilerTool);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Got compiler tool: id {0}; base id: {1}; name: {2}", new Object[]{compilerTool.getId(), compilerTool.getBaseId(), compilerTool.getName()});
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Compiler command: {0}", new Object[]{compilerCmd});
        String[] compilerEnvironmentPath = this.getEnvironmentPath(activeConfiguration);
        IOConsole console = this.commonOperations.createConsole(Messages.LaunchConfigurationDelegate_Console_Name);
        CompilerParameters compParam = new CompilerParameters();
        compParam.setCompilerName(compilerCmd);
        compParam.setCompilerEnvironmentPath(compilerEnvironmentPath);
        compParam.setSourceFile(this.selectedFile.getLocation().toOSString());
        compParam.setCompilerFlags(this.getCompilerFlags(managedBuildInfo, compilerTool));
        compParam.setWorkingDirectory(this.commonOperations.getWorkingDirectory().toFile());
        compParam.setConsole(console);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Discovered compiler parameters: {0}", new Object[]{compParam.toString()});
        PreferenceConstants preferences = PreferenceConstants.getInstance();
        String sputimingcommand = preferences.getTIMING_SPUBIN().toOSString();
        String spu_timing_param = this.getArchitectureParameter(compilerTool);
        SPUTimingParameters spuTimingParam = new SPUTimingParameters();
        spuTimingParam.setSputimingPath(sputimingcommand);
        spuTimingParam.setInputFile(this.commonOperations.getAssemblyFilePath().toOSString());
        spuTimingParam.setWorkingDirectory(this.commonOperations.getWorkingDirectory().toFile());
        spuTimingParam.setConsole(console);
        spuTimingParam.setParameters(spu_timing_param);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Discovered sputiming parameters: {0}", new Object[]{spuTimingParam.toString()});
        this.commonOperations.createWorkingDirectory(monitor);
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        SPUTimingExecution spuexec = SPUTimingExecution.createExecution(compParam, spuTimingParam);
        monitor.worked(1);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Request to compiler");
        spuexec.startCompiler();
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        monitor.worked(1);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Request to sputiming");
        spuexec.startSPUTimingTool();
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        monitor.worked(1);
        Path sputiminggenfile = new Path(String.valueOf(spuTimingParam.getInputFile()) + ".timing");
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Read output file: ''{0}''", new Object[]{sputiminggenfile.toString()});
        this.commonOperations.displayOutputFile((IPath)sputiminggenfile, console);
        Debug.POLICY.trace(Debug.DEBUG_POPUP_ACTION, "Request to extension points");
        ExternalTools.callExtensions((IPath)sputiminggenfile);
    }

    private String[] getEnvironmentPath(IConfiguration activeConfiguration) {
        Debug.POLICY.enter(Debug.DEBUG_COMPILER);
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)activeConfiguration);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable path = mngr.getVariable("PATH", cfgDes, true);
        Object[] pathValues = path.getValue().split(path.getDelimiter());
        Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Environment path: {0}", pathValues);
        Debug.POLICY.exit(Debug.DEBUG_COMPILER);
        return pathValues;
    }

    private String getArchitectureParameter(ITool compilerTool) throws CoreException {
        IOption option = null;
        String spu_timing_param = null;
        option = compilerTool.getOptionBySuperClassId("cell.spu.gnu.c.compiler.option.arch");
        if (option == null) {
            option = compilerTool.getOptionBySuperClassId("cell.spu.xl.c.compiler.option.arch");
        }
        if (option == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_CheckBuildInfo_ProjectTypeNotSupported, null));
        }
        String value = null;
        try {
            value = option.getStringValue();
        }
        catch (BuildException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_CheckBuildInfo_CannotExtractArchitectureInfo, (Throwable)e));
        }
        if (value.equals("cell.spu.gnu.option.arch.cell")) {
            spu_timing_param = "-march=cell";
        } else if (value.equals("cell.spu.gnu.option.arch.celledp")) {
            spu_timing_param = "-march=celledp";
        } else if (value.equals("cell.spu.xl.option.arch.cell")) {
            spu_timing_param = "-march=cell";
        } else if (value.equals("cell.spu.xl.option.arch.celledp")) {
            spu_timing_param = "-march=celledp";
        }
        return spu_timing_param;
    }

    private String getOutputFlagBlock(ITool compilerTool) throws CoreException {
        return String.valueOf(compilerTool.getOutputFlag()) + this.commonOperations.getAssemblyFilePath().toOSString();
    }

    private String getCompilerFlags(IManagedBuildInfo managedBuildInfo, ITool compilerTool) throws CoreException {
        String flaglist = null;
        try {
            flaglist = String.valueOf(compilerTool.getToolCommandFlagsString(this.selectedFile.getLocation(), this.getCompilerObjectFilePath(managedBuildInfo))) + " " + this.getOutputFlagBlock(compilerTool) + " -S";
        }
        catch (BuildException e1) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_GetCompilerFlags_CannotExtractInformation, (Throwable)e1));
        }
        return flaglist;
    }

    private IPath getCompilerObjectFilePath(IManagedBuildInfo managedBuildInfo) {
        String compBuildDir = managedBuildInfo.getConfigurationName();
        String outputExt = managedBuildInfo.getOutputExtension(this.selectedFile.getFileExtension());
        IPath compilerOutputFilePath = this.selectedFile.getLocation().removeLastSegments(1).addTrailingSeparator().append(compBuildDir).addTrailingSeparator().append(String.valueOf(this.commonOperations.getOutputFilenameWithoutExtension()) + "." + outputExt);
        return compilerOutputFilePath;
    }

    private IPath getActualObjectFilePath(IManagedBuildInfo managedBuildInfo) {
        String outputExt = managedBuildInfo.getOutputExtension(this.selectedFile.getFileExtension());
        IPath outputFilePath = this.commonOperations.getWorkingDirectory().addTrailingSeparator().append(String.valueOf(this.commonOperations.getOutputFilenameWithoutExtension()) + "." + outputExt);
        return outputFilePath;
    }

    private String getCompilerCommand(IConfiguration activeConfiguration, ITool compilerTool) throws CoreException {
        String compilerCmd = compilerTool.getToolCommand();
        String resolvedCompilerCmd = null;
        try {
            resolvedCompilerCmd = ManagedBuildManager.getBuildMacroProvider().resolveValue(compilerCmd, "", "", 3, (Object)activeConfiguration);
        }
        catch (BuildMacroException e2) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_GetCompilerCommand_CannotResolveName, (Throwable)e2));
        }
        if (resolvedCompilerCmd == null || resolvedCompilerCmd.equals("")) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_GetCompilerCommand_CannotExtractBuildCommand, null));
        }
        return resolvedCompilerCmd;
    }

    private ITool getCompilerTool(IConfiguration activeConfiguration, IManagedBuildInfo managedBuildInfo) throws CoreException {
        IResourceConfiguration resconf = activeConfiguration.getResourceConfiguration(this.selectedFile.getFullPath().toOSString());
        ITool compilerTool = resconf == null ? managedBuildInfo.getToolFromInputExtension(this.selectedFile.getFileExtension()) : resconf.getTools()[0];
        if (compilerTool == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_GetCompilerTool_ProblemFetchingCompilerTool, null));
        }
        return compilerTool;
    }

    private void checkSPEProjectType() throws CoreException {
        IProjectType projecttype = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getProjectType();
        if (projecttype.getBaseId().indexOf("cell.managedbuild.target.cell.spu") == -1) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_CheckSPEProjectType_NotSPEProject, null));
        }
    }

    private void checkBuildInfo() throws CoreException {
        if (!ManagedBuildManager.canGetBuildInfo((IResource)this.project)) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PopupActionDelegate_CheckBuildInfo_CannotExtractBuildInfo, null));
        }
    }
}

