/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PTPLaunchPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.launch";
    public static final String EXTENSION_POINT_ID = "rmLaunchConfigurations";
    private static PTPLaunchPlugin plugin;
    private ResourceBundle resourceBundle;
    private final Map<Class<? extends IResourceManager>, AbstractRMLaunchConfigurationFactory> rmLaunchConfigurationFactories = new HashMap<Class<? extends IResourceManager>, AbstractRMLaunchConfigurationFactory>();

    public static void errorDialog(String message, IStatus status) {
        PTPLaunchPlugin.log(status);
        Shell shell = PTPLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        PTPLaunchPlugin.log(t);
        Shell shell = PTPLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PTPLaunchPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PTPLaunchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PTPLaunchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PTPLaunchPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPLaunchPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (PTPLaunchPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPLaunchPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPLaunchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PTPLaunchPlugin.log((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static void logErrorMessage(String message) {
        PTPLaunchPlugin.log((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public PTPLaunchPlugin() {
        plugin = this;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.launch.LaunchPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public AbstractRMLaunchConfigurationFactory getRMLaunchConfigurationFactory(IResourceManager rm) {
        if (rm == null) {
            return null;
        }
        return this.rmLaunchConfigurationFactories.get(rm.getClass());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.retrieveRMLaunchConfigurationFactories();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.rmLaunchConfigurationFactories.clear();
        plugin = null;
        this.resourceBundle = null;
    }

    public IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] rms = universe.getResourceManagers();
        String rmUniqueName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED && rm.getUniqueName().equals(rmUniqueName)) {
                return rm;
            }
            ++n2;
        }
        return null;
    }

    public IPath verifyResource(String path, ILaunchConfiguration configuration) throws CoreException {
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(configuration);
        if (rm != null) {
            IResourceManagerConfiguration conf = rm.getConfiguration();
            if (conf instanceof AbstractRemoteResourceManagerConfiguration) {
                AbstractRemoteResourceManagerConfiguration remConf = (AbstractRemoteResourceManagerConfiguration)conf;
                IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(remConf.getRemoteServicesId());
                if (remoteServices != null) {
                    IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
                    IRemoteConnection conn = connMgr.getConnection(remConf.getConnectionName());
                    IRemoteFileManager fileManager = remoteServices.getFileManager(conn);
                    try {
                        Path resPath = new Path(path);
                        IFileStore res = fileManager.getResource((IPath)resPath, (IProgressMonitor)new NullProgressMonitor());
                        if (res.fetchInfo().exists()) {
                            return resPath;
                        }
                    }
                    catch (IOException iOException) {}
                }
            } else {
                Path resPath = new Path(path);
                if (resPath.toFile().exists()) {
                    return resPath;
                }
            }
        }
        return null;
    }

    private void retrieveRMLaunchConfigurationFactories() {
        this.rmLaunchConfigurationFactories.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractRMLaunchConfigurationFactory factory = (AbstractRMLaunchConfigurationFactory)ce.createExecutableExtension("class");
                    Class<? extends IResourceManager> resourceManagerClass = factory.getResourceManagerClass();
                    this.rmLaunchConfigurationFactories.put(resourceManagerClass, factory);
                }
                catch (CoreException e) {
                    PTPLaunchPlugin.log(e);
                }
                ++i;
            }
            ++iext;
        }
    }
}

