/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl;

import java.util.List;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.CallGraphNode;

public class ResourceCollector
extends ASTVisitor {
    protected ICallGraph CG_;
    protected IFile file_;
    protected int depth;

    public ResourceCollector(ICallGraph cg, IFile file) {
        this.CG_ = cg;
        this.file_ = file;
    }

    public void run() {
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        IASTTranslationUnit ast_ = null;
        try {
            ast_ = CDOM.getInstance().getASTService().getTranslationUnit(this.file_, CDOM.getInstance().getCodeReaderFactory(0));
        }
        catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {}
        this.depth = 0;
        ast_.accept((ASTVisitor)this);
    }

    public int visit(IASTDeclaration declaration) {
        String filename = declaration.getContainingFilename();
        if (filename.endsWith(".h")) {
            return 1;
        }
        if (declaration instanceof IASTFunctionDefinition) {
            ++this.depth;
            IASTFunctionDefinition fd = (IASTFunctionDefinition)declaration;
            ICallGraphNode node = this.addCallGraphNode(this.file_, filename, fd);
            this.CG_.addNode(node);
            return 1;
        }
        if (declaration instanceof IASTSimpleDeclaration) {
            if (this.depth > 0) {
                return 1;
            }
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)declaration;
            if (sdecl.getDeclarators() == null) {
                return 3;
            }
            IASTDeclSpecifier spec = sdecl.getDeclSpecifier();
            if (spec instanceof IASTCompositeTypeSpecifier || spec instanceof IASTElaboratedTypeSpecifier || spec instanceof IASTEnumerationSpecifier) {
                return 1;
            }
            List<String> env = this.CG_.getEnv();
            IASTDeclarator[] declarators = sdecl.getDeclarators();
            int j = 0;
            while (j < declarators.length) {
                IASTName n;
                String var;
                if (!(declarators[j] instanceof IASTFunctionDeclarator) && !this.doQuickOptionalTest(var = (n = declarators[j].getName()).toString())) {
                    if (!env.contains(var)) {
                        env.add(var);
                    }
                    this.doOtherDeClaratorStuff(declarators[j]);
                }
                ++j;
            }
        }
        return 3;
    }

    public int leave(IASTDeclaration declaration) {
        String filename = declaration.getContainingFilename();
        if (filename.endsWith(".h")) {
            return 1;
        }
        if (declaration instanceof IASTFunctionDefinition) {
            --this.depth;
            return 1;
        }
        return 3;
    }

    protected ICallGraphNode addCallGraphNode(IFile file, String filename, IASTFunctionDefinition fd) {
        CallGraphNode cgnode = new CallGraphNode((IResource)file, filename, fd);
        return cgnode;
    }

    protected boolean doQuickOptionalTest(String var) {
        return true;
    }

    protected void doOtherDeClaratorStuff(IASTDeclarator declarator) {
    }
}

