/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.includebrowser;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.includebrowser.AbstractIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;

public class LocalIncludeBrowserService
extends AbstractIncludeBrowserService {
    private static final IIndexInclude[] EMPTY = new IIndexInclude[0];

    private IIndexInclude[] findIncludedBy(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludedBy(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    int i = 0;
                    while (i < files.length) {
                        IIndexInclude[] includes = index.findIncludedBy(files[i]);
                        int j = 0;
                        while (j < includes.length) {
                            IIndexInclude indexInclude = includes[j];
                            if (handled.add(indexInclude.getIncludedByLocation())) {
                                list.add(indexInclude);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return new IIndexInclude[0];
    }

    private IIndexInclude[] findIncludesTo(IIndex index, IIndexFileLocation ifl, IProgressMonitor pm) {
        try {
            if (ifl != null) {
                IIndexFile[] files = index.getFiles(ifl);
                if (files.length == 1) {
                    return index.findIncludes(files[0]);
                }
                if (files.length > 0) {
                    ArrayList<IIndexInclude> list = new ArrayList<IIndexInclude>();
                    HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                    int i = 0;
                    while (i < files.length) {
                        IIndexInclude[] includes = index.findIncludes(files[i]);
                        int j = 0;
                        while (j < includes.length) {
                            IIndexInclude indexInclude = includes[j];
                            if (handled.add(indexInclude.getIncludesLocation())) {
                                list.add(indexInclude);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray(new IIndexInclude[list.size()]);
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return new IIndexInclude[0];
    }

    public IIndexInclude[] findIncludedBy(IIndexFileLocation ifl, IProgressMonitor progress) {
        IIndex index;
        try {
            ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
            index = CCorePlugin.getIndexManager().getIndex(scope);
            index.acquireReadLock();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return EMPTY;
        }
        catch (InterruptedException interruptedException) {
            return EMPTY;
        }
        try {
            IIndexInclude[] iIndexIncludeArray = this.findIncludedBy(index, ifl, progress);
            return iIndexIncludeArray;
        }
        finally {
            index.releaseReadLock();
        }
    }

    public IIndexInclude[] findIncludesTo(IIndexFileLocation ifl, IProgressMonitor progress) {
        IIndex index;
        try {
            ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
            index = CCorePlugin.getIndexManager().getIndex(scope);
            index.acquireReadLock();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return EMPTY;
        }
        catch (InterruptedException interruptedException) {
            return EMPTY;
        }
        try {
            IIndexInclude[] iIndexIncludeArray = this.findIncludesTo(index, ifl, progress);
            return iIndexIncludeArray;
        }
        finally {
            index.releaseReadLock();
        }
    }

    public IIndexInclude findInclude(IInclude input) throws CoreException {
        ICProject project = input.getCProject();
        if (project != null) {
            IIndexInclude iIndexInclude;
            IIndex index = CCorePlugin.getIndexManager().getIndex(project);
            index.acquireReadLock();
            try {
                iIndexInclude = IndexQueries.elementToInclude(index, input);
            }
            catch (Throwable throwable) {
                try {
                    index.releaseReadLock();
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            index.releaseReadLock();
            return iIndexInclude;
        }
        return null;
    }
}

