/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.remotemake.RemoteRunSIProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteGCCSpecsRunSIProvider
extends RemoteRunSIProvider {
    public static final String SPECS_FILE_PATH_VAR = "${specs_file_path}";
    public static final String SPECS_FOLDER_NAME = ".specs";

    @Override
    protected List<String> getCommand(IProject project, String providerId, IScannerConfigBuilderInfo2 buildInfo) {
        IFile specsFile;
        String gcc = buildInfo.getProviderRunCommand(providerId);
        String args = buildInfo.getProviderRunArguments(providerId);
        String specsFileName = RemoteGCCSpecsRunSIProvider.getSpecsFileName(project);
        if (gcc == null || args == null || specsFileName == null) {
            return null;
        }
        try {
            specsFile = RemoteGCCSpecsRunSIProvider.createSpecsFile(project, specsFileName);
        }
        catch (CoreException e) {
            RDTLog.logError(e);
            return null;
        }
        String specsFilePath = specsFile.getLocationURI().getRawPath();
        args = args.replace(SPECS_FILE_PATH_VAR, specsFilePath);
        ArrayList<String> command = new ArrayList<String>();
        command.add(gcc);
        String[] stringArray = args.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            command.add(arg);
            ++n2;
        }
        return command;
    }

    private static IFile createSpecsFile(IProject project, String specsFileName) throws CoreException {
        IFile specsFile;
        IFolder specsFolder = project.getFolder(SPECS_FOLDER_NAME);
        if (!specsFolder.exists()) {
            specsFolder.create(4096, true, null);
        }
        if (!(specsFile = specsFolder.getFile(specsFileName)).exists()) {
            ByteArrayInputStream is = new ByteArrayInputStream("\n".getBytes());
            specsFile.create((InputStream)is, true, null);
        }
        return specsFile;
    }

    private static String getSpecsFileName(IProject project) {
        block4: {
            try {
                if (!project.hasNature("org.eclipse.cdt.core.ccnature")) break block4;
                return "specs.cpp";
            }
            catch (CoreException coreException) {}
        }
        if (project.hasNature("org.eclipse.cdt.core.cnature")) {
            return "specs.c";
        }
        return null;
    }
}

