/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.internal.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
implements IService {
    private String serviceId;
    private String serviceName;
    private Set<String> serviceNatures;
    private Set<IServiceProviderDescriptor> serviceProviderDescriptors = new HashSet<IServiceProviderDescriptor>();
    private Map<String, IServiceProviderDescriptor> idToServiceProviderDescriptorMap = new HashMap<String, IServiceProviderDescriptor>();

    public Service(String id, String name, Set<String> natures) {
        this.serviceId = id;
        this.serviceName = name;
        this.serviceNatures = natures;
    }

    @Override
    public void addServiceProvider(IServiceProviderDescriptor provider) {
        this.serviceProviderDescriptors.add(provider);
        this.idToServiceProviderDescriptorMap.put(provider.getId(), provider);
    }

    @Override
    public String getId() {
        return this.serviceId;
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public Set<String> getNatures() {
        return this.serviceNatures;
    }

    @Override
    public Set<IServiceProviderDescriptor> getProviders() {
        return this.serviceProviderDescriptors;
    }

    @Override
    public void removeServiceProvider(IServiceProviderDescriptor provider) {
        this.serviceProviderDescriptors.remove(provider);
        this.idToServiceProviderDescriptorMap.remove(provider.getId());
    }

    @Override
    public IServiceProviderDescriptor getProviderDescriptor(String id) {
        return this.idToServiceProviderDescriptorMap.get(id);
    }

    public boolean equals(Object o) {
        if (o instanceof IService) {
            return ((IService)o).getId().equals(this.serviceId);
        }
        return false;
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    public String toString() {
        return "Service(" + this.serviceId + ")";
    }
}

