/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteCIndexServiceProvider;
import org.eclipse.ptp.internal.rdt.ui.contentassist.IContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.contentassist.RemoteContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.search.ISearchService;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchService;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.ui.IMemento;

public class RemoteCIndexServiceProvider
extends AbstractRemoteCIndexServiceProvider
implements IIndexServiceProvider2 {
    public static final String ID = "org.eclipse.ptp.rdt.ui.RemoteCIndexServiceProvider";
    private static final String HOST_NAME_KEY = "host-name";
    private RemoteSearchService fSearchService;
    private IContentAssistService fContentAssistService;

    public RemoteCIndexServiceProvider(String id, String name, String serviceId) {
        super(id, name, serviceId);
    }

    public RemoteCIndexServiceProvider() {
        this(ID, NAME, "org.eclipse.ptp.rdt.core.CIndexingService");
    }

    public void restoreState(IMemento providerMemento) {
        this.fHostName = providerMemento.getString(HOST_NAME_KEY);
    }

    public void saveState(IMemento providerMemento) {
        providerMemento.putString(HOST_NAME_KEY, this.fHostName);
    }

    public synchronized ISearchService getSearchService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fSearchService == null) {
            this.fSearchService = new RemoteSearchService(this.fHost, this.fConnectorService);
        }
        return this.fSearchService;
    }

    public synchronized IContentAssistService getContentAssistService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fContentAssistService == null) {
            this.fContentAssistService = new RemoteContentAssistService(this.fHost, this.fConnectorService);
        }
        return this.fContentAssistService;
    }

    public boolean isConfigured() {
        if (this.fHost == null && this.fHostName != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = SystemStartHere.getConnections();
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost host = iHostArray[n2];
                if (host.getAliasName().equals(this.fHostName)) {
                    this.setConnection(host, RemoteCIndexServiceProvider.getDStoreConnectorService(host));
                }
                ++n2;
            }
        }
        return super.isConfigured();
    }

    public static IConnectorService getDStoreConnectorService(IHost host) {
        IConnectorService[] connectorServices = host.getConnectorServices();
        int k = 0;
        while (k < connectorServices.length) {
            if (connectorServices[k] instanceof DStoreConnectorService) {
                return connectorServices[k];
            }
            ++k;
        }
        return null;
    }

    public String getConfigurationString() {
        if (this.isConfigured()) {
            return this.fHost.getName();
        }
        return null;
    }

    public String toString() {
        return "RemoteCIndexServiceProvider(" + this.fHostName + ")";
    }
}

