/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.IRemoteUIServicesDelegate;
import org.eclipse.ptp.remote.ui.IRemoteUIServicesFactory;

public class RemoteUIServicesProxy
implements IRemoteUIServices {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private IRemoteUIServicesFactory factory = null;
    private IRemoteUIServicesDelegate delegate = null;
    private IRemoteServices services = null;

    private static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Missing " + name + " attribute");
    }

    public RemoteUIServicesProxy(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = RemoteUIServicesProxy.getAttribute(configElement, ATTR_ID, null);
        this.name = RemoteUIServicesProxy.getAttribute(configElement, ATTR_NAME, this.id);
        RemoteUIServicesProxy.getAttribute(configElement, ATTR_CLASS, null);
    }

    public IRemoteUIServicesFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        try {
            this.factory = (IRemoteUIServicesFactory)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {
            PTPRemoteCorePlugin.log((String)("Failed to instatiate factory: " + this.configElement.getAttribute(ATTR_CLASS) + " in type: " + this.id + " in plugin: " + this.configElement.getDeclaringExtension().getNamespaceIdentifier()));
        }
        return this.factory;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IRemoteUIConnectionManager getUIConnectionManager() {
        this.loadServices();
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getUIConnectionManager();
    }

    public IRemoteUIFileManager getUIFileManager() {
        this.loadServices();
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getUIFileManager();
    }

    public void setServices(IRemoteServices services) {
        this.services = services;
    }

    private void loadServices() {
        IRemoteUIServicesFactory factory;
        if (this.delegate == null && (factory = this.getFactory()) != null) {
            this.delegate = factory.getServices(this.services);
        }
    }
}

