/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.rm.core.ToolsRMPlugin;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

public abstract class AbstractRemoteCommandJob
extends Job {
    static final String EMPTY_STRING = "";
    String command;
    String interruptedErrorMessage;
    String processErrorMessage;
    String parsingErrorMessage;
    int reschedule = 0;
    IRemoteProcess jobProcess;
    AbstractToolRuntimeSystem rtSystem;

    public AbstractRemoteCommandJob(AbstractToolRuntimeSystem rtSystem, String name, String command, String interruptedErrorMessage, String processErrorMessage, String parsingErrorMessage) {
        super(name);
        this.rtSystem = rtSystem;
        this.command = command;
        this.interruptedErrorMessage = interruptedErrorMessage;
        this.processErrorMessage = processErrorMessage;
        this.parsingErrorMessage = parsingErrorMessage;
    }

    public AbstractRemoteCommandJob(AbstractToolRuntimeSystem rtSystem, String name, String command, String interruptedErrorMessage, String processErrorMessage, String parsingErrorMessage, int reschedule) {
        super(name);
        this.rtSystem = rtSystem;
        this.command = command;
        this.interruptedErrorMessage = interruptedErrorMessage;
        this.processErrorMessage = processErrorMessage;
        this.parsingErrorMessage = parsingErrorMessage;
        this.reschedule = reschedule;
    }

    protected abstract void parse(BufferedReader var1) throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        AbstractRemoteCommandJob abstractRemoteCommandJob;
        IStatus iStatus;
        try {
            IStatus parseStatus;
            block33: {
                Assert.isNotNull((Object)((Object)this.rtSystem));
                Assert.isNotNull((Object)this.command);
                Assert.isTrue((!this.command.trim().equals(EMPTY_STRING) ? 1 : 0) != 0);
                ArgumentParser argumentParser = new ArgumentParser(this.command);
                List arguments = argumentParser.getTokenList();
                this.checkCancel(monitor);
                try {
                    IRemoteProcessBuilder cmdBuilder = this.rtSystem.createProcessBuilder(arguments);
                    AbstractRemoteCommandJob abstractRemoteCommandJob2 = this;
                    synchronized (abstractRemoteCommandJob2) {
                        DebugUtil.trace(DebugUtil.COMMAND_TRACING, "Run command: {0}", this.command);
                        this.jobProcess = cmdBuilder.start();
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", this.processErrorMessage, (Throwable)e));
                }
                this.checkCancel(monitor);
                BufferedReader stdout = new BufferedReader(new InputStreamReader(this.jobProcess.getInputStream()));
                parseStatus = Status.OK_STATUS;
                try {
                    this.parse(stdout);
                }
                catch (CoreException e) {
                    DebugUtil.error(DebugUtil.COMMAND_TRACING_MORE, "Command parsing failed: {0}", new Object[]{e});
                    parseStatus = e.getStatus();
                    if (parseStatus.getSeverity() != 4) break block33;
                    throw e;
                }
            }
            this.checkCancel(monitor);
            try {
                DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: waiting to finish.");
                this.jobProcess.waitFor();
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(1, "org.eclipse.ptp.rm.core", this.interruptedErrorMessage, (Throwable)e));
            }
            DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: exit value {0}.", this.jobProcess.exitValue());
            if (this.reschedule > 0) {
                DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: reschedule in {0} miliseconds.", this.reschedule);
                this.schedule(this.reschedule);
            }
            iStatus = parseStatus;
            abstractRemoteCommandJob = this;
        }
        catch (CoreException e) {
            DebugUtil.error(DebugUtil.COMMAND_TRACING_MORE, "Command failed: {0}", new Object[]{e});
            Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractRemoteCommandJob_Exception_CommandFailed, (Throwable)e);
            AbstractRemoteCommandJob abstractRemoteCommandJob3 = this;
            synchronized (abstractRemoteCommandJob3) {
                if (this.jobProcess != null) {
                    this.jobProcess.destroy();
                }
                this.jobProcess = null;
            }
            return status;
        }
        catch (Exception e2) {
            DebugUtil.error(DebugUtil.COMMAND_TRACING_MORE, "Command failed: {0}", e2);
            Status status = new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractRemoteCommandJob_Exception_InternalError, (Throwable)e2);
            AbstractRemoteCommandJob abstractRemoteCommandJob4 = this;
            {
                catch (Throwable throwable) {
                    AbstractRemoteCommandJob abstractRemoteCommandJob5 = this;
                    synchronized (abstractRemoteCommandJob5) {
                        if (this.jobProcess != null) {
                            this.jobProcess.destroy();
                        }
                        this.jobProcess = null;
                    }
                    throw throwable;
                }
            }
            synchronized (abstractRemoteCommandJob4) {
                if (this.jobProcess != null) {
                    this.jobProcess.destroy();
                }
                this.jobProcess = null;
            }
            return status;
        }
        synchronized (abstractRemoteCommandJob) {
            if (this.jobProcess != null) {
                this.jobProcess.destroy();
            }
            this.jobProcess = null;
        }
        return iStatus;
    }

    private void checkCancel(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new CoreException((IStatus)new Status(1, "org.eclipse.ptp.rm.core", this.interruptedErrorMessage, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        AbstractRemoteCommandJob abstractRemoteCommandJob = this;
        synchronized (abstractRemoteCommandJob) {
            if (this.jobProcess != null) {
                this.jobProcess.destroy();
                this.jobProcess = null;
            }
        }
    }
}

