/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIApplicationAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIJobAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPINodeAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMap;

public class OpenMPIProcessMapText12Parser {
    OpenMPIProcessMap map = new OpenMPIProcessMap();
    int numApplications;
    int numNodes;

    private OpenMPIProcessMapText12Parser() {
    }

    public static OpenMPIProcessMap parse(InputStream is) throws IOException {
        OpenMPIProcessMapText12Parser parser = new OpenMPIProcessMapText12Parser();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is), 1);
        parser.readStart(reader);
        parser.readVpid(reader);
        int i = 0;
        while (i < parser.numApplications) {
            parser.readAppContext(reader);
            ++i;
        }
        parser.readNumElements(reader);
        i = 0;
        while (i < parser.numNodes) {
            parser.readMappedNode(reader, i);
            ++i;
        }
        return parser.map;
    }

    /*
     * Unable to fully structure code
     */
    private void readMappedNode(BufferedReader reader, int nodeCounter) throws IOException {
        p = Pattern.compile("\\s*Mapped node:");
        while ((line = reader.readLine()) != null) {
            m = p.matcher(line);
            if (m.matches()) break;
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Cell:\\s*(\\S*)\\s*Nodename:\\s*(\\S*)\\s*Launch id:\\s*(\\S*)\\s*Username:\\s*(\\S*)");
        nodeName = "";
        while ((line = reader.readLine()) != null) {
            m = p.matcher(line);
            if (!m.matches()) continue;
            try {
                nodeName = m.group(2);
                break;
            }
            catch (NumberFormatException v0) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        node = new OpenMPIProcessMap.Node(nodeName);
        this.map.addNode(node);
        p = Pattern.compile("\\s*Daemon name:");
        while ((line = reader.readLine()) != null) {
            m = p.matcher(line);
            if (m.matches()) break;
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Data type:\\s*\\S*\\s*Data Value:\\s*\\S*");
        while ((line = reader.readLine()) != null) {
            m = p.matcher(line);
            if (m.matches()) break;
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Oversubscribed:\\s*(\\S*)\\s*Num elements in procs list:\\s*(\\d*)");
        numProcesses = 0;
        while ((line = reader.readLine()) != null) {
            m = p.matcher(line);
            if (!m.matches()) continue;
            try {
                s = m.group(1);
                if (s.equalsIgnoreCase("true")) {
                    node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getOversubscribedAttributeDefinition().create(Boolean.valueOf(true)));
                } else if (s.equalsIgnoreCase("false")) {
                    node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getOversubscribedAttributeDefinition().create(Boolean.valueOf(false)));
                } else {
                    throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
                }
                s = m.group(2);
                numProcesses = Integer.parseInt(s);
                break;
            }
            catch (NumberFormatException v1) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Mapped proc:");
        p2 = Pattern.compile("\\s*Proc Name:\\s*(\\S*)");
        p3 = Pattern.compile("\\s*Data type:\\s*\\S*\\s*Data Value:\\s*\\S*");
        p4 = Pattern.compile("\\s*Proc Rank:\\s*(\\d*)\\s*Proc PID:\\s*(\\d*)\\s*App_context index:\\s*(\\d*)");
        i = 0;
        while (i < numProcesses) {
            block28: {
                processName = "";
                processIndex = 0;
                processPid = 0;
                applicationIndex = 0;
                while ((line = reader.readLine()) != null) {
                    m = p.matcher(line);
                    if (m.matches()) break;
                }
                if (line != null) ** GOTO lbl77
                throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
lbl-1000:
                // 1 sources

                {
                    m = p2.matcher(line);
                    if (!m.matches()) continue;
                    processName = m.group(1);
                    break;
lbl77:
                    // 2 sources

                    ** while ((line = reader.readLine()) != null)
                }
lbl78:
                // 2 sources

                if (line != null) ** GOTO lbl-1000
                throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
                while (!(m = p3.matcher(line)).matches()) lbl-1000:
                // 2 sources

                {
                    if ((line = reader.readLine()) != null) continue;
                }
                if (line != null) ** GOTO lbl96
                throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
lbl-1000:
                // 1 sources

                {
                    m = p4.matcher(line);
                    if (!m.matches()) continue;
                    try {
                        s = m.group(1);
                        processIndex = Integer.parseInt(s);
                        s = m.group(2);
                        processPid = Integer.parseInt(s);
                        s = m.group(3);
                        applicationIndex = Integer.parseInt(s);
                        break;
                    }
                    catch (NumberFormatException v2) {
                        throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
                    }
lbl96:
                    // 2 sources

                    ** while ((line = reader.readLine()) != null)
                }
lbl97:
                // 2 sources

                if (line == null) {
                    throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
                }
                proc = new OpenMPIProcessMap.Process(node, processIndex, processName, applicationIndex);
                this.map.addProcess(proc);
                try {
                    proc.getAttributeManager().addAttribute((IAttribute)ProcessAttributes.getPIDAttributeDefinition().create(Integer.valueOf(processPid)));
                }
                catch (IllegalValueException v3) {
                    if (OpenMPIProcessMapText12Parser.$assertionsDisabled) break block28;
                    throw new AssertionError();
                }
            }
            ++i;
        }
    }

    private void readNumElements(BufferedReader reader) throws IOException {
        String line;
        Pattern p = Pattern.compile("\\s*Num elements in nodes list:\\s*(\\d*)");
        while ((line = reader.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            try {
                String s = m.group(1);
                this.numNodes = Integer.parseInt(s);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
    }

    private void readAppContext(BufferedReader reader) throws IOException {
        String s;
        Matcher m;
        int applicationIndex = 0;
        String applicationName = "";
        int numberOfProcessors = 0;
        Pattern p = Pattern.compile("\\s*Data for app_context:\\s*\\w*\\s*(\\d*)[^:]*:\\s*(.*)");
        String line = reader.readLine();
        if (line != null && (m = p.matcher(line)).matches()) {
            try {
                s = m.group(1);
                applicationIndex = Integer.parseInt(s);
                applicationName = s = m.group(2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        p = Pattern.compile("\\s*Num procs:\\s*(\\d*)");
        while ((line = reader.readLine()) != null) {
            m = p.matcher(line);
            if (!m.matches()) continue;
            try {
                s = m.group(1);
                numberOfProcessors = Integer.parseInt(s);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        OpenMPIProcessMap.Application application = new OpenMPIProcessMap.Application(applicationIndex, applicationName, numberOfProcessors);
        this.map.addApplication(application);
        Pattern p1 = Pattern.compile("\\s*Argv\\[\\d*\\]\\s*:\\s*(.*)");
        Pattern p2 = Pattern.compile("\\s*Env\\[\\d*\\]\\s*:\\s*(.*)");
        p = Pattern.compile("\\s*Working dir:\\s*(.*)");
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> environment = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m2 = p.matcher(line);
            if (m2.matches()) {
                String s2 = m2.group(1).trim();
                application.getAttributeManager().addAttribute((IAttribute)OpenMPIApplicationAttributes.getEffectiveOpenMPIWorkingDirAttributeDefinition().create(s2));
                break;
            }
            m2 = p1.matcher(line);
            if (m2.matches()) {
                arguments.add(m2.group(1));
                continue;
            }
            m2 = p2.matcher(line);
            if (!m2.matches()) continue;
            environment.add(m2.group(1));
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        application.getAttributeManager().addAttribute((IAttribute)OpenMPIApplicationAttributes.getEffectiveOpenMPIProgArgsAttributeDefinition().create((Comparable[])arguments.toArray(new String[arguments.size()])));
        application.getAttributeManager().addAttribute((IAttribute)OpenMPIApplicationAttributes.getEffectiveOpenMPIEnvAttributeDefinition().create((Comparable[])environment.toArray(new String[environment.size()])));
        int num_maps = 0;
        p = Pattern.compile("\\s*Num maps:\\s*(\\d*).*");
        while ((line = reader.readLine()) != null) {
            Matcher m3 = p.matcher(line);
            if (!m3.matches()) continue;
            try {
                String s3 = m3.group(1);
                num_maps = Integer.parseInt(s3);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
        int i = 0;
        while (i < num_maps) {
            line = reader.readLine();
            ++i;
        }
    }

    private void readVpid(BufferedReader reader) throws IOException {
        String line;
        Pattern p = Pattern.compile("\\s*Starting vpid:\\s*(\\d*)\\s*Vpid range:\\s*(\\w*)\\s*Num app_contexts:\\s*(\\w*).*");
        while ((line = reader.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            try {
                String s;
                block9: {
                    block8: {
                        s = m.group(1);
                        try {
                            this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getVpidStartAttributeDefinition().create(Integer.valueOf(Integer.parseInt(s))));
                        }
                        catch (IllegalValueException illegalValueException) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError();
                        }
                    }
                    s = m.group(2);
                    try {
                        this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getVpidRangeAttributeDefinition().create(Integer.valueOf(Integer.parseInt(s))));
                    }
                    catch (IllegalValueException illegalValueException) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                s = m.group(3);
                this.numApplications = Integer.parseInt(s);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_BrokenDisplayMapInformation);
        }
    }

    private void readStart(BufferedReader reader) throws IOException {
        String line;
        Pattern p = Pattern.compile("\\[([^:]*):(\\d*)\\]\\s*Map for job:\\s*(\\d*)[^:]*:\\s*(\\w*).*");
        while ((line = reader.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            try {
                block8: {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getHostnameAttributeDefinition().create(m.group(1)));
                    try {
                        this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getMpiJobIdAttributeDefinition().create(Integer.valueOf(Integer.parseInt(m.group(3)))));
                    }
                    catch (IllegalValueException illegalValueException) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                String mode = m.group(4);
                if (mode.equalsIgnoreCase("bynode")) {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getMappingModeAttributeDefinition().create((Enum)OpenMPIJobAttributes.MappingMode.BY_NODE));
                    break;
                }
                if (mode.equalsIgnoreCase("byslot")) {
                    this.map.getAttributeManager().addAttribute((IAttribute)OpenMPIJobAttributes.getMappingModeAttributeDefinition().create((Enum)OpenMPIJobAttributes.MappingMode.BY_SLOT));
                    break;
                }
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(NLS.bind((String)Messages.OpenMPIProcessMapText12Parser_Exception_InvalidLine, (Object)line));
            }
        }
        if (line == null) {
            throw new IOException(Messages.OpenMPIProcessMapText12Parser_Exception_MissingDisplayMapInformation);
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("test.txt");
            OpenMPIProcessMapText12Parser.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

