/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard.ui;

import java.io.File;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.Messages;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PdtWizardConfigurationFilePage
extends WizardPage {
    Frame configFileOptions;
    TextGroup configDir;
    TextGroup configFileName;

    public PdtWizardConfigurationFilePage() {
        super(PdtWizardConfigurationFilePage.class.getName());
        this.setTitle(Messages.PdtWizardConfigurationFilePage_Title);
        this.setDescription(Messages.PdtWizardConfigurationFilePage_Description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        FrameMold frMold = new FrameMold(FrameMold.HAS_FRAME);
        frMold.setColumns(1);
        frMold.setTitle(Messages.PdtWizardConfigurationFilePage_CreateControls_FrameLabel);
        this.configFileOptions = new Frame(composite, frMold);
        TextModifyListener textListener = new TextModifyListener();
        TextMold workspaceBrowseMold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.GRID_DATA_SPAN | TextMold.LABELABOVE | TextMold.HASBUTTON, Messages.PdtWizardConfigurationFilePage_CreateControls_Textbox_FolderLabel);
        this.configDir = new TextGroup(this.configFileOptions.getTopUserReservedComposite(), workspaceBrowseMold);
        this.configDir.addModifyListener((ModifyListener)textListener);
        Button browse = this.configDir.getButton();
        browse.setText(Messages.PdtWizardConfigurationFilePage_CreateControls_Button_WorkspaceLabel);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PdtWizardConfigurationFilePage.this.handleWorkspaceButtonEvent();
            }
        });
        TextMold tmold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.GRID_DATA_SPAN | TextMold.LABELABOVE, Messages.PdtWizardConfigurationFilePage_CreateControls_Textbox_FileLabel);
        this.configFileName = new TextGroup(this.configFileOptions.getTopUserReservedComposite(), tmold);
        this.configFileName.addModifyListener((ModifyListener)textListener);
        this.setControl((Control)composite);
        this.initializeControls();
    }

    protected void handleWorkspaceButtonEvent() {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)workspace, true, Messages.PdtWizardConfigurationFilePage_HandleWorkspaceButton_Dialog_SelectWorkspaceResource);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            Object[] r = dialog.getResult();
            IPath selectedPath = (IPath)r[0];
            this.configDir.setString(selectedPath.makeRelative().toOSString());
        }
    }

    public IPath getFilePath() {
        IPath path = new Path(this.configDir.getString()).append(this.configFileName.getString()).makeAbsolute();
        return path;
    }

    protected void validateControls() throws CoreException {
        MultiStatus interfaceStatus = new MultiStatus("org.eclipse.ptp.cell.pdt.xml", 0, "", null);
        String configDirWorkspaceRel = this.configDir.getString();
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
        File dir = new File(workspacePath.append(configDirWorkspaceRel).toOSString());
        if (configDirWorkspaceRel.trim().length() == 0 || !dir.exists()) {
            interfaceStatus.add((IStatus)new Status(4, "org.eclipse.ptp.cell.pdt.xml", 0, Messages.PdtWizardConfigurationFilePage_ValidateControls_Error_InvalidDirectory, null));
        }
        if (this.configFileName.getString() == null || this.configFileName.getString().trim().length() == 0) {
            interfaceStatus.add((IStatus)new Status(4, "org.eclipse.ptp.cell.pdt.xml", 0, Messages.PdtWizardConfigurationFilePage_ValidateControls_Error_EmptyFilename, null));
        }
        if (interfaceStatus.matches(4)) {
            throw new CoreException((IStatus)interfaceStatus);
        }
    }

    protected void validatePage() {
        this.setErrorMessage(null);
        this.setPageComplete(true);
        try {
            this.validateControls();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getChildren()[0].getMessage());
            this.setPageComplete(false);
        }
    }

    private void initializeControls() {
        IProject project = this.getProjectFromWorkbench();
        if (project != null) {
            this.configDir.setString(project.getName());
        }
    }

    private IProject getProjectFromWorkbench() {
        IProject project = null;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && activeWindow.getSelectionService().getSelection() != null) {
            IEditorInput editorInput;
            ISelection sel = activeWindow.getSelectionService().getSelection();
            if (sel instanceof TreeSelection) {
                TreeSelection tSel = (TreeSelection)sel;
                if (!tSel.isEmpty()) {
                    if (tSel.getFirstElement() instanceof IProject) {
                        project = (IProject)tSel.getFirstElement();
                    } else if (tSel.getFirstElement() instanceof IFile) {
                        project = ((IFile)tSel.getFirstElement()).getProject();
                    } else if (tSel.getFirstElement() instanceof IContainer) {
                        project = ((IContainer)tSel.getFirstElement()).getProject();
                    } else if (tSel.getFirstElement() instanceof ICContainer) {
                        ICProject cproj = ((ICContainer)tSel.getFirstElement()).getCProject();
                        project = cproj.getProject();
                    }
                }
            } else if (sel instanceof TextSelection && activeWindow.getActivePage() != null && activeWindow.getActivePage().getActiveEditor() != null && (editorInput = activeWindow.getActivePage().getActiveEditor().getEditorInput()) instanceof IPathEditorInput) {
                IPathEditorInput pathEditInput = (IPathEditorInput)activeWindow.getActivePage().getActiveEditor().getEditorInput();
                IPath fileAbsPath = pathEditInput.getPath().makeAbsolute();
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(fileAbsPath);
                project = file.getProject();
            }
        }
        return project;
    }

    protected class TextModifyListener
    implements ModifyListener {
        protected TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            PdtWizardConfigurationFilePage.this.validatePage();
        }
    }
}

