/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.core;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.simulator.core.Messages;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;

public class SimulatorOperationException
extends SimulatorException {
    private static final long serialVersionUID = -4045023542123850789L;
    public static final int UNKNOWN = 0;
    public static final int CREATE_WORKING_DIRECTORY = 1;
    public static final int DEPLOY_FILE = 2;
    public static final int WORKING_DIRECTORY_READONLY = 3;
    public static final int EXISTING_SIMULATOR_INSTANCE = 4;
    public static final int UNEXPECTED_EXCEPTION = 6;
    public static final int PATH_NOT_ABSOLUTE = 10001;
    public static final int PATH_NOT_EXIST = 10002;
    public static final int PATH_NOT_FILE = 10003;
    public static final int PATH_NOT_DIRECTORY = 10004;
    public static final int PATH_NOT_READABLE = 10005;
    public static final int PATH_NOT_WRITABLE = 10006;
    int reason;
    String what;

    public SimulatorOperationException(int reason) {
        super(SimulatorOperationException.translatedMessage(reason, null));
        this.reason = reason;
    }

    public SimulatorOperationException(int reason, Throwable cause) {
        super(SimulatorOperationException.translatedMessage(reason, null));
        this.reason = reason;
    }

    public SimulatorOperationException(int reason, String what, Throwable cause) {
        super(SimulatorOperationException.translatedMessage(reason, what));
        this.reason = reason;
        this.what = what;
    }

    public SimulatorOperationException(int reason, String what) {
        super(SimulatorOperationException.translatedMessage(reason, what));
        this.reason = reason;
        this.what = what;
    }

    public int getReason() {
        return this.reason;
    }

    public SimulatorOperationException() {
        super(Messages.SimulatorOperationException_DefaultMessage);
    }

    public SimulatorOperationException(String arg0, Throwable arg1) {
        super(arg0, arg1);
    }

    public SimulatorOperationException(String arg0) {
        super(arg0);
    }

    public SimulatorOperationException(Throwable arg0) {
        super(arg0);
    }

    private static String translatedMessage(int reason, String what) {
        String message = null;
        String thiswhat = what;
        if (thiswhat == null) {
            thiswhat = Messages.SimulatorOperationException_Unknown;
        }
        switch (reason) {
            case 1: {
                message = NLS.bind((String)Messages.SimulatorOperationException_CreateWorkingDirFailed, (Object)thiswhat);
                break;
            }
            case 2: {
                message = NLS.bind((String)Messages.SimulatorOperationException_DeployFileFailed, (Object)thiswhat);
                break;
            }
            case 3: {
                message = NLS.bind((String)Messages.SimulatorOperationException_WorkingDirNotWriteable, (Object)thiswhat);
                break;
            }
            case 4: {
                message = NLS.bind((String)Messages.SimulatorOperationException_WorkingDirInuse, null);
                break;
            }
            case 6: {
                message = NLS.bind((String)Messages.SimulatorOperationException_UnexpectedException, null);
                break;
            }
            case 10001: {
                message = NLS.bind((String)Messages.SimulatorOperationException_PathNotAbsolute, (Object)thiswhat);
                break;
            }
            case 10002: {
                message = NLS.bind((String)Messages.SimulatorOperationException_PathDoesNotExist, (Object)thiswhat);
                break;
            }
            case 10003: {
                message = NLS.bind((String)Messages.SimulatorOperationException_PathNotFile, (Object)thiswhat);
                break;
            }
            case 10004: {
                message = NLS.bind((String)Messages.SimulatorOperationException_PathNotDir, (Object)thiswhat);
                break;
            }
            case 10005: {
                message = NLS.bind((String)Messages.SimulatorOperationException_PathNotReadable, (Object)thiswhat);
                break;
            }
            case 10006: {
                message = NLS.bind((String)Messages.SimulatorOperationException_PathNotWriteable, (Object)thiswhat);
            }
        }
        return message;
    }
}

