/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.extensions;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.simulator.extensions.Architecture;
import org.eclipse.ptp.cell.simulator.extensions.Messages;
import org.osgi.framework.Bundle;

public class ArchitectureManager {
    static ArchitectureManager instance;
    Map architectures = new HashMap();

    public static ArchitectureManager getInstance() {
        if (instance == null) {
            instance = new ArchitectureManager();
        }
        return instance;
    }

    protected ArchitectureManager() {
        this.loadArchitectureExtensions();
    }

    private void loadArchitectureExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.cell.simulator.architecture");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IContributor contributor = extension.getContributor();
            String contributorName = contributor.getName();
            Bundle bundle = Platform.getBundle((String)contributorName);
            ILog log = Platform.getLog((Bundle)bundle);
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block11: {
                    String id = null;
                    String name = null;
                    String tclScriptPath = null;
                    URL tclScriptURL = null;
                    try {
                        IConfigurationElement element = elements[j];
                        id = element.getAttribute("id");
                        name = element.getAttribute("name");
                        tclScriptPath = element.getAttribute("tclscript");
                        if (name == null) {
                            throw new IllegalArgumentException(Messages.ArchitectureManager_MissingArchitectureName);
                        }
                        if (id == null) {
                            throw new IllegalArgumentException(Messages.ArchitectureManager_MissingArchitectureID);
                        }
                        id = String.valueOf(contributorName) + "." + id;
                        if (tclScriptPath == null) {
                            throw new IllegalArgumentException(Messages.ArchitectureManager_MissingArchitectureTCLScript);
                        }
                        tclScriptURL = FileLocator.find((Bundle)bundle, (IPath)new Path(tclScriptPath), null);
                        if (tclScriptURL == null) {
                            throw new IllegalArgumentException(NLS.bind((String)Messages.ArchitectureManager_TCLScriptFileNotFound, (Object)tclScriptPath));
                        }
                        try {
                            tclScriptURL = FileLocator.resolve((URL)tclScriptURL);
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException(NLS.bind((String)Messages.ArchitectureManager_TCLScriptURLNotResolved, (Object)tclScriptPath));
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.log((IStatus)new Status(4, contributorName, 0, Messages.ArchitectureManager_ExensionPointError, (Throwable)e));
                        break block11;
                    }
                    Architecture architecture = new Architecture(id, name, tclScriptPath, tclScriptURL);
                    this.architectures.put(architecture.getId(), architecture);
                }
                ++j;
            }
            ++i;
        }
    }

    public Architecture[] getArchitectures() {
        Collection set = this.architectures.values();
        Architecture[] result = new Architecture[set.size()];
        result = set.toArray(result);
        return result;
    }

    public Architecture getArchitecture(String architectureId) {
        return (Architecture)this.architectures.get(architectureId);
    }
}

