/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.makegen.gnu;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.ptp.cell.managedbuilder.debug.Debug;
import org.eclipse.ptp.cell.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.ptp.cell.managedbuilder.makegen.IManagedBuilderMakefileGenerator;

public class GnuMakefileGenerator
extends org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator
implements IManagedBuilderMakefileGenerator {
    protected static final String MESSAGE_COPY_FILE = ManagedMakeMessages.copyFile;
    protected static final String MESSAGE_CUSTOM_MAKEFILE_INCLUDES = ManagedMakeMessages.customMakefileIncludes;
    protected static final String MESSAGE_MAKEFILE_INCLUDES = ManagedMakeMessages.makefileIncludes;
    protected static final String MESSAGE_TOPMAKEFILE_ERROR = ManagedMakeMessages.topMakefileError;
    protected static final String MESSAGE_FILE_DOESNT_EXIST = ManagedMakeMessages.fileDoesntExist;
    protected static final String DEFAULT_ANNOUNCEMENT_PREFIX = "Tool.default.announcement";
    protected final String SPU_EMBED_TOOL_ID_MATCHING = "embedspu";
    protected final String EMPTY_STRING = new String();
    protected final String PHONY = ".PHONY";
    protected final String LINUX = "linux";
    protected static final String COPY_MACRO = "CP";
    protected static final String LINUX_COPY_COMMAND = "cp";
    private IProject project;
    private IProgressMonitor monitor;
    private String[] spuExecutables;
    private boolean[] spuExecutablesExist;
    private String[] spuObjTargets;
    private String embedSPUToolPrimaryInputExtension;

    public void initialize(int buildKind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_MAKEFILE, new Object[]{cfg.getId(), builder.getId()});
        this.project = cfg.getOwner().getProject();
        this.monitor = monitor;
        Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "Project: {0}", new Object[]{this.project.getName()});
        super.initialize(buildKind, cfg, builder, monitor);
        ITool[] buildTools = cfg.getFilteredTools();
        int i = 0;
        while (i < buildTools.length) {
            if (buildTools[i].getId().indexOf("embedspu") > -1) {
                ITool embedSPUTool = buildTools[i];
                this.embedSPUToolPrimaryInputExtension = embedSPUTool.getPrimaryInputExtensions()[0];
                Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "embedded spu tool: {0}; extension: {1}", new Object[]{embedSPUTool.getId(), this.embedSPUToolPrimaryInputExtension});
                IOption option = embedSPUTool.getOptionBySuperClassId(embedSPUTool.getPrimaryInputType().getOptionId());
                try {
                    if (option.getValueType() == 3) {
                        this.spuExecutables = option.getStringListValue();
                        this.spuExecutablesExist = new boolean[this.spuExecutables.length];
                        this.spuObjTargets = new String[this.spuExecutables.length];
                        int j = 0;
                        while (j < this.spuExecutables.length) {
                            String spuObj = this.spuExecutables[j];
                            this.spuExecutables[j] = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.spuExecutables[j], this.EMPTY_STRING, " ", 3, (Object)cfg);
                            this.spuExecutables[j] = this.spuExecutables[j].replaceAll("\"", this.EMPTY_STRING);
                            File spuObjFile = new File(this.spuExecutables[j]);
                            this.spuExecutablesExist[j] = spuObjFile.exists();
                            if (!this.spuExecutablesExist[j]) {
                                this.spuExecutables[j] = spuObj;
                                this.spuObjTargets[j] = null;
                            } else {
                                this.spuObjTargets[j] = String.valueOf(this.spuExecutables[j].substring(this.spuExecutables[j].lastIndexOf(47) + 1)) + "." + this.embedSPUToolPrimaryInputExtension;
                            }
                            Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "Executable: ''{0}''; Target: ''{1}''; Exist: ''{2}''", new Object[]{this.spuExecutables[j], this.spuObjTargets[j], this.spuExecutablesExist[j]});
                            ++j;
                        }
                        break;
                    }
                    Debug.POLICY.error(Debug.DEBUG_MAKEFILE, "Invalid sputiming option: {0}", new Object[]{option.getId()});
                    this.spuExecutables = null;
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_MAKEFILE, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                    this.spuExecutables = null;
                }
                break;
            }
            ++i;
        }
        Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_MAKEFILE);
        this.createSPUObjsDummyFiles();
        this.checkCancel();
        MultiStatus status = super.generateMakefiles(delta);
        this.populateImportSPUObjsMakefile();
        this.checkCancel();
        Debug.POLICY.exit(Debug.DEBUG_MAKEFILE, (Object)status.toString());
        return status;
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_MAKEFILE);
        this.createSPUObjsDummyFiles();
        this.checkCancel();
        MultiStatus status = super.regenerateMakefiles();
        this.populateImportSPUObjsMakefile();
        this.checkCancel();
        Debug.POLICY.exit(Debug.DEBUG_MAKEFILE, (Object)status.toString());
        return status;
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_MAKEFILE, new Object[]{fileHandle.getFullPath().toOSString()});
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addCustomTopHeader());
        buffer.append(this.addMacros());
        super.populateTopMakefile(fileHandle, rebuild);
        try {
            buffer.append(Util.getContent((IFile)fileHandle));
        }
        catch (IOException ioe) {
            GnuMakefileGenerator.outputCommentLine((StringBuffer)buffer);
            buffer.append("# " + MESSAGE_TOPMAKEFILE_ERROR + NEWLINE);
            GnuMakefileGenerator.outputCommentLine((StringBuffer)buffer);
            Debug.POLICY.error(Debug.DEBUG_MAKEFILE, (Throwable)ioe);
            Debug.POLICY.logStatus((IStatus)new Status(1, ManagedBuilderCorePlugin.getDefault().getBundle().getSymbolicName(), 0, fileHandle.getFullPath().toOSString(), (Throwable)ioe));
        }
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
        Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
    }

    protected StringBuffer addCustomTopHeader() {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_MAKEFILE);
        return GnuMakefileGenerator.addDefaultHeader();
    }

    protected StringBuffer addTopHeader() {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_MAKEFILE);
        return new StringBuffer();
    }

    protected StringBuffer addMacros() {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_MAKEFILE);
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + MESSAGE_CUSTOM_MAKEFILE_INCLUDES + NEWLINE);
        buffer.append("-include import_spu.mk" + NEWLINE + NEWLINE);
        buffer.append("# " + MESSAGE_MAKEFILE_INCLUDES + NEWLINE);
        return buffer.append(NEWLINE);
    }

    protected void populateImportSPUObjsMakefile() throws CoreException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_MAKEFILE);
        if (this.spuExecutables == null) {
            Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
            return;
        }
        if (this.spuExecutables.length == 0) {
            Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
            return;
        }
        IPath importSPUObjsMakefilePath = this.getTopBuildDir().append("import_spu.mk");
        IFile importSPUObjsMakefileHandle = this.createFile(importSPUObjsMakefilePath);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addImportSPUObjsMakefileHeader());
        if (Platform.getOS().equals("linux")) {
            buffer.append("CP := cp" + NEWLINE + NEWLINE);
        }
        int i = 0;
        while (i < this.spuExecutables.length) {
            if (this.spuExecutablesExist[i]) {
                Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "Rule for: {0}->{1}", new Object[]{this.spuExecutables[i], this.spuObjTargets[i]});
                buffer.append("../spu_objs/" + this.spuObjTargets[i] + ":" + " " + this.spuExecutables[i] + " " + NEWLINE);
                buffer.append("\t@" + GnuMakefileGenerator.escapedEcho((String)(String.valueOf(MESSAGE_COPY_FILE) + " " + "$<")));
                buffer.append("\t@" + GnuMakefileGenerator.escapedEcho((String)(String.valueOf(org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages.getResourceString((String)DEFAULT_ANNOUNCEMENT_PREFIX)) + " " + "$" + "(" + COPY_MACRO + ")")));
                String command = new String("$(CP) $< $@");
                buffer.append("\t@" + GnuMakefileGenerator.escapedEcho((String)command));
                buffer.append("\t@" + command + NEWLINE);
                buffer.append("\t@" + GnuMakefileGenerator.escapedEcho((String)(String.valueOf(MESSAGE_FINISH_FILE) + " " + "$@")));
                buffer.append("\t@" + ECHO_BLANK_LINE + NEWLINE + NEWLINE);
            } else {
                Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "Ignored: {0}", new Object[]{this.spuExecutables[i]});
            }
            ++i;
        }
        buffer.append(".PHONY:");
        i = 0;
        while (i < this.spuExecutables.length) {
            if (this.spuExecutablesExist[i]) {
                buffer.append(" ../spu_objs/" + this.spuObjTargets[i]);
            }
            ++i;
        }
        buffer.append(NEWLINE);
        Util.save((StringBuffer)buffer, (IFile)importSPUObjsMakefileHandle);
        Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
    }

    protected StringBuffer addImportSPUObjsMakefileHeader() {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_MAKEFILE);
        return GnuMakefileGenerator.addDefaultHeader();
    }

    protected void createSPUObjsDummyFiles() throws CoreException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_MAKEFILE);
        this.removeDirectory("spu_objs");
        if (this.spuExecutables == null) {
            Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
            return;
        }
        if (this.spuExecutables.length == 0) {
            Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
            return;
        }
        IPath spuObjsSourceDir = this.createDirectory("spu_objs");
        int i = 0;
        while (i < this.spuExecutables.length) {
            if (!this.spuExecutablesExist[i]) {
                Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "SPU executable does not exist: {0}", new Object[]{this.spuExecutables[i]});
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, NLS.bind((String)MESSAGE_FILE_DOESNT_EXIST, (Object)this.spuExecutables[i]), null));
            }
            Debug.POLICY.trace(Debug.DEBUG_MAKEFILE, "Create dummy file for: {0}->{1}", new Object[]{this.spuExecutables[i], this.spuObjTargets[i]});
            this.createFile(spuObjsSourceDir.append(this.spuObjTargets[i]));
            ++i;
        }
        Debug.POLICY.exit(Debug.DEBUG_MAKEFILE);
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
        }
        return folder.getFullPath();
    }

    private void removeDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (folder.exists()) {
            folder.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
    }

    private IFile createFile(IPath filePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation(filePath);
        if (file == null) {
            file = root.getFile(filePath);
        }
        if (!file.exists()) {
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    file.refreshLocal(0, null);
                }
                throw e;
            }
            if (!file.isDerived()) {
                file.setDerived(true);
            }
        }
        return file;
    }
}

