/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.IPSetManager;
import org.eclipse.ptp.debug.core.pdi.IPDISession;

public class PSetManager
implements IPSetManager {
    private final IPSession session;
    private final Map<String, BitList> setMap = new HashMap<String, BitList>();

    public PSetManager(IPSession session) {
        this.session = session;
        this.createSet("Root", session.getTasks());
    }

    public void addTasks(String sid, BitList tasks) {
        this.createSet(sid, tasks);
    }

    public void createSet(String sid, BitList tasks) {
        BitList oldTasks = this.getTasks(sid);
        if (oldTasks == null) {
            this.setMap.put(sid, tasks);
        } else {
            oldTasks.or(tasks);
        }
    }

    public void deleteSets(String sid) {
        this.setMap.remove(sid);
    }

    public void dispose(IProgressMonitor monitor) {
        this.setMap.clear();
    }

    public IPSession getSession() {
        return this.session;
    }

    public BitList getTasks(String sid) {
        return this.setMap.get(sid);
    }

    public void removeTasks(String sid, BitList tasks) {
        BitList oldTasks = this.getTasks(sid);
        if (oldTasks != null) {
            oldTasks.andNot(tasks);
        }
        if (oldTasks.isEmpty()) {
            this.deleteSets(sid);
        }
    }

    protected IPDISession getPDISession() {
        return this.getSession().getPDISession();
    }
}

