/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.util.List;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServicesDelegate;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnectionManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsProcessBuilder;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsServices
implements IRemoteServicesDelegate {
    private static RemoteToolsServices instance = new RemoteToolsServices();
    private static RemoteToolsConnectionManager connMgr = null;

    public static RemoteToolsServices getInstance() {
        return instance;
    }

    public IRemoteConnectionManager getConnectionManager() {
        return connMgr;
    }

    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        IRemoteExecutionManager mgr;
        if (!(conn instanceof RemoteToolsConnection)) {
            return null;
        }
        RemoteToolsConnection remConn = (RemoteToolsConnection)conn;
        try {
            mgr = remConn.createExecutionManager();
        }
        catch (RemoteConnectionException remoteConnectionException) {
            return null;
        }
        return new RemoteToolsFileManager(remConn, mgr);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        return new RemoteToolsProcessBuilder((RemoteToolsConnection)conn, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        return new RemoteToolsProcessBuilder((RemoteToolsConnection)conn, command);
    }

    public boolean initialize() {
        if (connMgr == null) {
            connMgr = new RemoteToolsConnectionManager();
        }
        return true;
    }
}

