/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;

public class RemoteToolsFileSystemContributor
extends FileSystemContributor {
    public URI browseFileSystem(String initialPath, Shell shell) {
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices("org.eclipse.ptp.remote.RemoteTools");
        IRemoteUIServices uiServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(services);
        IRemoteUIFileManager uiFileMgr = uiServices.getUIFileManager();
        uiFileMgr.showConnections(true);
        IPath path = uiFileMgr.browseDirectory(shell, "Browse File System", initialPath);
        if (path != null) {
            IRemoteConnection conn = uiFileMgr.getConnection();
            IRemoteFileManager fileMgr = services.getFileManager(conn);
            return ((RemoteToolsFileManager)fileMgr).toURI(path);
        }
        return null;
    }

    public URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

