/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.events.IJobChangeEvent;
import org.eclipse.ptp.core.elements.listeners.IJobListener;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.launch.PTPLaunchPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeProcess
implements IProcess,
IJobListener {
    private IPLaunch launch = null;
    private IPJob job = null;
    private Map<String, String> fAttributes;
    private int fExitValue = -1;
    private boolean fTerminated = false;

    public RuntimeProcess(IPLaunch launch, IPJob job, Map<String, String> attributes) {
        this.launch = launch;
        this.job = job;
        job.addElementListener((IJobListener)this);
        this.initializeAttributes(attributes);
        this.fTerminated = job.isTerminated();
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    private void initializeAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, attributes.get(key));
            }
        }
    }

    public String getLabel() {
        return this.job.getName();
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, "Exit value not available", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated() {
        RuntimeProcess runtimeProcess = this;
        synchronized (runtimeProcess) {
            this.fTerminated = true;
        }
        this.fExitValue = 0;
        this.job.removeElementListener((IJobListener)this);
        this.fireTerminateEvent();
    }

    public synchronized boolean canTerminate() {
        return !this.fTerminated;
    }

    public synchronized boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            try {
                IResourceManager rm = this.job.getQueue().getResourceManager();
                rm.terminateJob(this.job);
            }
            catch (CoreException e) {
                throw new DebugException(e.getStatus());
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        return null;
    }

    public void handleEvent(IJobChangeEvent e) {
        JobAttributes.State state;
        EnumeratedAttribute attr = (EnumeratedAttribute)e.getAttributes().getAttribute((IAttributeDefinition)JobAttributes.getStateAttributeDefinition());
        if (attr != null && ((state = (JobAttributes.State)attr.getValue()) == JobAttributes.State.TERMINATED || state == JobAttributes.State.ERROR)) {
            this.terminated();
        }
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }
}

