/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.rulesengine;

import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.data.DownloadBackRule;
import org.eclipse.ptp.launch.data.DownloadRule;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class DownloadRuleAction
implements IRuleAction {
    private final ILaunchProcessCallback process;
    private final DownloadRule rule;
    private final ILaunchConfiguration configuration;
    private DownloadBackRule downloadBackRule;
    private final IProgressMonitor monitor;

    public DownloadRuleAction(ILaunchProcessCallback process, ILaunchConfiguration configuration, DownloadRule rule, IProgressMonitor monitor) {
        this.process = process;
        this.rule = rule;
        this.configuration = configuration;
        this.monitor = monitor;
    }

    public void run() throws CoreException {
        Assert.isNotNull((Object)this.process);
        Assert.isNotNull((Object)this.rule);
        Assert.isNotNull((Object)this.configuration);
        Path localParentPath = new Path(this.rule.getLocalDirectory());
        if (!localParentPath.isAbsolute()) {
            IPath defaultPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            localParentPath = defaultPath.append((IPath)localParentPath);
        }
        localParentPath.removeTrailingSeparator();
        Assert.isTrue((boolean)localParentPath.isAbsolute(), (String)"localPath.isAbsolute()");
        IRemoteFileManager localFileManager = this.process.getLocalFileManager(this.configuration);
        IFileStore localFileParentResource = null;
        try {
            localFileParentResource = localFileManager.getResource((IPath)localParentPath, this.monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", "Error retrieving local resource", (Throwable)e));
        }
        IFileInfo localFileParentInfo = localFileParentResource.fetchInfo();
        if (!localFileParentInfo.exists()) {
            localFileParentResource.mkdir(0, this.monitor);
        }
        IPath[] remotePaths = this.rule.getRemoteFilesAsPathArray();
        IPath remoteWorkingPath = new Path(this.configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", "")).removeLastSegments(1);
        int i = 0;
        while (i < remotePaths.length) {
            IPath remotePath = remotePaths[i];
            if (!remotePath.isAbsolute()) {
                remotePath = remoteWorkingPath.append(remotePath);
            }
            IFileStore remoteFileStore = null;
            try {
                IRemoteFileManager remoteFileManager = this.process.getRemoteFileManager(this.configuration);
                remoteFileStore = remoteFileManager.getResource(remotePath, this.monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", "Error retrieving remote resource", (Throwable)e));
            }
            IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, this.monitor);
            if (remoteFileInfo.exists()) {
                IPath localPath = localParentPath.append(remotePath.lastSegment());
                IFileStore localFileStore = null;
                try {
                    localFileStore = localFileManager.getResource(localPath, this.monitor);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", "Error retrieving local resource", (Throwable)e));
                }
                this.doDownload(remoteFileStore, remotePath, localFileStore, localPath);
            }
            ++i;
        }
    }

    private void doDownload(IFileStore remoteFileStore, IPath remotePath, IFileStore localFileStore, IPath localPath) throws CoreException {
        IFileInfo localFileInfo = localFileStore.fetchInfo();
        IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, this.monitor);
        if (localFileInfo.exists()) {
            switch (this.rule.getOverwritePolicy()) {
                case 2: {
                    break;
                }
                case 3: {
                    long dupFileModTime = localFileInfo.getLastModified();
                    long localFileModTime = remoteFileInfo.getLastModified();
                    if (dupFileModTime < localFileModTime) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        remoteFileStore.copy(localFileStore, 2, this.monitor);
        boolean changedAttr = false;
        if (this.rule.isAsReadOnly()) {
            localFileInfo.setAttribute(2, true);
            changedAttr = true;
        }
        if (this.rule.isAsExecutable()) {
            localFileInfo.setAttribute(4, true);
            changedAttr = true;
        }
        if (changedAttr) {
            localFileStore.putInfo(localFileInfo, 1024, this.monitor);
        }
        if (this.rule.isPreserveTimeStamp()) {
            localFileInfo.setLastModified(remoteFileInfo.getLastModified());
            localFileStore.putInfo(localFileInfo, 2048, this.monitor);
        }
    }
}

