/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.ptp.utils.core.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeSet
implements Iterable<String> {
    private ArrayList<Range> rangeList = new ArrayList(0);
    private Iterator<Range> rangeListIter;
    private Iterator<String> rangeIter;

    public RangeSet() {
    }

    public RangeSet(String str) {
        if (str != null) {
            String[] ranges;
            String[] stringArray = ranges = str.split(",");
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                String[] vals = range.split("-");
                if (vals.length == 1) {
                    this.add(Integer.parseInt(vals[0]));
                } else {
                    this.add(Integer.parseInt(vals[0]), Integer.parseInt(vals[1]));
                }
                ++n2;
            }
        }
    }

    public RangeSet(int val) {
        this(val, val);
    }

    public RangeSet(int min, int max) {
        this.rangeList.add(new Range(min, max));
    }

    public void add(int val) {
        int pos = 0;
        if (this.rangeList.size() > 0) {
            pos = this.findIndex(val);
            if (pos >= 0) {
                return;
            }
            pos = -(pos + 1);
        }
        this.rangeList.add(pos, new Range(val));
        this.fixupRanges();
    }

    public void add(int min, int max) {
        if (min == max) {
            this.add(min);
            return;
        }
        if (min > max) {
            return;
        }
        if (this.rangeList.size() == 0) {
            this.rangeList.add(new Range(min, max));
            return;
        }
        Range rlow = null;
        Range rhigh = null;
        int ilow = this.findIndex(min);
        int ihigh = this.findIndex(max);
        if (ilow >= 0) {
            if (ilow == ihigh) {
                return;
            }
            rlow = this.rangeList.get(ilow);
            if (ihigh >= 0) {
                rhigh = this.rangeList.get(ihigh);
                rlow.setMaxValue(rhigh.getMaxValue());
            } else {
                rlow.setMaxValue(max);
                ihigh = -(ihigh + 2);
            }
            while (ihigh != ilow) {
                this.rangeList.remove(ilow + 1);
                --ihigh;
            }
        } else {
            ilow = -(ilow + 1);
            if (ihigh >= 0) {
                rhigh = this.rangeList.get(ihigh);
                rhigh.setMinValue(min);
                while (ihigh != ilow) {
                    this.rangeList.remove(ilow);
                    --ihigh;
                }
            } else if (ilow == (ihigh = -(ihigh + 1))) {
                this.rangeList.add(ilow, new Range(min, max));
            } else {
                rlow = this.rangeList.get(ilow);
                rlow.setMinValue(min);
                rlow.setMaxValue(max);
                while (ihigh > ilow + 1) {
                    this.rangeList.remove(ilow + 1);
                    --ihigh;
                }
            }
        }
        this.fixupRanges();
    }

    private void fixupRanges() {
        int pos = this.rangeList.size() - 2;
        while (pos >= 0) {
            Range r1 = this.rangeList.get(pos);
            Range r2 = this.rangeList.get(pos + 1);
            if (r1.getMaxValue() >= r2.getMinValue() - 1) {
                r1.setMaxValue(r2.getMaxValue());
                this.rangeList.remove(pos + 1);
            }
            --pos;
        }
    }

    public void remove(int val) {
    }

    public void remove(int min, int max) {
    }

    public boolean inRange(int val) {
        return this.findIndex(val) >= 0;
    }

    public int size() {
        int nels = 0;
        for (Range r : this.rangeList) {
            nels += r.size();
        }
        return nels;
    }

    public int[] toArray() {
        int elt = 0;
        int[] vals = new int[this.size()];
        for (Range r : this.rangeList) {
            int i = r.getMinValue();
            while (i <= r.getMaxValue()) {
                vals[elt++] = i++;
            }
        }
        return vals;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.rangeList.size()) {
            if (i > 0) {
                str = String.valueOf(str) + ",";
            }
            str = String.valueOf(str) + this.rangeList.get(i).toString();
            ++i;
        }
        return str;
    }

    public int findIndex(int val) {
        int low = 0;
        int high = this.rangeList.size() - 1;
        while (low <= high) {
            int pos = low == high ? low : (low + high) / 2;
            Range r = this.rangeList.get(pos);
            if (r.inRange(val)) {
                return pos;
            }
            if (val < r.getMinValue()) {
                high = pos - 1;
                continue;
            }
            if (val <= r.getMaxValue()) continue;
            low = pos + 1;
        }
        return -(low + 1);
    }

    @Override
    public Iterator<String> iterator() {
        this.rangeListIter = this.rangeList.iterator();
        this.rangeIter = this.rangeListIter.hasNext() ? this.rangeListIter.next().iterator() : null;
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return RangeSet.this.rangeIter != null && (RangeSet.this.rangeIter.hasNext() || RangeSet.this.rangeListIter.hasNext());
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    if (!RangeSet.this.rangeIter.hasNext()) {
                        RangeSet.this.rangeIter = ((Range)RangeSet.this.rangeListIter.next()).iterator();
                    }
                    return (String)RangeSet.this.rangeIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

