/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.IMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;

public class UniversalFileSystemFilter
implements FilenameFilter {
    protected String filter;
    protected boolean allowDirs;
    protected boolean allowFiles;
    protected boolean caseSensitive = true;
    protected IMatcher matcher = null;
    protected NamePatternMatcher folderNameMatcher = null;
    protected int includeFilesOrFolders;

    public UniversalFileSystemFilter(String fString, boolean files, boolean folders, boolean caseSensitive) {
        this.filter = fString;
        this.allowFiles = files;
        this.allowDirs = folders;
        this.caseSensitive = caseSensitive;
    }

    public boolean accept(File dir, String name) {
        boolean match = true;
        File file = new File(dir, name);
        if (!this.allowDirs && file.isDirectory()) {
            return false;
        }
        if (this.allowDirs && (file.isDirectory() || ArchiveHandlerManager.getInstance().isArchive(file))) {
            return true;
        }
        if (!this.allowFiles && file.isFile()) {
            return false;
        }
        if (this.allowDirs && this.allowFiles) {
            this.setListValues(8, this.filter);
        } else if (this.allowDirs) {
            this.setListValues(4, this.filter);
        } else if (this.allowFiles) {
            this.setListValues(2, this.filter);
        } else {
            return false;
        }
        if (this.matcher == null && this.folderNameMatcher == null) {
            return true;
        }
        if (this.includeFilesOrFolders != 8) {
            match = this.matcher.matches(name);
        } else if (file.isFile()) {
            if (this.matcher != null) {
                match = this.matcher.matches(name);
            }
        } else if (this.folderNameMatcher != null) {
            match = this.folderNameMatcher.matches(name);
        }
        return match;
    }

    protected void setListValues(int includeFilesOrFolders, String nameFilter) {
        this.includeFilesOrFolders = includeFilesOrFolders;
        this.matcher = nameFilter != null && !nameFilter.equals("*") ? (nameFilter.endsWith(",") ? new FileTypeMatcher(FileTypeMatcher.parseTypes((String)nameFilter), true) : new NamePatternMatcher(nameFilter, true, this.caseSensitive)) : null;
        this.folderNameMatcher = null;
    }

    protected void setListValues(int includeFilesOrFolders, String folderNameFilter, String fileNameFilter) {
        this.setListValues(includeFilesOrFolders, fileNameFilter);
        if (folderNameFilter != null && !folderNameFilter.equals("*")) {
            this.folderNameMatcher = new NamePatternMatcher(folderNameFilter, true, this.caseSensitive);
        }
    }
}

