/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CKnRParameter
extends PlatformObject
implements IParameter {
    private final IASTDeclaration declaration;
    private final IASTName name;

    public CKnRParameter(IASTDeclaration declaration, IASTName name) {
        this.declaration = declaration;
        this.name = name;
    }

    public IType getType() {
        IASTDeclSpecifier declSpec = null;
        if (this.declaration instanceof IASTSimpleDeclaration) {
            declSpec = ((IASTSimpleDeclaration)this.declaration).getDeclSpecifier();
        }
        if (declSpec != null && declSpec instanceof ICASTTypedefNameSpecifier) {
            ICASTTypedefNameSpecifier nameSpec = (ICASTTypedefNameSpecifier)declSpec;
            return (IType)((Object)nameSpec.getName().resolveBinding());
        }
        if (declSpec != null && declSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)declSpec;
            return (IType)((Object)elabTypeSpec.getName().resolveBinding());
        }
        return null;
    }

    public String getName() {
        return this.name.toString();
    }

    public char[] getNameCharArray() {
        return this.name.toCharArray();
    }

    public IScope getScope() {
        return CVisitor.getContainingScope(this.declaration);
    }

    public IASTNode getPhysicalNode() {
        return this.declaration;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isAuto() {
        if (this.declaration instanceof IASTSimpleDeclaration) {
            return ((IASTSimpleDeclaration)this.declaration).getDeclSpecifier().getStorageClass() == 4;
        }
        return false;
    }

    public boolean isRegister() {
        if (this.declaration instanceof IASTSimpleDeclaration) {
            return ((IASTSimpleDeclaration)this.declaration).getDeclSpecifier().getStorageClass() == 5;
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }
}

