/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;

final class ScannerContext {
    private static final Token END_TOKEN = new Token(144, null, 0, 0);
    public static final Integer BRANCH_IF = new Integer(0);
    public static final Integer BRANCH_ELIF = new Integer(1);
    public static final Integer BRANCH_ELSE = new Integer(2);
    public static final Integer BRANCH_END = new Integer(3);
    private final ILocationCtx fLocationCtx;
    private final ScannerContext fParent;
    private final Lexer fLexer;
    private ArrayList<Integer> fBranches = null;
    private Token fTokens;

    public ScannerContext(ILocationCtx ctx, ScannerContext parent, Lexer lexer) {
        this.fLocationCtx = ctx;
        this.fParent = parent;
        this.fLexer = lexer;
    }

    public ScannerContext(ILocationCtx ctx, ScannerContext parent, TokenList tokens) {
        this.fLocationCtx = ctx;
        this.fParent = parent;
        this.fLexer = null;
        this.fTokens = tokens.first();
    }

    public final ILocationCtx getLocationCtx() {
        return this.fLocationCtx;
    }

    public final ScannerContext getParent() {
        return this.fParent;
    }

    public final Lexer getLexer() {
        return this.fLexer;
    }

    public final boolean changeBranch(Integer branchKind) {
        if (this.fBranches == null) {
            this.fBranches = new ArrayList();
        }
        if (branchKind == BRANCH_IF) {
            this.fBranches.add(branchKind);
            return true;
        }
        int pos = this.fBranches.size() - 1;
        if (pos < 0) {
            return false;
        }
        if (branchKind == BRANCH_END) {
            this.fBranches.remove(pos);
            return true;
        }
        if (this.fBranches.get(pos) == BRANCH_ELSE) {
            return false;
        }
        this.fBranches.set(pos, branchKind);
        return true;
    }

    public final Token currentLexerToken() {
        if (this.fLexer != null) {
            return this.fLexer.currentToken();
        }
        if (this.fTokens != null) {
            return this.fTokens;
        }
        return END_TOKEN;
    }

    public Token nextPPToken() throws OffsetLimitReachedException {
        if (this.fLexer != null) {
            return this.fLexer.nextToken();
        }
        if (this.fTokens != null) {
            this.fTokens = (Token)this.fTokens.getNext();
        }
        return this.currentLexerToken();
    }
}

