/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.CodeReaderCache;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.core.runtime.Preferences;

public class SavedCodeReaderFactory
implements ICodeReaderFactory {
    private ICodeReaderCache cache = null;
    private static SavedCodeReaderFactory instance = new SavedCodeReaderFactory();

    public static SavedCodeReaderFactory getInstance() {
        return instance;
    }

    private SavedCodeReaderFactory() {
        Preferences pluginPreferences;
        int size = 64;
        CCorePlugin corePlugin = CCorePlugin.getDefault();
        if (corePlugin != null && (pluginPreferences = corePlugin.getPluginPreferences()) != null) {
            size = pluginPreferences.getInt("org.eclipse.cdt.core.codeReaderCache");
            if (size == 0) {
                String[] properties = pluginPreferences.propertyNames();
                boolean found = false;
                int j = 0;
                while (j < properties.length) {
                    if (properties[j].equals("org.eclipse.cdt.core.codeReaderCache")) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    size = 64;
                }
            } else if (size < 0) {
                size = 64;
            }
        }
        this.cache = new CodeReaderCache(size);
    }

    public int getUniqueIdentifier() {
        return 0;
    }

    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return this.cache.get(path);
    }

    public CodeReader createCodeReaderForTranslationUnit(ITranslationUnit tu) {
        return new CodeReader(tu.getResource().getLocation().toOSString(), tu.getContents());
    }

    public CodeReader createCodeReaderForInclusion(String path) {
        return this.cache.get(path);
    }

    public ICodeReaderCache getCodeReaderCache() {
        return this.cache;
    }
}

