/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPClassSpecializationScope
implements ICPPClassSpecializationScope,
IASTInternalScope {
    private ObjectMap instanceMap = ObjectMap.EMPTY_MAP;
    private final ICPPSpecialization specialization;

    public CPPClassSpecializationScope(ICPPSpecialization specialization) {
        this.specialization = specialization;
    }

    public ICPPClassType getOriginalClassType() {
        return (ICPPClassType)this.specialization.getSpecializedBinding();
    }

    public IBinding getInstance(IBinding binding) {
        if (this.instanceMap.containsKey(binding)) {
            return (IBinding)this.instanceMap.get(binding);
        }
        if (!(binding instanceof ICPPClassTemplatePartialSpecialization)) {
            ICPPSpecialization spec = CPPTemplates.createSpecialization(this, binding, this.specialization.getArgumentMap());
            if (this.instanceMap == ObjectMap.EMPTY_MAP) {
                this.instanceMap = new ObjectMap(2);
            }
            this.instanceMap.put(binding, spec);
            return spec;
        }
        return null;
    }

    public final IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    public IBinding getBinding(IASTName name, boolean forceResolve, IIndexFileSet fileSet) throws DOMException {
        IBinding[] bindings;
        char[] c = name.toCharArray();
        if (CharArrayUtils.equals(c, this.specialization.getNameCharArray()) && !CPPClassScope.isConstructorReference(name)) {
            return this.specialization;
        }
        ICPPClassType specialized = (ICPPClassType)this.specialization.getSpecializedBinding();
        IScope classScope = specialized.getCompositeScope();
        IBinding[] iBindingArray = bindings = classScope != null ? classScope.getBindings(name, forceResolve, false) : null;
        if (bindings == null) {
            return null;
        }
        Object[] specs = new IBinding[]{};
        IBinding[] iBindingArray2 = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray2[n2];
            specs = (IBinding[])ArrayUtil.append(IBinding.class, specs, this.getInstance(binding));
            ++n2;
        }
        specs = (IBinding[])ArrayUtil.trim(IBinding.class, specs);
        return CPPSemantics.resolveAmbiguities(name, specs);
    }

    public IBinding[] getBindings(IASTName name, boolean forceResolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        ICPPClassType specialized;
        IScope classScope;
        IBinding[] bindings;
        char[] c = name.toCharArray();
        Object[] result = null;
        if (!prefixLookup && CharArrayUtils.equals(c, this.specialization.getNameCharArray()) || prefixLookup && CharArrayUtils.equals(this.specialization.getNameCharArray(), 0, c.length, c, true)) {
            result = new IBinding[]{this.specialization};
        }
        IBinding[] iBindingArray = bindings = (classScope = (specialized = (ICPPClassType)this.specialization.getSpecializedBinding()).getCompositeScope()) != null ? classScope.getBindings(name, forceResolve, prefixLookup, fileSet) : null;
        if (bindings != null) {
            IBinding[] iBindingArray2 = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray2[n2];
                result = (IBinding[])ArrayUtil.append(IBinding.class, result, this.getInstance(binding));
                ++n2;
            }
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    public ICPPClassType getClassType() {
        return (ICPPClassType)((Object)this.specialization);
    }

    public ICPPMethod[] getImplicitMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public IName getScopeName() {
        if (this.specialization instanceof ICPPInternalBinding) {
            return (IASTName)((ICPPInternalBinding)((Object)this.specialization)).getDefinition();
        }
        return null;
    }

    protected ICPPConstructor[] getConstructors() throws DOMException {
        ICPPClassType specialized = (ICPPClassType)this.specialization.getSpecializedBinding();
        ICPPConstructor[] bindings = specialized.getConstructors();
        if (bindings == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        Object[] specs = new ICPPConstructor[]{};
        ICPPConstructor[] iCPPConstructorArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor binding = iCPPConstructorArray[n2];
            specs = (ICPPConstructor[])ArrayUtil.append(ICPPConstructor.class, specs, this.getInstance(binding));
            ++n2;
        }
        return (ICPPConstructor[])ArrayUtil.trim(ICPPConstructor.class, specs);
    }

    protected ICPPMethod[] getDeclaredMethods() throws DOMException {
        ICPPClassType specialized = (ICPPClassType)this.specialization.getSpecializedBinding();
        ICPPMethod[] bindings = specialized.getDeclaredMethods();
        if (bindings == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        Object[] specs = new ICPPMethod[]{};
        ICPPMethod[] iCPPMethodArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod binding = iCPPMethodArray[n2];
            specs = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, specs, this.getInstance(binding));
            ++n2;
        }
        return (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, specs);
    }

    public IScope getParent() throws DOMException {
        IASTNode[] nds;
        ICPPClassType cls = this.getOriginalClassType();
        ICPPClassScope scope = (ICPPClassScope)cls.getCompositeScope();
        if (scope != null) {
            return scope.getParent();
        }
        if (cls instanceof ICPPInternalBinding && (nds = ((ICPPInternalBinding)((Object)cls)).getDeclarations()) != null && nds.length > 0) {
            return CPPVisitor.getContainingScope(nds[0]);
        }
        return null;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public boolean isFullyCached() throws DOMException {
        ICPPScope origScope = (ICPPScope)this.getOriginalClassType().getCompositeScope();
        if (!ASTInternal.isFullyCached(origScope)) {
            try {
                CPPSemantics.lookupInScope(null, origScope, null);
            }
            catch (DOMException dOMException) {}
        }
        return true;
    }

    public void setFullyCached(boolean b) {
    }

    public void flushCache() {
    }

    public void addName(IASTName name) {
    }

    public IASTNode getPhysicalNode() {
        return null;
    }

    public void removeBinding(IBinding binding) {
    }

    public void addBinding(IBinding binding) {
    }

    public String toString() {
        IName name = this.getScopeName();
        return name != null ? name.toString() : String.valueOf(this.specialization);
    }
}

