/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public final class MacroContainerPatternCollector
implements IBTreeVisitor {
    private final PDOM fPDOM;
    private final List<PDOMMacroContainer> macros = new ArrayList<PDOMMacroContainer>();
    private final Pattern fPattern;
    private final IProgressMonitor fMonitor;
    private int fMonitorCheckCounter = 0;

    public MacroContainerPatternCollector(PDOM pdom, Pattern pattern, IProgressMonitor monitor) {
        this.fPDOM = pdom;
        this.fPattern = pattern;
        this.fMonitor = monitor;
    }

    public final int compare(int record) throws CoreException {
        if (this.fMonitor != null) {
            this.checkCancelled();
        }
        return 0;
    }

    public final boolean visit(int record) throws CoreException {
        if (record == 0) {
            return true;
        }
        String name = PDOMNamedNode.getDBName(this.fPDOM, record).getString();
        if (this.fPattern.matcher(name).matches()) {
            this.macros.add(new PDOMMacroContainer(this.fPDOM, record));
        }
        return true;
    }

    public final PDOMMacroContainer[] getMacroContainers() {
        return this.macros.toArray(new PDOMMacroContainer[this.macros.size()]);
    }

    private void checkCancelled() {
        if (++this.fMonitorCheckCounter % 4096 == 0 && this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

