/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCMarkerGenerator;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.internal.rdt.core.index.IndexBuildSequenceController;
import org.eclipse.ptp.internal.rdt.core.remotemake.RemoteProcessClosure;
import org.eclipse.ptp.internal.rdt.core.remotemake.ResourceRefreshJob;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.activator.Activator;
import org.eclipse.ptp.rdt.core.remotemake.ScannerInfoUtility;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class RemoteMakeBuilder
extends MakeBuilder {
    public static final String REMOTE_MAKE_BUILDER_ID = "org.eclipse.ptp.rdt.core.remoteMakeBuilder";

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo((IProject)this.getProject(), (String)REMOTE_MAKE_BUILDER_ID);
        if (this.shouldBuild(15, info)) {
            IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
            Job backgroundJob = new Job("Standard Make Builder", (ISchedulingRule)rule, info){
                private final /* synthetic */ ISchedulingRule val$rule;
                private final /* synthetic */ IMakeBuilderInfo val$info;
                {
                    this.val$rule = iSchedulingRule;
                    this.val$info = iMakeBuilderInfo;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) {
                                RemoteMakeBuilder.this.invokeMake(15, val$info, monitor);
                            }
                        }, this.val$rule, 1, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    IStatus returnStatus = Status.OK_STATUS;
                    return returnStatus;
                }
            };
            backgroundJob.setRule((ISchedulingRule)rule);
            backgroundJob.schedule();
        }
    }

    /*
     * Loose catch block
     */
    protected boolean invokeMake(int kind, IMakeBuilderInfo info, IProgressMonitor progressMonitor) {
        IProgressMonitor monitor;
        boolean isClean;
        IndexBuildSequenceController projectStatus;
        block41: {
            IRemoteConnection connection;
            IRemoteServices remoteServices;
            OutputStream consoleErr;
            OutputStream consoleOut;
            OutputStream stderr;
            OutputStream stdout;
            ErrorParserManager epm;
            StreamMonitor streamMon;
            QualifiedName qName;
            String[] buildArguments;
            HashMap<String, String> envMap;
            Object errMsg;
            IPath workingDirectory;
            ConsoleOutputStream cos;
            String buildCommand;
            IProject currProject;
            block43: {
                IEnvironmentVariable[] envVars;
                IConfiguration configuration;
                IManagedBuildInfo mbsInfo;
                block42: {
                    projectStatus = IndexBuildSequenceController.getIndexBuildSequenceController(this.getProject());
                    if (projectStatus != null) {
                        projectStatus.setRuntimeBuildStatus(null);
                    }
                    isClean = false;
                    currProject = this.getProject();
                    if (progressMonitor == null) {
                        progressMonitor = new NullProgressMonitor();
                    }
                    monitor = progressMonitor;
                    monitor.beginTask(String.valueOf(MakeMessages.getString((String)"MakeBuilder.Invoking_Make_Builder")) + currProject.getName(), 100);
                    mbsInfo = ManagedBuildManager.getBuildInfo((IResource)currProject);
                    buildCommand = mbsInfo.getBuildCommand();
                    if (buildCommand == null) break block41;
                    IConsole console = CCorePlugin.getDefault().getConsole();
                    console.start(currProject);
                    cos = console.getOutputStream();
                    this.removeAllMarkers(currProject);
                    configuration = mbsInfo.getDefaultConfiguration();
                    IBuilder builder = configuration.getBuilder();
                    workingDirectory = ManagedBuildManager.getBuildLocation((IConfiguration)configuration, (IBuilder)builder);
                    if (workingDirectory != null) break block42;
                    monitor.done();
                    return false;
                }
                String[] targets = this.getTargets(kind, info);
                if (targets.length != 0 && targets[targets.length - 1].equals(info.getCleanBuildTarget())) {
                    isClean = true;
                }
                errMsg = null;
                envMap = new HashMap<String, String>();
                IEnvironmentVariable[] iEnvironmentVariableArray = envVars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(configuration, true);
                int n = envVars.length;
                int n2 = 0;
                while (n2 < n) {
                    IEnvironmentVariable environmentVariable = iEnvironmentVariableArray[n2];
                    envMap.put(environmentVariable.getName(), environmentVariable.getValue());
                    ++n2;
                }
                Iterator iter = envMap.entrySet().iterator();
                ArrayList<String> strings = new ArrayList<String>(envMap.size());
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    StringBuffer buffer = new StringBuffer((String)entry.getKey());
                    buffer.append('=').append((String)entry.getValue());
                    strings.add(buffer.toString());
                }
                buildArguments = targets;
                String args = mbsInfo.getBuildArguments();
                if (args != null && !args.equals("")) {
                    String[] newArgs = this.makeArray(args);
                    buildArguments = new String[targets.length + newArgs.length];
                    System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                    System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                }
                qName = new QualifiedName("org.eclipse.ptp.rdt.core", "progressMonitor");
                Integer last = (Integer)this.getProject().getSessionProperty(qName);
                if (last == null) {
                    last = new Integer(100);
                }
                streamMon = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 100), (OutputStream)cos, last.intValue());
                epm = new ErrorParserManager(this.getProject(), workingDirectory, (IMarkerGenerator)this, configuration.getErrorParserList());
                epm.setOutputStream((OutputStream)streamMon);
                stdout = epm.getOutputStream();
                stderr = epm.getOutputStream();
                consoleOut = null;
                OutputStream currentStdOut = stdout;
                OutputStream currentStdErr = stderr;
                consoleErr = null;
                IToolChain tc = configuration.getToolChain();
                ITool[] tools = tc.getTools();
                HashSet<String> all_scannerIDs = new HashSet<String>();
                ITool[] iToolArray = tools;
                int n3 = tools.length;
                int n4 = 0;
                while (n4 < n3) {
                    IInputType[] inputTypes;
                    ITool tool = iToolArray[n4];
                    IInputType[] iInputTypeArray = inputTypes = tool.getInputTypes();
                    int n5 = inputTypes.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IInputType inputType = iInputTypeArray[n6];
                        InputType realInputType = (InputType)inputType;
                        String scannerIDString = realInputType.getDiscoveryProfileIdAttribute();
                        if (scannerIDString != null) {
                            String[] scannerIDs;
                            String[] stringArray = scannerIDs = scannerIDString.split("\\|");
                            int n7 = scannerIDs.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String thisScannerid = stringArray[n8];
                                if (thisScannerid != null) {
                                    all_scannerIDs.add(thisScannerid);
                                }
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
                for (String id : all_scannerIDs) {
                    SCMarkerGenerator markerGenerator;
                    ConsoleOutputSniffer sniffer;
                    IScannerInfoCollector collector = (IScannerInfoCollector)ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(id).getScannerInfoCollectorElement().createScannerInfoCollector();
                    if (collector instanceof IScannerInfoCollector2) {
                        IScannerInfoCollector2 s2 = (IScannerInfoCollector2)collector;
                        s2.setProject(currProject);
                    }
                    currentStdOut = (sniffer = ScannerInfoUtility.createBuildOutputSniffer(currentStdOut, currentStdErr, currProject, configuration, workingDirectory, (IMarkerGenerator)(markerGenerator = new SCMarkerGenerator()), collector)) == null ? currentStdOut : sniffer.getOutputStream();
                    OutputStream outputStream = currentStdErr = sniffer == null ? currentStdErr : sniffer.getErrorStream();
                }
                consoleOut = currentStdOut == null ? stdout : currentStdOut;
                consoleErr = currentStdErr == null ? stderr : currentStdErr;
                ServiceModelManager smm = ServiceModelManager.getInstance();
                IServiceConfiguration serviceConfig = smm.getActiveConfiguration(this.getProject());
                IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
                IServiceProvider provider = serviceConfig.getServiceProvider(buildService);
                IRemoteExecutionServiceProvider executionProvider = null;
                if (provider instanceof IRemoteExecutionServiceProvider) {
                    executionProvider = (IRemoteExecutionServiceProvider)provider;
                }
                if (!(remoteServices = executionProvider.getRemoteServices()).isInitialized()) {
                    remoteServices.initialize();
                }
                if ((connection = executionProvider.getConnection()) != null) break block43;
                monitor.done();
                return false;
            }
            try {
                try {
                    if (!connection.isOpen()) {
                        connection.open(monitor);
                    }
                    LinkedList<String> command = new LinkedList<String>();
                    command.add(buildCommand);
                    int k = 0;
                    while (k < buildArguments.length) {
                        command.add(buildArguments[k]);
                        ++k;
                    }
                    IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, command);
                    Map remoteEnvMap = processBuilder.environment();
                    remoteEnvMap.clear();
                    remoteEnvMap.putAll(envMap);
                    IRemoteFileManager fileManager = remoteServices.getFileManager(connection);
                    if (fileManager != null) {
                        processBuilder.directory(fileManager.getResource(workingDirectory.toString()));
                    }
                    monitor.subTask(String.valueOf(MakeMessages.getString((String)"MakeBuilder.Invoking_Command")) + command);
                    processBuilder.redirectErrorStream(true);
                    final IRemoteProcess p = processBuilder.start();
                    if (projectStatus != null) {
                        if (kind == 15) {
                            projectStatus.setBuildInCompletedForCleanBuild();
                        } else {
                            projectStatus.setBuildRunning();
                        }
                    }
                    Thread monitorThread = new Thread(new Runnable(){

                        public void run() {
                            while (!monitor.isCanceled() && !p.isCompleted()) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    RDTLog.logError(e);
                                }
                                if (!monitor.isCanceled() || p.isCompleted()) continue;
                                p.destroy();
                                if (projectStatus == null) continue;
                                projectStatus.setRuntimeBuildStatus(IndexBuildSequenceController.STATUS_INCOMPLETE);
                            }
                        }
                    }, MakeMessages.getString((String)"Remote Make Monitor Thread"));
                    monitorThread.start();
                    if (p != null) {
                        try {
                            p.getOutputStream().close();
                            RemoteProcessClosure remoteProcessClosure = new RemoteProcessClosure(p, consoleOut, consoleErr);
                            remoteProcessClosure.runNonBlocking();
                        }
                        catch (IOException iOException) {}
                        while (!p.isCompleted()) {
                            try {
                                p.waitFor();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        LinkedList<IResource> resourcesToRefresh = new LinkedList<IResource>();
                        resourcesToRefresh.add((IResource)currProject);
                        ResourceRefreshJob refreshJob = new ResourceRefreshJob(resourcesToRefresh);
                        refreshJob.schedule();
                    }
                    {
                        catch (ProjectNotConfiguredException projectNotConfiguredException) {}
                    }
                    this.getProject().setSessionProperty(qName, !monitor.isCanceled() && !isClean ? new Integer(streamMon.getWorkDone()) : null);
                    if (errMsg != null) {
                        // empty if block
                    }
                    stdout.close();
                    stderr.close();
                    monitor.subTask(MakeMessages.getString((String)"MakeBuilder.Creating_Markers"));
                    consoleOut.close();
                    consoleErr.close();
                    epm.reportProblems();
                    cos.close();
                }
                catch (Exception e) {
                    CCorePlugin.log((Throwable)e);
                    monitor.done();
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
        }
        monitor.done();
        if (kind != 15 && projectStatus != null) {
            if (projectStatus.isIndexAfterBuildSet()) {
                projectStatus.invokeIndex();
            } else {
                projectStatus.setFinalBuildStatus();
            }
        }
        return isClean;
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }

    private String[] makeArray(String string) {
        string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    boolean bl = inComment = !inComment;
                }
            }
            if (c == ' ' && !inComment) {
                aList.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    protected String[] getTargets(int kind, IMakeBuilderInfo info) {
        IManagedBuildInfo mbsInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        IConfiguration config = mbsInfo.getDefaultConfiguration();
        IBuilder builder = config.getBuilder();
        String targets = "";
        switch (kind) {
            case 9: {
                targets = builder.getAutoBuildTarget();
                break;
            }
            case 6: 
            case 10: {
                targets = builder.getIncrementalBuildTarget();
                break;
            }
            case 15: {
                targets = builder.getCleanBuildTarget();
            }
        }
        return this.makeArray(targets);
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        IProject project = this.getProject();
        IProjectDescription description = null;
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        ICommand[] commands = description.getBuildSpec();
        ICommand builderCommand = null;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals(REMOTE_MAKE_BUILDER_ID)) {
                builderCommand = command;
                break;
            }
            ++n2;
        }
        return builderCommand.isBuilding(kind);
    }
}

