/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.ui.swt;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.utils.ui.Activator;
import org.eclipse.ptp.utils.ui.messages.Messages;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrameMold;
import org.eclipse.ptp.utils.ui.swt.ComboGroup;
import org.eclipse.ptp.utils.ui.swt.ComboGroupItem;
import org.eclipse.ptp.utils.ui.swt.ComboMold;
import org.eclipse.ptp.utils.ui.swt.FileGroup;
import org.eclipse.ptp.utils.ui.swt.FileMold;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public final class AuthenticationFrame
extends Frame {
    private Button localhost;
    private Button remotehost;
    private TextGroup hostAddressTextGroup;
    private TextGroup hostPortTextGroup;
    private Button passwordAuthButton;
    private Button publicKeyAuthButton;
    private TextGroup usernameTextGroup;
    private TextGroup passwordTextGroup;
    private FileGroup privateKeyPathGroup;
    private TextGroup passphraseTextGroup;
    private TextGroup timeoutTextGroup;
    private ComboGroup cipherTypeGroup;
    private final Set<ModifyListener> modifyListeners = new HashSet<ModifyListener>();

    public AuthenticationFrame(Composite parent, AuthenticationFrameMold mold) {
        super(parent, FrameMold.HAS_EXPAND | FrameMold.HAS_FRAME | ((mold.bitmask & 1) != 0 ? FrameMold.HAS_DESCRIPTION : 0), 2);
        this.setTitle(mold.title);
        super.setExpandButtonLabel(mold.labelShowAdvancedOptions);
        super.setShrinkButtonLabel(mold.labelHideAdvancedOptions);
        if (mold.description != null) {
            this.setDescription(mold.description);
        }
        this.createTopControls(mold);
        this.createBottomControls(mold);
        this.registerListeners();
        this.updateEnabledWidgets();
    }

    private void registerListeners() {
        Control[] controls = new Control[]{this.localhost, this.remotehost, this.hostAddressTextGroup, this.hostPortTextGroup, this.passwordAuthButton, this.publicKeyAuthButton, this.usernameTextGroup, this.passwordTextGroup, this.privateKeyPathGroup, this.passphraseTextGroup, this.timeoutTextGroup, this.cipherTypeGroup};
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof TextGroup) {
                ((TextGroup)controls[i]).getText().addModifyListener((ModifyListener)new TextModifyListener());
            } else if (controls[i] instanceof Button) {
                Button b = (Button)controls[i];
                b.addSelectionListener((SelectionListener)new OptionSelectionListener());
            } else if (controls[i] instanceof ComboGroup) {
                ((ComboGroup)controls[i]).getCombo().addSelectionListener((SelectionListener)new ComboSelectionListener());
            }
            ++i;
        }
    }

    private void createTopControls(AuthenticationFrameMold mold) {
        Composite topUserReservedComposite = this.getTopUserReservedComposite();
        FrameMold lmold = new FrameMold(2);
        Frame line = new Frame(topUserReservedComposite, lmold);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        line.setLayoutData(gridData);
        if ((mold.getBitmask() & 2) != 0) {
            this.localhost = new Button((Composite)line, 16);
            this.localhost.setText(mold.labelLocalhost);
            this.remotehost = new Button((Composite)line, 16);
            this.remotehost.setText(mold.labelRemoteHost);
            line = new Frame(topUserReservedComposite, lmold);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            line.setLayoutData(gridData);
        }
        TextMold tmold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, Messages.AuthenticationFrame_Host);
        tmold.setLabel(mold.labelHostAddress);
        this.hostAddressTextGroup = new TextGroup((Composite)line, tmold);
        tmold.addBitmask(TextMold.GRID_DATA_GRAB_EXCESS_SPACE);
        tmold.removeBitmask(TextMold.WIDTH_PROPORTIONAL_NUM_CHARS);
        tmold.unsetTextFieldWidth();
        tmold.setLabel(mold.labelUserName);
        this.usernameTextGroup = new TextGroup(topUserReservedComposite, tmold);
        this.passwordAuthButton = new Button(topUserReservedComposite, 16);
        this.passwordAuthButton.setText(mold.labelIsPasswordBased);
        GridData gdauthkind0 = new GridData();
        gdauthkind0.horizontalSpan = 2;
        this.passwordAuthButton.setLayoutData((Object)gdauthkind0);
        tmold.setLabel(mold.labelPassword);
        tmold.addBitmask(TextMold.PASSWD_FIELD);
        this.passwordTextGroup = new TextGroup(topUserReservedComposite, tmold);
        this.publicKeyAuthButton = new Button(topUserReservedComposite, 16);
        this.publicKeyAuthButton.setText(mold.labelIsPublicKeyBased);
        GridData gdauthkind1 = new GridData();
        gdauthkind1.horizontalSpan = 2;
        this.publicKeyAuthButton.setLayoutData((Object)gdauthkind1);
        FileMold fsmold = new FileMold(FileMold.GRID_DATA_ALIGNMENT_FILL | FileMold.GRID_DATA_SPAN, mold.labelPrivateKeyPath, mold.labelPrivateKeyPathTitle, mold.labelPublicKeyPathButton);
        this.privateKeyPathGroup = new FileGroup(topUserReservedComposite, fsmold);
        tmold.setLabel(mold.labelPassphrase);
        tmold.addBitmask(TextMold.GRID_DATA_SPAN);
        this.passphraseTextGroup = new TextGroup(topUserReservedComposite, tmold);
        this.passwordAuthButton.setSelection(true);
        this.publicKeyAuthButton.setSelection(false);
        if ((mold.getBitmask() & 2) != 0) {
            topUserReservedComposite.setTabList(new Control[]{this.localhost.getParent(), this.hostAddressTextGroup.getParent(), this.usernameTextGroup, this.passwordAuthButton, this.passwordTextGroup, this.publicKeyAuthButton, this.privateKeyPathGroup, this.passphraseTextGroup});
        } else {
            topUserReservedComposite.setTabList(new Control[]{this.hostAddressTextGroup.getParent(), this.usernameTextGroup, this.passwordAuthButton, this.passwordTextGroup, this.publicKeyAuthButton, this.privateKeyPathGroup, this.passphraseTextGroup});
        }
    }

    private void createBottomControls(AuthenticationFrameMold mold) {
        Composite bottomUserReservedComposite = this.getBottomUserReservedComposite();
        TextMold tmold = new TextMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE, mold.labelHostPort);
        tmold.removeBitmask(TextMold.GRID_DATA_GRAB_EXCESS_SPACE);
        tmold.addBitmask(TextMold.WIDTH_PROPORTIONAL_NUM_CHARS);
        tmold.setTextFieldWidth(5);
        this.hostPortTextGroup = new TextGroup(bottomUserReservedComposite, tmold);
        tmold = new TextMold(TextMold.WIDTH_PROPORTIONAL_NUM_CHARS, mold.labelTimeout, 5);
        this.timeoutTextGroup = new TextGroup(bottomUserReservedComposite, tmold);
        ComboMold cmold = new ComboMold(ComboMold.GRID_DATA_SPAN | ComboMold.GRID_DATA_ALIGNMENT_FILL | ComboMold.GRID_DATA_GRAB_EXCESS_SPACE, mold.labelCipherType);
        this.cipherTypeGroup = new ComboGroup(bottomUserReservedComposite, cmold);
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    private void forwardEventToExternalListeners(ModifyEvent mevent) {
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(mevent);
        }
    }

    private void updateEnabledWidgets() {
        if (this.isLocalhostSelected()) {
            this.hostAddressTextGroup.getText().setEnabled(false);
        } else {
            this.hostAddressTextGroup.getText().setEnabled(true);
        }
        if (this.isPasswdBased()) {
            this.passwordTextGroup.setEnabled(true);
            this.privateKeyPathGroup.setEnabled(false);
            this.passphraseTextGroup.setEnabled(false);
        } else {
            this.passwordTextGroup.setEnabled(false);
            this.privateKeyPathGroup.setEnabled(true);
            this.passphraseTextGroup.setEnabled(true);
        }
    }

    public void validateFields() throws CoreException {
        String pluginID = Activator.getDefault().getBundle().getSymbolicName();
        if (!this.isLocalhostSelected() && this.hostAddressTextGroup.getText().getText().trim().length() == 0) {
            throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_EmptyHostAddressException, null));
        }
        if (this.hostPortTextGroup.getText().getText().trim().length() == 0) {
            throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_EmptyHostPortException, null));
        }
        if (this.usernameTextGroup.getText().getText().trim().length() == 0) {
            throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_EmptyUsernameException, null));
        }
        if (!this.isPasswdBased()) {
            if (this.privateKeyPathGroup.getText().getText().trim().length() == 0) {
                throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_EmptyPrivateKeyPathException, null));
            }
            File path = new File(this.privateKeyPathGroup.getText().getText());
            if (!path.exists()) {
                throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_FileDoesNotExistException, null));
            }
            if (!path.isFile()) {
                throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_PathIsNotFileExcpetion, null));
            }
            if (!path.canRead()) {
                throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_FileNotReadableException, null));
            }
        }
        try {
            Integer.parseInt(this.timeoutTextGroup.getText().getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_TimeoutException, null));
        }
        try {
            Integer.parseInt(this.hostPortTextGroup.getText().getText());
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_PortNumberException, null));
        }
        if (this.cipherTypeGroup.getSelectedItem() == null || this.cipherTypeGroup.getSelectedItem().getId().equals("")) {
            throw new CoreException((IStatus)new Status(4, pluginID, 0, Messages.AuthenticationFrame_InvalidCipherTypeException, null));
        }
    }

    public TextGroup getHostAddrTextGroup() {
        return this.hostAddressTextGroup;
    }

    public TextGroup getHostPortTextGroup() {
        return this.hostPortTextGroup;
    }

    public TextGroup getPassphraseTextGroup() {
        return this.passphraseTextGroup;
    }

    public TextGroup getPasswordTextGroup() {
        return this.passwordTextGroup;
    }

    public TextGroup getTimeoutTextGroup() {
        return this.timeoutTextGroup;
    }

    public TextGroup getUsernameTextGroup() {
        return this.usernameTextGroup;
    }

    public FileGroup getPublicKeyPathGroup() {
        return this.privateKeyPathGroup;
    }

    public boolean isPasswdBased() {
        return this.passwordAuthButton.getSelection();
    }

    public boolean isLocalhostSelected() {
        if (this.localhost != null) {
            return this.localhost.getSelection();
        }
        return false;
    }

    public Button[] getAuthKindSelectionButtons() {
        Button[] buttons = new Button[]{this.passwordAuthButton, this.publicKeyAuthButton};
        return buttons;
    }

    public String getHostAddress() {
        return this.hostAddressTextGroup.getString();
    }

    public void setHostAddress(String s) {
        this.hostAddressTextGroup.setString(s);
    }

    public int getHostPort() {
        try {
            return Integer.parseInt(this.hostPortTextGroup.getString());
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    public void setHostPort(int port) {
        this.hostPortTextGroup.setString(Integer.toString(port));
    }

    public boolean isPasswordBased() {
        return this.passwordAuthButton.getSelection();
    }

    public void setPasswordBased(boolean flag) {
        this.passwordAuthButton.setSelection(flag);
        this.publicKeyAuthButton.setSelection(!flag);
        this.updateEnabledWidgets();
    }

    public void setLocalhostSelected(boolean selection) {
        if (this.localhost != null && this.remotehost != null) {
            this.localhost.setSelection(selection);
            this.remotehost.setSelection(!selection);
            this.updateEnabledWidgets();
        }
    }

    public boolean isPublicKeyBased() {
        return this.publicKeyAuthButton.getSelection();
    }

    public void setPublicKeyBased(boolean flag) {
        this.passwordAuthButton.setSelection(!flag);
        this.publicKeyAuthButton.setSelection(flag);
        this.updateEnabledWidgets();
    }

    public String getPassword() {
        return this.passwordTextGroup.getString();
    }

    public void setPassword(String s) {
        this.passwordTextGroup.setString(s);
    }

    public String getUserName() {
        return this.usernameTextGroup.getString();
    }

    public void setUserName(String s) {
        this.usernameTextGroup.setString(s);
    }

    public String getPassphrase() {
        return this.passphraseTextGroup.getString();
    }

    public void setPassphrase(String s) {
        this.passphraseTextGroup.setString(s);
    }

    public int getTimeout() {
        try {
            return Integer.parseInt(this.timeoutTextGroup.getString());
        }
        catch (NumberFormatException numberFormatException) {
            return 5000;
        }
    }

    public void setTimeout(int port) {
        this.timeoutTextGroup.setString(Integer.toString(port));
    }

    public String getPublicKeyPath() {
        return this.privateKeyPathGroup.getString();
    }

    public void setPublicKeyPath(String s) {
        this.privateKeyPathGroup.setString(s);
    }

    public ComboGroupItem getSelectedCipherType() {
        return this.cipherTypeGroup.getSelectedItem();
    }

    public ComboGroupItem getCipherType(String id) {
        return this.cipherTypeGroup.getItemUsingID(id);
    }

    public ComboGroupItem getCipherType(int index) {
        return this.cipherTypeGroup.getItemUsingIndex(index);
    }

    public void addCipherType(ComboGroupItem citem) {
        this.cipherTypeGroup.add(citem);
    }

    public ComboGroup getCipherTypeGroup() {
        return this.cipherTypeGroup;
    }

    private class ComboSelectionListener
    extends SelectionAdapter {
        private ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            Event newEvent = new Event();
            newEvent.data = event.data;
            newEvent.display = event.display;
            newEvent.time = event.time;
            newEvent.widget = event.widget;
            ModifyEvent mevent = new ModifyEvent(newEvent);
            AuthenticationFrame.this.forwardEventToExternalListeners(mevent);
        }
    }

    private class OptionSelectionListener
    extends SelectionAdapter {
        private OptionSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            AuthenticationFrame.this.updateEnabledWidgets();
            Event newEvent = new Event();
            newEvent.data = event.data;
            newEvent.display = event.display;
            newEvent.time = event.time;
            newEvent.widget = event.widget;
            ModifyEvent mevent = new ModifyEvent(newEvent);
            AuthenticationFrame.this.forwardEventToExternalListeners(mevent);
        }
    }

    class TextModifyListener
    implements ModifyListener {
        TextModifyListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            AuthenticationFrame.this.forwardEventToExternalListeners(arg0);
        }
    }
}

