/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.IToken;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.parser.ASTNodeUtil;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements IToken,
IASTNode {
    protected Terminal terminal = null;
    protected String whiteBefore = "";
    protected String text = "";
    protected String whiteAfter = "";
    protected IPreprocessorReplacement preprocessorDirective = null;
    protected FileOrIFile physicalFile = null;
    protected IFile logicalFile = null;
    protected int line = -1;
    protected int col = -1;
    protected int fileOffset = -1;
    protected int streamOffset = -1;
    protected int length = -1;
    protected PhotranTokenRef tokenRef = null;
    private static final Pattern ompComment = Pattern.compile("([Cc*!][ \\t]*\\$[Oo][Mm][Pp][ \\t]*)([^\\r\\n]*\\r?\\n)");
    private IASTNode parent = null;

    public Token(Terminal terminal, String whiteBefore, String tokenText, String whiteAfter) {
        this.terminal = terminal;
        this.whiteBefore = whiteBefore == null ? "" : whiteBefore;
        this.text = tokenText == null ? "" : tokenText;
        this.whiteAfter = whiteAfter == null ? "" : whiteAfter;
    }

    public Token(Terminal terminal, String tokenText) {
        this(terminal, null, tokenText, null);
    }

    protected Token(Token copyFrom) {
        this.terminal = copyFrom.terminal;
        this.whiteBefore = copyFrom.whiteBefore;
        this.text = copyFrom.text;
        this.whiteAfter = copyFrom.whiteAfter;
        this.preprocessorDirective = copyFrom.preprocessorDirective;
        this.physicalFile = copyFrom.physicalFile;
        this.logicalFile = copyFrom.logicalFile;
        this.line = copyFrom.line;
        this.col = copyFrom.col;
        this.fileOffset = copyFrom.fileOffset;
        this.streamOffset = copyFrom.streamOffset;
        this.length = copyFrom.length;
        this.tokenRef = copyFrom.tokenRef;
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public void setTerminal(Terminal value) {
        this.terminal = value;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String value) {
        this.text = value == null ? "" : value;
    }

    @Override
    public String getWhiteBefore() {
        return this.whiteBefore;
    }

    @Override
    public void setWhiteBefore(String value) {
        this.whiteBefore = value == null ? "" : value;
    }

    @Override
    public String getWhiteAfter() {
        return this.whiteAfter;
    }

    @Override
    public void setWhiteAfter(String value) {
        this.whiteAfter = value == null ? "" : value;
    }

    @Override
    public IPreprocessorReplacement getPreprocessorDirective() {
        return this.preprocessorDirective;
    }

    @Override
    public void setPreprocessorDirective(IPreprocessorReplacement preprocessorDirective) {
        this.preprocessorDirective = preprocessorDirective;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public void setCol(int col) {
        this.col = col;
    }

    @Override
    public FileOrIFile getPhysicalFile() {
        return this.physicalFile;
    }

    @Override
    public void setPhysicalFile(FileOrIFile file) {
        this.physicalFile = file;
    }

    public IFile getLogicalFile() {
        return this.logicalFile;
    }

    public void setLogicalFile(IFile file) {
        this.logicalFile = file;
    }

    @Override
    public int getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public void setFileOffset(int fileOffset) {
        this.fileOffset = fileOffset;
    }

    @Override
    public int getStreamOffset() {
        return this.streamOffset;
    }

    @Override
    public void setStreamOffset(int streamOffset) {
        this.streamOffset = streamOffset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    public boolean containsFileOffset(int offset) {
        return OffsetLength.contains((int)this.fileOffset, (int)this.length, (int)offset, (int)0);
    }

    public boolean containsFileOffset(OffsetLength other) {
        return OffsetLength.contains((int)this.fileOffset, (int)this.length, (OffsetLength)other);
    }

    public boolean isOnOrAfterFileOffset(int targetOffset) {
        return this.fileOffset >= targetOffset;
    }

    public boolean containsStreamOffset(OffsetLength other) {
        return OffsetLength.contains((int)this.streamOffset, (int)this.length, (OffsetLength)other);
    }

    public boolean isOnOrAfterStreamOffset(int targetOffset) {
        return this.streamOffset >= targetOffset;
    }

    public List<Token> getOpenMPComments() {
        String whitetext = this.getWhiteBefore();
        Matcher m = ompComment.matcher(whitetext);
        int startStreamOffset = this.getStreamOffset() - whitetext.length();
        int startFileOffset = this.getFileOffset() - whitetext.length();
        LinkedList<Token> result = new LinkedList<Token>();
        int startSearchFrom = 0;
        while (m.find(startSearchFrom)) {
            Token token = new Token(this);
            token.setTerminal(Terminal.SKIP);
            String prefix = m.group(1);
            String directive = m.group(2).trim();
            String suffix = directive.length() >= m.group(2).length() ? "" : m.group(2).substring(directive.length());
            token.setWhiteBefore(prefix);
            token.setText(directive);
            token.setWhiteAfter(suffix);
            token.setStreamOffset(startStreamOffset + m.start());
            token.setFileOffset(startFileOffset + m.start());
            token.setLength(prefix.length() + directive.length());
            token.setParent(null);
            token.setLine(token.getLine() - this.countNewlines(whitetext.substring(m.start())));
            token.setCol(1);
            result.add(token);
            startSearchFrom = m.end();
        }
        return result;
    }

    private int countNewlines(String s) {
        int n = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                ++n;
            }
            ++i;
        }
        return n;
    }

    @Override
    public IASTNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IASTNode parent) {
        this.parent = parent;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visitToken(this);
    }

    @Override
    public <T extends IASTNode> T findFirst(Class<T> targetClass) {
        return ASTNodeUtil.findFirst(this, targetClass);
    }

    @Override
    public <T extends IASTNode> T findLast(Class<T> targetClass) {
        return ASTNodeUtil.findLast(this, targetClass);
    }

    @Override
    public Token findFirstToken() {
        return this;
    }

    @Override
    public Token findLastToken() {
        return this;
    }

    @Override
    public <T extends IASTNode> T findNearestAncestor(Class<T> targetClass) {
        return ASTNodeUtil.findNearestAncestor(this, targetClass);
    }

    @Override
    public Iterable<? extends IASTNode> getChildren() {
        return new LinkedList();
    }

    @Override
    public boolean isFirstChildInList() {
        return ASTNodeUtil.isFirstChildInList(this);
    }

    @Override
    public void replaceChild(IASTNode node, IASTNode withNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFromTree() {
        ASTNodeUtil.removeFromTree(this);
    }

    @Override
    public void replaceWith(IASTNode newNode) {
        ASTNodeUtil.replaceWith((IASTNode)this, newNode);
    }

    @Override
    public void replaceWith(String string) {
        ASTNodeUtil.replaceWith((IASTNode)this, string);
    }

    @Override
    public Object clone() {
        return new Token(this);
    }

    public String getDescription() {
        return String.valueOf(this.terminal.toString()) + ": \"" + this.text + "\"";
    }

    @Override
    public IPreprocessorReplacement printOn(PrintStream out, IPreprocessorReplacement currentPreprocessorDirective) {
        if (this.preprocessorDirective != currentPreprocessorDirective) {
            if (this.preprocessorDirective != null) {
                out.print(this.whiteBefore);
                out.print(this.preprocessorDirective);
            }
            currentPreprocessorDirective = this.preprocessorDirective;
        }
        if (currentPreprocessorDirective == null && this.preprocessorDirective == null) {
            out.print(this.whiteBefore);
            out.print(this.text);
            out.print(this.whiteAfter);
        }
        return currentPreprocessorDirective;
    }

    public String toString() {
        return this.terminal + ": " + this.text.replace("\n", "\\n").replace("\r", "\\r");
    }

    public PhotranTokenRef getTokenRef() {
        if (this.tokenRef == null) {
            this.tokenRef = new PhotranTokenRef(this.logicalFile, this.streamOffset, this.length);
        }
        return this.tokenRef;
    }

    public ScopingNode getEnclosingScope() {
        return ScopingNode.getEnclosingScope(this);
    }

    public ScopingNode getLocalScope() {
        return ScopingNode.getLocalScope(this);
    }

    public List<PhotranTokenRef> manuallyResolveBinding() {
        return this.getEnclosingScope().manuallyResolve(this);
    }

    public List<PhotranTokenRef> manuallyResolveBindingNoImplicits() {
        return this.getEnclosingScope().manuallyResolveNoImplicits(this);
    }

    public ScopingNode findScopeDeclaringOrImporting(Definition definition) {
        return this.getEnclosingScope().findScopeDeclaringOrImporting(definition.getTokenRef().findToken());
    }

    public List<Definition> resolveBinding() {
        LinkedList<Definition> result = new LinkedList<Definition>();
        Definition def = PhotranVPG.getInstance().getDefinitionFor(this.getTokenRef());
        if (def != null) {
            result.add(def);
            return result;
        }
        for (VPGEdge edge : PhotranVPG.getDatabase().getOutgoingEdgesFrom(this.getTokenRef(), 2)) {
            def = PhotranVPG.getInstance().getDefinitionFor((PhotranTokenRef)edge.getSink());
            if (def == null) continue;
            result.add(def);
        }
        return result;
    }

    public boolean isIdentifier() {
        return this.getTerminal() == Terminal.T_IDENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeToken
    extends Token {
        private ScopingNode scope;
        private FakeTokenRef tokenRef;

        public FakeToken(Token basedOn, String text) {
            super(basedOn);
            this.setText(text);
            this.scope = basedOn.getEnclosingScope();
            this.tokenRef = new FakeTokenRef(basedOn.getTokenRef(), text);
        }

        public FakeToken(ScopingNode scope, String text) {
            super(new Token(null, text));
            this.setText(text);
            this.scope = scope;
            this.tokenRef = new FakeTokenRef(text);
        }

        @Override
        public String getText() {
            return this.tokenRef.getText();
        }

        @Override
        public PhotranTokenRef getTokenRef() {
            return this.tokenRef;
        }

        @Override
        public List<PhotranTokenRef> manuallyResolveBinding() {
            return this.scope.manuallyResolve(this);
        }

        private static class FakeTokenRef
        extends PhotranTokenRef {
            private static final long serialVersionUID = 1L;
            private String text;

            public FakeTokenRef(PhotranTokenRef basedOn, String text) {
                super(basedOn);
                this.text = text;
            }

            public FakeTokenRef(String text) {
                this(new PhotranTokenRef("", -1, -1), text);
            }

            public String getText() {
                return this.text;
            }
        }
    }
}

