/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.xlc.ui.properties;

import java.net.URI;
import org.eclipse.cdt.managedbuilder.xlc.ui.XLCUIPlugin;
import org.eclipse.cdt.managedbuilder.xlc.ui.properties.XLCompilerPropertyPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.internal.rdt.ui.RSEUtils;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.ptp.rdt.managedbuilder.xlc.ui.messages.Messages;
import org.eclipse.ptp.rdt.managedbuilder.xlc.ui.properties.RemoteDirectoryFieldEditor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.widgets.Composite;

public class RemoteXLCompilerPropertyPage
extends XLCompilerPropertyPage {
    public void createPathEditor() {
        IProject thisProject = ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
        if (RemoteNature.hasRemoteNature((IProject)thisProject)) {
            this.createPathEditor4RemoteProject();
        } else {
            super.createPathEditor();
        }
    }

    public void createPathEditor4RemoteProject() {
        Composite parent = this.getFieldEditorParent();
        final IProject thisProject = ((IResource)this.getElement().getAdapter(IResource.class)).getProject();
        IHost projectHost = RSEUtils.getAnyConnection((URI)thisProject.getLocationURI());
        if (projectHost != null) {
            final String projectHostName = projectHost.getHostName();
            this.fPathEditor = new RemoteDirectoryFieldEditor("XL_compilerRoot", Messages.getString("REMOTEXLCompilerPropertyPage_0", projectHost.getHostName()), parent, projectHost){

                protected boolean doCheckState() {
                    IHost projectConnectedHost = RSEUtils.getConnection((URI)thisProject.getLocationURI());
                    if (projectConnectedHost == null) {
                        RemoteXLCompilerPropertyPage.this.setMessage(Messages.getString("XLCompilerPropertyPage_DisconnectedErrorMsg", projectHostName), 2);
                    } else if (!super.doCheckState()) {
                        RemoteXLCompilerPropertyPage.this.setMessage(Messages.getString("XLCompilerPropertyPage_ErrorMsg", projectHostName), 2);
                    } else {
                        RemoteXLCompilerPropertyPage.this.setMessage(RemoteXLCompilerPropertyPage.this.originalMessage);
                    }
                    return true;
                }

                protected boolean checkState() {
                    return this.doCheckState();
                }
            };
            this.addField((FieldEditor)this.fPathEditor);
            String currentPath = null;
            try {
                currentPath = thisProject.getPersistentProperty(new QualifiedName("", "XL_compilerRoot"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (currentPath == null) {
                IPreferenceStore prefStore = XLCUIPlugin.getDefault().getPreferenceStore();
                currentPath = prefStore.getString("XL_compilerRoot");
            }
            this.fPathEditor.setStringValue(currentPath);
        } else {
            this.setMessage(Messages.getString("XLCompilerPropertyPage_NoHostErrorMsg"), 3);
        }
    }
}

