/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPArgumentList {
    private static final int VALUE_OFFSET = 6;
    private static final int NODE_SIZE = 10;

    public static long putArguments(PDOMNode parent, ICPPTemplateArgument[] templateArguments) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = Math.min(templateArguments.length, 409);
        long p = block = db.malloc(2 + 10 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            ICPPTemplateArgument arg = templateArguments[i];
            boolean isNonType = arg.isNonTypeValue();
            if (isNonType) {
                linkage.storeType(p, arg.getTypeOfNonTypeValue());
                long valueRec = PDOMValue.store(db, linkage, arg.getNonTypeValue());
                db.putRecPtr(p + 6L, valueRec);
            } else {
                linkage.storeType(p, arg.getTypeValue());
            }
            ++i;
            p += 10L;
        }
        return block;
    }

    public static void clearArguments(PDOMNode parent, long record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(record);
        Assert.isTrue((len >= 0 && len <= 409 ? 1 : 0) != 0);
        long p = record + 2L;
        int i = 0;
        while (i < len) {
            linkage.storeType(p, null);
            long nonTypeValueRec = db.getRecPtr(p + 6L);
            PDOMValue.delete(db, nonTypeValueRec);
            p += 10L;
            ++i;
        }
        db.free(record);
    }

    public static ICPPTemplateArgument[] getArguments(PDOMNode parent, long rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 409 ? 1 : 0) != 0);
        if (len == 0) {
            return ICPPTemplateArgument.EMPTY_ARGUMENTS;
        }
        rec += 2L;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[len];
        int i = 0;
        while (i < len) {
            long nonTypeValRec;
            IType type = linkage.loadType(rec);
            if (type == null) {
                type = new CPPBasicType(IBasicType.Kind.eUnspecified, CPPBasicType.UNIQUE_TYPE_QUALIFIER);
            }
            if ((nonTypeValRec = db.getRecPtr(rec + 6L)) != 0L) {
                IValue val = PDOMValue.restore(db, linkage, nonTypeValRec);
                result[i] = new CPPTemplateArgument(val, type);
            } else {
                result[i] = new CPPTemplateArgument(type);
            }
            rec += 10L;
            ++i;
        }
        return result;
    }
}

