/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTIdExpression
extends ASTNode
implements IASTIdExpression,
IASTCompletionContext {
    private IASTName name;

    public CPPASTIdExpression() {
    }

    public CPPASTIdExpression(IASTName name) {
        this.setName(name);
    }

    public CPPASTIdExpression copy() {
        CPPASTIdExpression copy = new CPPASTIdExpression(this.name == null ? null : this.name.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ID_NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (this.name == n) {
            return 1;
        }
        return 3;
    }

    public IType getExpressionType() {
        IBinding binding = this.name.resolvePreBinding();
        try {
            if (binding instanceof IVariable) {
                IType thisType;
                IScope scope;
                IVariable var = (IVariable)binding;
                IType type = SemanticUtil.mapToAST(var.getType(), this);
                if (var instanceof ICPPField && !var.isStatic() && (scope = CPPVisitor.getContainingScope(this.name)) != null && (thisType = CPPVisitor.getThisType(scope)) != null) {
                    thisType = SemanticUtil.getNestedType(thisType, 19);
                    type = CPPASTFieldReference.addQualifiersForAccess((ICPPField)var, type, thisType);
                }
                return type;
            }
            if (binding instanceof IEnumerator) {
                ICPPEnumeration enumType;
                IType type = ((IEnumerator)binding).getType();
                if (type instanceof ICPPEnumeration && (enumType = (ICPPEnumeration)type).asScope() == CPPVisitor.getContainingScope(this)) {
                    IType fixedType = enumType.getFixedType();
                    if (fixedType != null) {
                        return fixedType;
                    }
                    return CPPSemantics.INT_TYPE;
                }
                return type;
            }
            if (binding instanceof IProblemBinding) {
                return (IType)((Object)binding);
            }
            if (binding instanceof IFunction) {
                return SemanticUtil.mapToAST(((IFunction)binding).getType(), this);
            }
            if (binding instanceof ICPPTemplateNonTypeParameter) {
                return ((ICPPTemplateNonTypeParameter)binding).getType();
            }
            if (binding instanceof ICPPClassType) {
                return (ICPPClassType)binding;
            }
            if (binding instanceof ICPPUnknownBinding) {
                return CPPUnknownClass.createUnnamedInstance();
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }

    public boolean isLValue() {
        IBinding b = this.getName().resolveBinding();
        return b instanceof IVariable || b instanceof IFunction;
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return CPPSemantics.findBindingsForContentAssist(n, isPrefix);
    }

    public String toString() {
        return this.name != null ? this.name.toString() : "<unnamed>";
    }
}

