/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.ASTLoopControlNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IBodyConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.UserInputBoolean;
import org.eclipse.rephraserengine.core.refactorings.UserInputString;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnrollLoopRefactoring
extends FortranEditorRefactoring {
    private String LOOP_UPPER_BOUND = "loopUpperBound";
    private ASTProperLoopConstructNode doLoop = null;
    private boolean isCompleteUnrolling = false;
    private int iterationStep = 0;
    private boolean check = true;

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        IASTListNode<IExecutionPartConstruct> body;
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.doLoop = UnrollLoopRefactoring.getLoopNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (this.doLoop == null) {
            this.fail(Messages.ReverseLoopRefactoring_SelectDoLoop);
        }
        if (this.checkForLabels(body = this.doLoop.getBody())) {
            this.fail(Messages.UnrollLoopRefactoring_cannotUnrollLoopWithLabel);
        }
        try {
            this.doLoop.getStepInt();
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(Messages.UnrollLoopRefactoring_InvalidStepError);
        }
        if (!(this.doLoop.getUpperBoundIExpr() instanceof ASTIntConstNode) && !this.checkLoopUpperBoundsNameAvailable()) {
            this.fail(Messages.UnrollLoopRefactoring_unableToCreateUpperBound);
        }
        if (this.checkIndexVariableWrite(this.doLoop.getBody())) {
            this.fail(Messages.bind((String)Messages.UnrollLoopRefactoring_LoopWritesToIndexVariable, (Object)this.doLoop.getIndexVariable().getText()));
        }
    }

    private boolean checkIndexVariableWrite(IASTNode node) {
        FindNameVisitor findNameUse = new FindNameVisitor(this.doLoop.getIndexVariable().getText());
        node.accept(findNameUse);
        return findNameUse.getNameIsUsed();
    }

    private boolean checkLoopUpperBoundsNameAvailable() {
        int i = 1;
        while (i <= 10) {
            boolean canUse = true;
            ScopingNode scope = ScopingNode.getLocalScope(this.doLoop);
            List<Definition> defList = scope.getAllDefinitions();
            for (Definition d : defList) {
                if (d == null || !d.getCanonicalizedName().equals(this.LOOP_UPPER_BOUND.toLowerCase())) continue;
                this.LOOP_UPPER_BOUND = "loopUpperBound" + Integer.toString(i);
                canUse = false;
            }
            if (canUse) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        if (!(this.doLoop.getLowerBoundIExpr() instanceof ASTIntConstNode && this.doLoop.getUpperBoundIExpr() instanceof ASTIntConstNode || !this.isCompleteUnrolling)) {
            this.fail(Messages.UnrollLoopRefactoring_SelectLoopWithExplicitBound);
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ASTLoopControlNode doLoopControlNode = this.doLoop.getLoopHeader().getLoopControl();
        IASTListNode<IExecutionPartConstruct> doLoopBody = this.doLoop.getBody();
        IASTNode doLoopParent = this.doLoop.getParent();
        if (this.isCompleteUnrolling) {
            this.completeLoopUnrolling(doLoopControlNode, doLoopBody);
        } else {
            this.numberedLoopUnrolling(doLoopBody, doLoopControlNode);
        }
        Reindenter.reindent(doLoopParent, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private boolean checkForLabels(IASTListNode<IExecutionPartConstruct> body) {
        int i = 0;
        while (i < body.size()) {
            if (((IExecutionPartConstruct)body.get(i)).findFirstToken().getTerminal() == Terminal.T_ICON) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void numberedLoopUnrolling(IASTListNode<IExecutionPartConstruct> doLoopBody, ASTLoopControlNode doLoopControlNode) {
        if (!(this.doLoop.getUpperBoundIExpr() instanceof ASTIntConstNode)) {
            this.evalExpressionBeforeLoop();
            doLoopControlNode.setUb(UnrollLoopRefactoring.parseLiteralExpression(this.LOOP_UPPER_BOUND));
        }
        boolean checkAllStatements = false;
        IASTListNode newBody = (IASTListNode)doLoopBody.clone();
        IASTListNode dummyBody = null;
        String iterationName = doLoopControlNode.getVariableName().getText();
        int step = 1;
        int checkBound = 0;
        if (this.doLoop.getLowerBoundIExpr() instanceof ASTIntConstNode && this.doLoop.getUpperBoundIExpr() instanceof ASTIntConstNode) {
            int high = this.doLoop.getUpperBoundInt();
            int low = this.doLoop.getLowerBoundInt();
            checkBound = (high - low + 1) % (step * this.iterationStep);
        } else {
            checkAllStatements = true;
        }
        step = this.doLoop.getStepInt();
        int i = 1;
        while (i < this.iterationStep) {
            dummyBody = this.replaceIndexVariableNameInBody(this.doLoop.getBody(), iterationName, i * step);
            if (this.check && (i == checkBound || checkAllStatements)) {
                dummyBody.add(0, this.includeBoundsCheck(i * step, iterationName));
            }
            newBody.addAll(dummyBody);
            ++i;
        }
        doLoopBody.replaceWith(newBody);
        this.doLoop.setStepInt(step * this.iterationStep);
    }

    private IASTNode includeBoundsCheck(int indexPlus, String iterationName) {
        IASTListNode<IBodyConstruct> checkNode = null;
        IExpr upper = this.doLoop.getUpperBoundIExpr();
        String checkBounds = "if(" + iterationName + "+" + indexPlus;
        checkBounds = this.doLoop.getStepInt() > 0 ? String.valueOf(checkBounds) + ">" + upper.findFirstToken().getText() : String.valueOf(checkBounds) + "<" + upper.findFirstToken().getText();
        checkBounds = String.valueOf(checkBounds) + ") exit";
        checkNode = UnrollLoopRefactoring.parseLiteralStatementSequence(checkBounds);
        return checkNode;
    }

    private void evalExpressionBeforeLoop() {
        ScopingNode scope = ScopingNode.getLocalScope(this.doLoop);
        IASTListNode body = scope.getOrCreateBody();
        String declarationString = "integer :: " + this.LOOP_UPPER_BOUND;
        int insertionIndex = UnrollLoopRefactoring.findIndexToInsertTypeDeclaration(body);
        body.add(insertionIndex, UnrollLoopRefactoring.parseLiteralStatement(declarationString));
        body = this.doLoop.findNearestAncestor(IASTListNode.class);
        String upperBound = String.valueOf(this.LOOP_UPPER_BOUND) + " = " + this.doLoop.getUpperBoundIExpr().toString();
        int upperBoundIndx = body.indexOf(this.doLoop);
        IBodyConstruct upperBoundNode = UnrollLoopRefactoring.parseLiteralStatement(upperBound);
        body.add(upperBoundIndx, upperBoundNode);
    }

    private IASTListNode replaceIndexVariableNameInBody(IASTNode node, final String name, final int iteration) {
        IASTListNode newBody = (IASTListNode)node.clone();
        newBody.accept(new ASTVisitorWithLoops(){

            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equals(name)) {
                    String s2 = token.getText();
                    s2 = "(" + s2 + "+" + Integer.toString(iteration) + ")";
                    token.replaceWith(s2);
                }
            }
        });
        return newBody;
    }

    private void completeLoopUnrolling(ASTLoopControlNode doLoopControlNode, IASTListNode<IExecutionPartConstruct> doLoopBody) {
        Token varName = doLoopControlNode.getVariableName();
        String iterationName = varName.getText();
        int l = this.doLoop.getLowerBoundInt();
        int h = this.doLoop.getUpperBoundInt();
        int step = 1;
        step = this.doLoop.getStepInt();
        IASTListNode<IExecutionPartConstruct> dummyBody = null;
        IASTListNode<IExecutionPartConstruct> newBody = null;
        newBody = this.replaceIndexVariableNameWithConst(doLoopBody, l, iterationName);
        int counter = 1;
        int bound = Math.abs(h - l);
        int j = l;
        while (counter <= bound) {
            dummyBody = this.replaceIndexVariableNameWithConst(doLoopBody, j += step, iterationName);
            newBody.addAll(dummyBody);
            counter += Math.abs(step);
        }
        this.doLoop.replaceWith(newBody);
    }

    private IASTListNode<IExecutionPartConstruct> replaceIndexVariableNameWithConst(IASTNode node, final int stepNum, final String iterationName) {
        IASTListNode newBody = (IASTListNode)node.clone();
        newBody.accept(new ASTVisitorWithLoops(){

            public void visitToken(Token token) {
                if (token.getTerminal() == Terminal.T_IDENT && token.getText().equalsIgnoreCase(iterationName)) {
                    String s = Integer.toString(stepNum);
                    token.setText(s);
                }
            }
        });
        return newBody;
    }

    @UserInputString(label="Enter unrolling count ", defaultValueMethod="getSuggestedUnrollingCount")
    public void setLoopUnrollNumber(String input) {
        this.iterationStep = Integer.parseInt(input);
    }

    public String getSuggestedUnrollingCount() {
        return "4";
    }

    @UserInputBoolean(label="Complete unrolling")
    public void setComplete(boolean isComplete) {
        this.isCompleteUnrolling = isComplete;
    }

    @UserInputBoolean(label="Include bounds checking", defaultValue=true)
    public void setBoundsChecking(boolean boundsCheck) {
        this.check = boundsCheck;
    }

    public String getName() {
        return Messages.UnrollLoopRefactoring_LoopUnrollingName;
    }

    public class FindNameVisitor
    extends ASTVisitorWithLoops {
        private boolean indexIsWritten = false;
        private String indexVariableName;

        public FindNameVisitor(String name) {
            this.indexVariableName = name;
        }

        public boolean getNameIsUsed() {
            return this.indexIsWritten;
        }

        public void visitToken(Token token) {
            if (token.getTerminal() == Terminal.T_IDENT && token.getText().equals(this.indexVariableName) && token.getVariableAccessType().equals(VariableAccess.WRITE)) {
                this.indexIsWritten = true;
            }
        }
    }
}

