/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.rm.core.RMCorePlugin;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.utils.core.ArgumentParser;

public abstract class AbstractRemoteCommandJob
extends Job {
    protected static final String EMPTY_STRING = "";
    protected String fCommand;
    protected String fInterruptedErrorMessage;
    protected String fProcessErrorMessage;
    protected String fParsingErrorMessage;
    protected int fReschedule = 0;
    protected IRemoteProcess fJobProcess;
    protected AbstractToolRuntimeSystem fRtSystem;

    public AbstractRemoteCommandJob(AbstractToolRuntimeSystem rtSystem, String name, String command, String interruptedErrorMessage, String processErrorMessage, String parsingErrorMessage) {
        super(name);
        this.fRtSystem = rtSystem;
        this.fCommand = command;
        this.fInterruptedErrorMessage = interruptedErrorMessage;
        this.fProcessErrorMessage = processErrorMessage;
        this.fParsingErrorMessage = parsingErrorMessage;
    }

    public AbstractRemoteCommandJob(AbstractToolRuntimeSystem rtSystem, String name, String command, String interruptedErrorMessage, String processErrorMessage, String parsingErrorMessage, int reschedule) {
        super(name);
        this.fRtSystem = rtSystem;
        this.fCommand = command;
        this.fInterruptedErrorMessage = interruptedErrorMessage;
        this.fProcessErrorMessage = processErrorMessage;
        this.fParsingErrorMessage = parsingErrorMessage;
        this.fReschedule = reschedule;
    }

    protected abstract void parse(BufferedReader var1) throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        block57: {
            block55: {
                Status status;
                block56: {
                    block53: {
                        Status status2;
                        block54: {
                            block51: {
                                Status status3;
                                block52: {
                                    block49: {
                                        Status status4;
                                        block50: {
                                            List arguments;
                                            block46: {
                                                Status status5;
                                                block47: {
                                                    Assert.isNotNull((Object)((Object)this.fRtSystem));
                                                    Assert.isNotNull((Object)this.fCommand);
                                                    Assert.isTrue((!this.fCommand.trim().equals(EMPTY_STRING) ? 1 : 0) != 0);
                                                    ArgumentParser argumentParser = new ArgumentParser(this.fCommand);
                                                    arguments = argumentParser.getTokenList();
                                                    if (!monitor.isCanceled()) break block46;
                                                    status5 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
                                                    if (this.fJobProcess == null) break block47;
                                                    try {
                                                        this.fJobProcess.getInputStream().close();
                                                    }
                                                    catch (IOException iOException) {}
                                                    this.fJobProcess.destroy();
                                                    this.fJobProcess = null;
                                                }
                                                return status5;
                                            }
                                            try {
                                                IRemoteProcessBuilder cmdBuilder = this.fRtSystem.createProcessBuilder(arguments);
                                                AbstractRemoteCommandJob abstractRemoteCommandJob = this;
                                                synchronized (abstractRemoteCommandJob) {
                                                    DebugUtil.trace(DebugUtil.COMMAND_TRACING, "Run command: {0}", this.fCommand);
                                                    this.fJobProcess = cmdBuilder.start();
                                                }
                                            }
                                            catch (IOException e) {
                                                Status status6 = new Status(4, "org.eclipse.ptp.rm.core", this.fProcessErrorMessage, (Throwable)e);
                                                if (this.fJobProcess != null) {
                                                    try {
                                                        this.fJobProcess.getInputStream().close();
                                                    }
                                                    catch (IOException iOException) {}
                                                    this.fJobProcess.destroy();
                                                    this.fJobProcess = null;
                                                }
                                                return status6;
                                            }
                                            if (!monitor.isCanceled()) break block49;
                                            status4 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
                                            if (this.fJobProcess == null) break block50;
                                            try {
                                                this.fJobProcess.getInputStream().close();
                                            }
                                            catch (IOException iOException) {}
                                            this.fJobProcess.destroy();
                                            this.fJobProcess = null;
                                        }
                                        return status4;
                                    }
                                    this.parse(new BufferedReader(new InputStreamReader(this.fJobProcess.getInputStream())));
                                    while (!this.fJobProcess.isCompleted() && !monitor.isCanceled()) {
                                        System.out.println("waiting for job");
                                        AbstractRemoteCommandJob e = this;
                                        synchronized (e) {
                                            ((Object)((Object)this)).wait(500L);
                                        }
                                    }
                                    if (!monitor.isCanceled()) break block51;
                                    status3 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
                                    if (this.fJobProcess == null) break block52;
                                    try {
                                        this.fJobProcess.getInputStream().close();
                                    }
                                    catch (IOException iOException) {}
                                    this.fJobProcess.destroy();
                                    this.fJobProcess = null;
                                }
                                return status3;
                            }
                            if (this.fJobProcess.exitValue() == 0) break block53;
                            status2 = new Status(4, RMCorePlugin.getDefault().getBundle().getSymbolicName(), NLS.bind((String)"Command failed with exit status {0}", (Object)this.fJobProcess.exitValue()), null);
                            if (this.fJobProcess == null) break block54;
                            try {
                                this.fJobProcess.getInputStream().close();
                            }
                            catch (IOException iOException) {}
                            this.fJobProcess.destroy();
                            this.fJobProcess = null;
                        }
                        return status2;
                    }
                    if (!monitor.isCanceled()) break block55;
                    status = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
                    if (this.fJobProcess == null) break block56;
                    try {
                        this.fJobProcess.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    this.fJobProcess.destroy();
                    this.fJobProcess = null;
                }
                return status;
            }
            try {
                DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: waiting to finish.");
                this.fJobProcess.waitFor();
            }
            catch (InterruptedException e) {
                Status status = new Status(1, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, (Throwable)e);
                if (this.fJobProcess != null) {
                    try {
                        this.fJobProcess.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    this.fJobProcess.destroy();
                    this.fJobProcess = null;
                }
                return status;
            }
            DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: exit value {0}.", this.fJobProcess.exitValue());
            if (this.fReschedule > 0) {
                DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: reschedule in {0} miliseconds.", this.fReschedule);
                this.schedule(this.fReschedule);
            }
            iStatus = Status.OK_STATUS;
            if (this.fJobProcess == null) break block57;
            try {
                this.fJobProcess.getInputStream().close();
            }
            catch (IOException iOException) {}
            this.fJobProcess.destroy();
            this.fJobProcess = null;
        }
        return iStatus;
        catch (Exception e) {
            Status status;
            block58: {
                try {
                    DebugUtil.error(DebugUtil.COMMAND_TRACING_MORE, "Command failed: {0}", e);
                    this.fRtSystem.notifyMonitorFailed(this, e);
                    status = new Status(4, "org.eclipse.ptp.rm.core", e.getLocalizedMessage());
                    if (this.fJobProcess == null) break block58;
                }
                catch (Throwable throwable) {
                    if (this.fJobProcess != null) {
                        try {
                            this.fJobProcess.getInputStream().close();
                        }
                        catch (IOException iOException) {}
                        this.fJobProcess.destroy();
                        this.fJobProcess = null;
                    }
                    throw throwable;
                }
                try {
                    this.fJobProcess.getInputStream().close();
                }
                catch (IOException iOException) {}
                this.fJobProcess.destroy();
                this.fJobProcess = null;
            }
            return status;
        }
    }
}

