/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.utils;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.ptp.rm.core.utils.ITextInputStreamListener;

public class TextInputStreamObserver
extends Thread {
    private final BufferedReader reader;
    private boolean killed;
    private final ITextInputStreamListener listener;

    public TextInputStreamObserver(BufferedReader input, ITextInputStreamListener listener) {
        this.reader = input;
        this.listener = listener;
        this.setName(this.getClass().getName());
    }

    public TextInputStreamObserver(BufferedReader input, ITextInputStreamListener listener, String name) {
        this.reader = input;
        this.listener = listener;
        this.setName(name);
    }

    public synchronized void kill() {
        this.killed = true;
        this.interrupt();
    }

    void log(String string) {
    }

    void newLine(String line) {
        this.log("Received: " + Integer.toString(line.length()) + " bytes");
        this.listener.newLine(line);
    }

    public void run() {
        while (!this.killed) {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    this.streamClosed();
                    return;
                }
                this.newLine(line);
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
                break;
            }
            catch (NullPointerException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
                break;
            }
        }
    }

    void streamClosed() {
        this.log("Stream closed");
        this.listener.streamClosed();
    }

    void streamError(Exception e) {
        this.log("Recovered from exception: " + e.getMessage());
        this.listener.streamError(e);
    }
}

