/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBlock;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.Util;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;

public class UseDefBuilder
extends ASTVisitor {
    protected ICallGraph cg_;
    protected IControlFlowGraph cfg_ = null;
    protected List<String> use_ = null;
    protected List<String> def_ = null;
    protected List<String> guse_ = null;
    protected List<String> gdef_ = null;
    protected List<String> padef_ = null;
    protected final int lhs = 0;
    protected final int rhs = 1;
    protected MPICallGraphNode currentFunc_;
    protected Hashtable<String, List<IBlock>> defTable_ = null;

    public UseDefBuilder(ICallGraph cg) {
        this.cg_ = cg;
    }

    public void run() {
        MPICallGraphNode node;
        ICallGraphNode n;
        this.shouldVisitDeclarations = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        boolean change = true;
        while (change) {
            change = false;
            n = this.cg_.botEntry();
            while (n != null) {
                node = (MPICallGraphNode)n;
                if (node.marked) {
                    List<String> oldguse_ = node.getGlobalUse();
                    List<String> oldgdef_ = node.getGlobalDef();
                    List<String> oldpadef_ = node.getParamDef();
                    this.guse_ = new ArrayList<String>();
                    this.gdef_ = new ArrayList<String>();
                    this.padef_ = new ArrayList<String>();
                    this.cfg_ = node.getCFG();
                    this.currentFunc_ = node;
                    IBlock b = this.cfg_.getEntry().topNext();
                    while (b != null) {
                        MPIBlock block = (MPIBlock)b;
                        IASTNode content = block.getContent();
                        if (content != null && !(content instanceof IASTName)) {
                            List<String> olduse_ = block.getUse();
                            List<String> olddef_ = block.getDef();
                            this.use_ = new ArrayList<String>();
                            this.def_ = new ArrayList<String>();
                            if (content instanceof IASTExpression) {
                                IASTExpression expr = (IASTExpression)content;
                                expr.accept((ASTVisitor)this);
                            } else {
                                IASTStatement stmt = (IASTStatement)content;
                                stmt.accept((ASTVisitor)this);
                            }
                            if (!Util.equals(this.use_, olduse_)) {
                                block.setUse(this.use_);
                                change = true;
                            }
                            if (!Util.equals(this.def_, olddef_)) {
                                block.setDef(this.def_);
                                change = true;
                            }
                        }
                        b = b.topNext();
                    }
                    if (!Util.equals(this.guse_, oldguse_)) {
                        node.setGlobalUse(this.guse_);
                        change = true;
                    }
                    if (!Util.equals(this.gdef_, oldgdef_)) {
                        node.setGlobalDef(this.gdef_);
                        change = true;
                    }
                    if (!Util.equals(this.padef_, oldpadef_)) {
                        node.setParamDef(this.padef_);
                        change = true;
                    }
                }
                n = n.botNext();
            }
        }
        n = this.cg_.botEntry();
        while (n != null) {
            node = (MPICallGraphNode)n;
            if (node.marked) {
                this.currentFunc_ = node;
                this.cfg_ = node.getCFG();
                this.setEntryBlock((MPIBlock)node.getCFG().getEntry());
                this.setExitBlock((MPIBlock)node.getCFG().getExit());
                this.defTable_ = new Hashtable();
                IBlock b = this.cfg_.getEntry();
                while (b != null) {
                    MPIBlock block = (MPIBlock)b;
                    List<String> def = block.getDef();
                    if (!def.isEmpty()) {
                        for (String var : def) {
                            List<IBlock> defblocks = this.defTable_.get(var);
                            if (defblocks == null) {
                                defblocks = new ArrayList<IBlock>();
                                defblocks.add((IBlock)block);
                                this.defTable_.put(var, defblocks);
                                continue;
                            }
                            defblocks.add((IBlock)block);
                            this.defTable_.put(var, defblocks);
                        }
                    }
                    b = b.topNext();
                }
                node.setDefTable(this.defTable_);
            }
            n = n.botNext();
        }
    }

    public int visit(IASTStatement stmt) {
        if (stmt instanceof IASTDeclarationStatement) {
            IASTDeclarationStatement declStmt = (IASTDeclarationStatement)stmt;
            IASTDeclaration decl = declStmt.getDeclaration();
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                IASTDeclarator[] declarators = simpleDecl.getDeclarators();
                int i = 0;
                while (i < declarators.length) {
                    IASTName name = declarators[i].getName();
                    IASTInitializer init = declarators[i].getInitializer();
                    if (init != null) {
                        this.def_.add(name.toString());
                    }
                    this.processInitializer(init);
                    ++i;
                }
            }
            return 1;
        }
        return 3;
    }

    private void processInitializer(IASTInitializer init) {
        if (init != null) {
            if (init instanceof IASTInitializerExpression) {
                IASTInitializerExpression initE = (IASTInitializerExpression)init;
                IASTExpression e = initE.getExpression();
                this.useDefSet(e, 1, null, -1);
            } else if (init instanceof IASTInitializerList) {
                IASTInitializerList list = (IASTInitializerList)init;
                IASTInitializer[] inits = list.getInitializers();
                int j = 0;
                while (j < inits.length) {
                    this.processInitializer(inits[j]);
                    ++j;
                }
            } else if (init instanceof ICASTDesignatedInitializer) {
                System.out.println("ICASTDesignatedInitializer found !");
            }
        }
    }

    public int visit(IASTExpression expr) {
        this.useDefSet(expr, 1, null, -1);
        return 1;
    }

    public void useDefSet(IASTExpression expr, int side, IASTFunctionCallExpression funcall, int index) {
        if (expr == null) {
            return;
        }
        if (!(expr instanceof IASTAmbiguousExpression)) {
            if (expr instanceof IASTArraySubscriptExpression) {
                IASTArraySubscriptExpression asE = (IASTArraySubscriptExpression)expr;
                if (side == 1) {
                    this.useDefSet(asE.getArrayExpression(), 1, funcall, index);
                    this.useDefSet(asE.getSubscriptExpression(), 1, funcall, index);
                } else {
                    this.useDefSet(asE.getSubscriptExpression(), 1, funcall, index);
                    this.useDefSet(asE.getArrayExpression(), 0, funcall, index);
                }
            } else if (expr instanceof IASTBinaryExpression) {
                IASTBinaryExpression biE = (IASTBinaryExpression)expr;
                int op = biE.getOperator();
                if (op == 17) {
                    this.useDefSet(biE.getOperand1(), 0, funcall, index);
                    this.useDefSet(biE.getOperand2(), 1, funcall, index);
                } else if (op == 18 || op == 19 || op == 20 || op == 21 || op == 22 || op == 23 || op == 24 || op == 25 || op == 26 || op == 27) {
                    this.useDefSet(biE.getOperand1(), 1, funcall, index);
                    this.useDefSet(biE.getOperand2(), 1, funcall, index);
                    this.useDefSet(biE.getOperand1(), 0, funcall, index);
                } else {
                    this.useDefSet(biE.getOperand1(), 1, funcall, index);
                    this.useDefSet(biE.getOperand2(), 1, funcall, index);
                }
            } else if (expr instanceof IASTCastExpression) {
                IASTCastExpression castE = (IASTCastExpression)expr;
                this.useDefSet(castE.getOperand(), side, funcall, index);
            } else if (expr instanceof IASTConditionalExpression) {
                IASTConditionalExpression condE = (IASTConditionalExpression)expr;
                if (side == 1) {
                    this.useDefSet(condE.getLogicalConditionExpression(), 1, funcall, index);
                    this.useDefSet(condE.getPositiveResultExpression(), 1, funcall, index);
                    this.useDefSet(condE.getNegativeResultExpression(), 1, funcall, index);
                } else {
                    this.useDefSet(condE.getLogicalConditionExpression(), 1, funcall, index);
                    this.useDefSet(condE.getPositiveResultExpression(), 0, funcall, index);
                    this.useDefSet(condE.getNegativeResultExpression(), 0, funcall, index);
                }
            } else if (expr instanceof IASTExpressionList) {
                IASTExpressionList exprList = (IASTExpressionList)expr;
                IASTExpression[] exprs = exprList.getExpressions();
                int i = 0;
                while (i < exprs.length) {
                    if (funcall != null) {
                        this.useDefSet(exprs[i], side, funcall, i);
                    } else {
                        this.useDefSet(exprs[i], side, funcall, index);
                    }
                    ++i;
                }
            } else if (expr instanceof IASTFieldReference) {
                IASTFieldReference frE = (IASTFieldReference)expr;
                this.useDefSet(frE.getFieldOwner(), side, funcall, index);
            } else if (expr instanceof IASTFunctionCallExpression) {
                IASTExpression paramE;
                IASTFunctionCallExpression funcE = (IASTFunctionCallExpression)expr;
                IASTExpression funcname = funcE.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                MPICallGraphNode n = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), signature);
                if (n != null) {
                    this.gdef_ = Util.Union(this.gdef_, n.getGlobalDef());
                    this.guse_ = Util.Union(this.guse_, n.getGlobalUse());
                    this.def_ = Util.Union(this.def_, n.getGlobalDef());
                    this.use_ = Util.Union(this.use_, n.getGlobalUse());
                }
                if ((paramE = funcE.getParameterExpression()) == null) {
                    return;
                }
                if (paramE instanceof IASTExpressionList) {
                    this.useDefSet(funcE.getParameterExpression(), side, funcE, -1);
                } else {
                    this.useDefSet(funcE.getParameterExpression(), side, funcE, 0);
                }
            } else if (expr instanceof IASTIdExpression) {
                IASTIdExpression id = (IASTIdExpression)expr;
                IASTName name = id.getName();
                String var = name.toString();
                if (var.startsWith("MPI_")) {
                    return;
                }
                if (side == 1) {
                    if (!this.use_.contains(var)) {
                        this.use_.add(var);
                    }
                    if (this.cg_.getEnv().contains(var) && !this.guse_.contains(var)) {
                        this.guse_.add(var);
                    }
                    if (funcall != null && this.isDefinedParam(funcall, index)) {
                        if (!this.def_.contains(var)) {
                            this.def_.add(var);
                        }
                        if (this.cg_.getEnv().contains(var) && !this.gdef_.contains(var)) {
                            this.gdef_.add(var);
                        }
                        if (this.isPassableParam(var) && !this.padef_.contains(var)) {
                            this.padef_.add(var);
                        }
                    }
                } else {
                    if (!this.def_.contains(var)) {
                        this.def_.add(var);
                    }
                    if (this.cg_.getEnv().contains(var) && !this.gdef_.contains(var)) {
                        this.gdef_.add(var);
                    }
                    if (this.isPassableParam(var) && !this.padef_.contains(var)) {
                        this.padef_.add(var);
                    }
                }
            } else if (!(expr instanceof IASTLiteralExpression || expr instanceof IASTProblemExpression || expr instanceof IASTTypeIdExpression)) {
                if (expr instanceof IASTUnaryExpression) {
                    IASTUnaryExpression uE = (IASTUnaryExpression)expr;
                    int op = uE.getOperator();
                    if (op == 0 || op == 1 || op == 9 || op == 10) {
                        this.useDefSet(uE.getOperand(), 1, funcall, index);
                        this.useDefSet(uE.getOperand(), 0, funcall, index);
                    } else {
                        this.useDefSet(uE.getOperand(), side, funcall, index);
                    }
                } else {
                    boolean cfr_ignored_0 = expr instanceof ICASTTypeIdInitializerExpression;
                }
            }
        }
    }

    private boolean isPassableParam(String name) {
        IASTFunctionDefinition fdef = this.currentFunc_.getFuncDef();
        IASTFunctionDeclarator fdecl = fdef.getDeclarator();
        if (fdecl instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
            IASTParameterDeclaration[] params = sfunc.getParameters();
            int i = 0;
            while (i < params.length) {
                IASTName param = params[i].getDeclarator().getName();
                IASTPointerOperator[] pops = params[i].getDeclarator().getPointerOperators();
                if (name.equals(param.toString()) && pops != IASTPointerOperator.EMPTY_ARRAY) {
                    return true;
                }
                ++i;
            }
        } else {
            ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
            IASTName[] params = krfunc.getParameterNames();
            int i = 0;
            while (i < params.length) {
                IASTDeclarator decl;
                if (name.equals(params[i].toString()) && (decl = krfunc.getDeclaratorForParameterName(params[i])).getPointerOperators() != IASTPointerOperator.EMPTY_ARRAY) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isDefinedParam(IASTFunctionCallExpression fE, int index) {
        if (index == -1) {
            return false;
        }
        IASTExpression funcname = fE.getFunctionNameExpression();
        String signature = funcname.getRawSignature();
        MPICallGraphNode node = (MPICallGraphNode)this.cg_.getNode(this.currentFunc_.getFileName(), signature);
        if (node != null) {
            List<String> padef = node.getParamDef();
            IASTFunctionDefinition fdef = node.getFuncDef();
            IASTFunctionDeclarator fdecl = fdef.getDeclarator();
            if (fdecl instanceof IASTStandardFunctionDeclarator) {
                IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
                IASTParameterDeclaration[] params = sfunc.getParameters();
                if (params.length <= index) {
                    return false;
                }
                IASTName param = params[index].getDeclarator().getName();
                if (padef.contains(param.toString())) {
                    return true;
                }
            } else {
                ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
                IASTName[] params = krfunc.getParameterNames();
                if (params.length <= index) {
                    return false;
                }
                IASTName param = params[index];
                if (padef.contains(param.toString())) {
                    return true;
                }
            }
        } else {
            IType type;
            IASTExpressionList paramEList;
            IASTExpression param;
            IType type2;
            IASTExpression parameterE = fE.getParameterExpression();
            if (parameterE instanceof IASTExpressionList ? (type2 = (param = (paramEList = (IASTExpressionList)parameterE).getExpressions()[index]).getExpressionType()) instanceof IArrayType || type2 instanceof IPointerType : (type = parameterE.getExpressionType()) instanceof IArrayType || type instanceof IPointerType) {
                return true;
            }
        }
        return false;
    }

    private void setEntryBlock(MPIBlock entry) {
        IASTParameterDeclaration param;
        int i;
        IASTParameterDeclaration[] params;
        ArrayList<String> def = new ArrayList<String>();
        IASTFunctionDefinition fdef = this.currentFunc_.getFuncDef();
        IASTFunctionDeclarator fdecl = fdef.getDeclarator();
        if (fdecl instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator sfunc = (IASTStandardFunctionDeclarator)fdecl;
            params = sfunc.getParameters();
            i = 0;
            while (i < params.length) {
                param = params[i].getDeclarator().getName();
                def.add(param.toString());
                ++i;
            }
        } else {
            ICASTKnRFunctionDeclarator krfunc = (ICASTKnRFunctionDeclarator)fdecl;
            params = krfunc.getParameterNames();
            i = 0;
            while (i < params.length) {
                param = params[i];
                def.add(param.toString());
                ++i;
            }
        }
        Iterator<String> i2 = this.currentFunc_.getGlobalUse().iterator();
        while (i2.hasNext()) {
            def.add(i2.next());
        }
        entry.setDef(def);
        entry.setUse(new ArrayList<String>());
    }

    private void setExitBlock(MPIBlock exit) {
        ArrayList<String> use = new ArrayList<String>();
        Iterator<String> i = this.currentFunc_.getGlobalDef().iterator();
        while (i.hasNext()) {
            use.add(i.next());
        }
        i = this.currentFunc_.getParamDef().iterator();
        while (i.hasNext()) {
            use.add(i.next());
        }
        exit.setUse(use);
        exit.setDef(new ArrayList<String>());
    }
}

