/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.LaunchImages;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResourcesTab
extends LaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.ptp.launch.applicationLaunch.resourcesTab";
    private Combo resourceManagerCombo = null;
    private IResourceManager resourceManager = null;
    private final List<IResourceManager> resourceManagers = new ArrayList<IResourceManager>();
    private ScrolledComposite launchAttrsScrollComposite;
    private final Map<IResourceManager, IRMLaunchConfigurationDynamicTab> rmDynamicTabs = new HashMap<IResourceManager, IRMLaunchConfigurationDynamicTab>();
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();

    public boolean canSave() {
        this.setErrorMessage(null);
        if (this.resourceManager == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Resource_Manager);
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
        ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
        if (rmDynamicTab == null || launchComp == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.resourceManager.getName()}));
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.canSave((Control)launchComp, this.resourceManager, null);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        IResourceManager[] rms = PTPCorePlugin.getDefault().getModelManager().getResourceManagers();
        new Label(comp, 0).setText(Messages.ApplicationTab_RM_Selection_Label);
        this.resourceManagerCombo = new Combo(comp, 8);
        gd = new GridData(768);
        this.resourceManagerCombo.setLayoutData((Object)gd);
        this.resourceManagerCombo.add(Messages.ResourcesTab_pleaseSelectRM);
        this.resourceManagers.add(null);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            this.resourceManagerCombo.add(rm.getName());
            this.resourceManagers.add(rm);
            ++n2;
        }
        this.resourceManagerCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ResourcesTab.this.resourceManagerCombo) {
                    ResourcesTab.this.rmSelectionChanged();
                    ResourcesTab.this.updateLaunchAttributeControls(ResourcesTab.this.resourceManager, null, ResourcesTab.this.getLaunchConfiguration());
                    ResourcesTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.resourceManagerCombo.deselectAll();
        this.createVerticalSpacer(comp, 2);
        ScrolledComposite scrollComp = this.createLaunchAttributeControlComposite(comp, 2);
        this.setLaunchAttrsScrollComposite(scrollComp);
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return LaunchImages.getImage(LaunchImages.IMG_PARALLEL_TAB);
    }

    public String getName() {
        return Messages.ResourcesTab_Resources;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.resourceManager = this.getResourceManager(configuration);
        this.setResourceManagerComboSelection(this.resourceManager);
        if (this.resourceManager != null) {
            IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
            ScrolledComposite launchComp = this.getLaunchAttrsScrollComposite();
            if (rmDynamicTab == null || launchComp == null) {
                this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.resourceManager.getName()}));
                return;
            }
        }
        this.updateLaunchAttributeControls(this.resourceManager, null, this.getLaunchConfiguration());
        if (this.resourceManager == null) {
            this.setErrorMessage(Messages.ApplicationTab_No_Resource_Manager_Available);
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.resourceManager == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Resource_Manager);
            return false;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
        if (rmDynamicTab == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.resourceManager.getName()}));
            return false;
        }
        if (!this.resourceManager.getState().equals("STARTED")) {
            this.setErrorMessage(Messages.ResourcesTab_Resource_Manager_Not_Started);
            return false;
        }
        RMLaunchValidation validation = rmDynamicTab.isValid(configuration, this.resourceManager, null);
        if (!validation.isSuccess()) {
            this.setErrorMessage(validation.getMessage());
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.resourceManager != null) {
            configuration.setAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", this.resourceManager.getUniqueName());
            IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(this.resourceManager);
            if (rmDynamicTab == null) {
                this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.resourceManager.getName()}));
                return;
            }
            RMLaunchValidation validation = rmDynamicTab.performApply(configuration, this.resourceManager, null);
            if (!validation.isSuccess()) {
                this.setErrorMessage(validation.getMessage());
                return;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResourceManager rm = this.getResourceManagerDefault();
        if (rm == null) {
            this.setErrorMessage(Messages.ResourcesTab_No_Resource_Manager);
            return;
        }
        String rmName = rm.getUniqueName();
        configuration.setAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", rmName);
        IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
        if (rmDynamicTab == null) {
            this.setErrorMessage(NLS.bind((String)Messages.ResourcesTab_No_Launch_Configuration, (Object[])new Object[]{this.resourceManager.getName()}));
        } else {
            rmDynamicTab.setDefaults(configuration, rm, null);
        }
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    private ScrolledComposite createLaunchAttributeControlComposite(Composite parent, int colspan) {
        ScrolledComposite attrComp = new ScrolledComposite(parent, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = colspan;
        attrComp.setLayoutData((Object)gridData);
        attrComp.setExpandHorizontal(true);
        attrComp.setExpandVertical(true);
        return attrComp;
    }

    private IRMLaunchConfigurationDynamicTab createRMLaunchConfigurationDynamicTab(IResourceManager rm) throws CoreException {
        AbstractRMLaunchConfigurationFactory rmFactory = PTPLaunchPlugin.getDefault().getRMLaunchConfigurationFactory(rm);
        if (rmFactory == null) {
            return null;
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = rmFactory.create(rm, this.getLaunchConfigurationDialog());
        if (rmDynamicTab == null) {
            return null;
        }
        rmDynamicTab.addContentsChangedListener(this.launchContentsChangedListener);
        return rmDynamicTab;
    }

    private ScrolledComposite getLaunchAttrsScrollComposite() {
        return this.launchAttrsScrollComposite;
    }

    private IResourceManager getResourceManagerDefault() {
        IResourceManager[] rms = PTPCorePlugin.getDefault().getModelManager().getResourceManagers();
        if (rms.length != 1) {
            return null;
        }
        return rms[0];
    }

    private IResourceManager getResourceManagerFromCombo() {
        if (this.resourceManagerCombo != null) {
            int i = this.resourceManagerCombo.getSelectionIndex();
            return this.resourceManagers.get(i);
        }
        return null;
    }

    private IRMLaunchConfigurationDynamicTab getRMLaunchConfigurationDynamicTab(IResourceManager rm) {
        if (!this.rmDynamicTabs.containsKey(rm)) {
            try {
                IRMLaunchConfigurationDynamicTab rmDynamicTab = this.createRMLaunchConfigurationDynamicTab(rm);
                this.rmDynamicTabs.put(rm, rmDynamicTab);
                return rmDynamicTab;
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                PTPLaunchPlugin.errorDialog(e.getMessage(), e);
                return null;
            }
        }
        return this.rmDynamicTabs.get(rm);
    }

    private void rmSelectionChanged() {
        this.resourceManager = this.getResourceManagerFromCombo();
    }

    private void setLaunchAttrsScrollComposite(ScrolledComposite comp) {
        this.launchAttrsScrollComposite = comp;
    }

    private void setResourceManagerComboSelection(IResourceManager rm) {
        int i = 0;
        if (rm != null) {
            i = this.resourceManagers.lastIndexOf(rm);
        }
        this.resourceManagerCombo.select(i);
        this.rmSelectionChanged();
    }

    private void updateLaunchAttributeControls(IResourceManager rm, IPQueue queue, ILaunchConfiguration launchConfiguration) {
        ScrolledComposite launchAttrsScrollComp = this.getLaunchAttrsScrollComposite();
        launchAttrsScrollComp.setContent(null);
        Control[] controlArray = launchAttrsScrollComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (rm != null) {
            IRMLaunchConfigurationDynamicTab rmDynamicTab = this.getRMLaunchConfigurationDynamicTab(rm);
            if (rmDynamicTab != null) {
                try {
                    rmDynamicTab.createControl((Composite)launchAttrsScrollComp, rm, queue);
                    Control dynControl = rmDynamicTab.getControl();
                    launchAttrsScrollComp.setContent(dynControl);
                    Point size = dynControl.computeSize(-1, -1);
                    launchAttrsScrollComp.setMinSize(size);
                    rmDynamicTab.initializeFrom((Control)launchAttrsScrollComp, rm, queue, launchConfiguration);
                }
                catch (CoreException e) {
                    this.setErrorMessage(e.getMessage());
                    Throwable t = e.getCause();
                    if (t == null) {
                        t = e;
                    }
                    PTPLaunchPlugin.errorDialog(e.getMessage(), t);
                }
            }
            launchAttrsScrollComp.layout(true);
        }
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            ResourcesTab.this.updateLaunchConfigurationDialog();
        }
    }
}

