/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

class FunctionCost {
    private final ICPPFunction fFunction;
    private final Cost[] fCosts;
    private final IASTExpression.ValueCategory[] fValueCategories;
    private boolean fIsDirectCopyCtor;

    public FunctionCost(ICPPFunction fn, int paramCount) {
        this.fFunction = fn;
        this.fCosts = new Cost[paramCount];
        this.fValueCategories = new IASTExpression.ValueCategory[paramCount];
    }

    public FunctionCost(ICPPFunction fn, Cost cost) {
        this.fFunction = fn;
        this.fCosts = new Cost[]{cost};
        this.fValueCategories = null;
    }

    public int getLength() {
        return this.fCosts.length;
    }

    public Cost getCost(int idx) {
        return this.fCosts[idx];
    }

    public void setCost(int idx, Cost cost, IASTExpression.ValueCategory valueCat) {
        this.fCosts[idx] = cost;
        this.fValueCategories[idx] = valueCat;
    }

    public ICPPFunction getFunction() {
        return this.fFunction;
    }

    public boolean hasAmbiguousUserDefinedConversion() {
        Cost[] costArray = this.fCosts;
        int n = this.fCosts.length;
        int n2 = 0;
        while (n2 < n) {
            Cost cost = costArray[n2];
            if (cost.isAmbiguousUDC()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasDeferredUDC() {
        Cost[] costArray = this.fCosts;
        int n = this.fCosts.length;
        int n2 = 0;
        while (n2 < n) {
            Cost cost = costArray[n2];
            if (!cost.converts()) {
                return false;
            }
            if (cost.isDeferredUDC() != Cost.DeferredUDC.NONE) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean performUDC() throws DOMException {
        int i = 0;
        while (i < this.fCosts.length) {
            block9: {
                Cost cost = this.fCosts[i];
                Cost udcCost = null;
                switch (cost.isDeferredUDC()) {
                    case NONE: {
                        break block9;
                    }
                    case COPY_INIT_OF_CLASS: {
                        udcCost = Conversions.copyInitializationOfClass(this.fValueCategories[i], cost.source, (ICPPClassType)cost.target, false);
                        break;
                    }
                    case INIT_BY_CONVERSION: {
                        IType uqSource = SemanticUtil.getNestedType(cost.source, 7);
                        udcCost = Conversions.initializationByConversion(this.fValueCategories[i], cost.source, (ICPPClassType)uqSource, cost.target, false);
                        break;
                    }
                    case LIST_INIT_OF_CLASS: {
                        udcCost = Conversions.listInitializationOfClass((InitializerListType)cost.source, (ICPPClassType)cost.target, false, false);
                        break;
                    }
                    case DIRECT_LIST_INIT_OF_CLASS: {
                        udcCost = Conversions.listInitializationOfClass((InitializerListType)cost.source, (ICPPClassType)cost.target, true, false);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this.fCosts[i] = udcCost;
                if (!udcCost.converts()) {
                    return false;
                }
                udcCost.setReferenceBinding(cost.getReferenceBinding());
            }
            ++i;
        }
        return true;
    }

    public int compareTo(IASTTranslationUnit tu, FunctionCost other) throws DOMException {
        if (other == null) {
            return -1;
        }
        boolean haveWorse = false;
        boolean haveBetter = false;
        int idx = this.getLength() - 1;
        int idxOther = other.getLength() - 1;
        while (idx >= 0 && idxOther >= 0) {
            Cost cost = this.getCost(idx);
            if (!cost.converts()) {
                haveWorse = true;
                haveBetter = false;
                break;
            }
            int cmp = cost.compareTo(other.getCost(idxOther));
            haveWorse |= cmp > 0;
            haveBetter |= cmp < 0;
            --idx;
            --idxOther;
        }
        ICPPFunction f1 = this.getFunction();
        ICPPFunction f2 = other.getFunction();
        if (!haveWorse && !haveBetter) {
            boolean otherIsTemplate;
            ICPPFunctionTemplate asTemplate = FunctionCost.asTemplate(f1);
            ICPPFunctionTemplate otherAsTemplate = FunctionCost.asTemplate(f2);
            boolean isTemplate = asTemplate != null;
            boolean bl = otherIsTemplate = otherAsTemplate != null;
            if (isTemplate && !otherIsTemplate) {
                haveWorse = true;
            } else if (!isTemplate && otherIsTemplate) {
                haveBetter = true;
            } else if (isTemplate && otherIsTemplate) {
                CPPTemplates.TypeSelection ts = SemanticUtil.isConversionOperator(f1) ? CPPTemplates.TypeSelection.RETURN_TYPE : CPPTemplates.TypeSelection.PARAMETERS;
                int order = CPPTemplates.orderFunctionTemplates(otherAsTemplate, asTemplate, ts);
                if (order < 0) {
                    haveBetter = true;
                } else if (order > 0) {
                    haveWorse = true;
                }
            }
        }
        if (haveBetter == haveWorse) {
            int cmp = this.overridesUsingDeclaration(f1, f2);
            if (cmp != 0) {
                return cmp;
            }
            return -CPPSemantics.compareByRelevance(tu, (IBinding)f1, f2);
        }
        if (haveBetter) {
            return -1;
        }
        return 1;
    }

    private int overridesUsingDeclaration(ICPPFunction f1, ICPPFunction f2) {
        ICPPClassType o2;
        if (f1.takesVarArgs() != f2.takesVarArgs()) {
            return 0;
        }
        if (!(f1 instanceof ICPPMethod) || !(f2 instanceof ICPPMethod)) {
            return 0;
        }
        ICPPMethod m1 = (ICPPMethod)f1;
        ICPPMethod m2 = (ICPPMethod)f2;
        ICPPClassType o1 = m1.getClassOwner();
        if (o1.isSameType(o2 = m2.getClassOwner())) {
            return 0;
        }
        ICPPFunctionType ft1 = m1.getType();
        ICPPFunctionType ft2 = m2.getType();
        if (ft1.isConst() != ft2.isConst() || ft2.isVolatile() != ft2.isVolatile()) {
            return 0;
        }
        if (!this.parameterTypesMatch(ft1, ft2)) {
            return 0;
        }
        int diff = SemanticUtil.calculateInheritanceDepth(o2, o1);
        if (diff >= 0) {
            return diff;
        }
        return -SemanticUtil.calculateInheritanceDepth(o1, o2);
    }

    private boolean parameterTypesMatch(ICPPFunctionType ft1, ICPPFunctionType ft2) {
        IType[] p2;
        IType[] p1 = ft1.getParameterTypes();
        if (p1.length != (p2 = ft2.getParameterTypes()).length) {
            if (p1.length == 0) {
                return p2.length == 1 && SemanticUtil.isVoidType(p2[0]);
            }
            if (p2.length == 0) {
                return p1.length == 1 && SemanticUtil.isVoidType(p1[0]);
            }
            return false;
        }
        int i = 0;
        while (i < p2.length) {
            if (!p1[i].isSameType(p2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean mustBeWorse(FunctionCost other) {
        if (other == null) {
            return false;
        }
        boolean haveWorse = false;
        int idx = this.getLength() - 1;
        int idxOther = other.getLength() - 1;
        while (idx >= 0 && idxOther >= 0) {
            Cost cost = this.getCost(idx);
            if (!cost.converts()) {
                return true;
            }
            Cost otherCost = other.getCost(idxOther);
            int cmp = cost.isDeferredUDC() != Cost.DeferredUDC.NONE ? cost.getRank().compareTo(otherCost.getRank()) : cost.compareTo(otherCost);
            if (cmp < 0) {
                return false;
            }
            if (cmp > 0) {
                haveWorse = true;
            }
            --idx;
            --idxOther;
        }
        return haveWorse;
    }

    private static ICPPFunctionTemplate asTemplate(IFunction function) {
        IBinding original;
        if (function instanceof ICPPSpecialization && (original = ((ICPPSpecialization)((Object)function)).getSpecializedBinding()) instanceof ICPPFunctionTemplate) {
            return (ICPPFunctionTemplate)original;
        }
        return null;
    }

    public void setIsDirectInitWithCopyCtor(boolean val) {
        this.fIsDirectCopyCtor = val;
    }

    public boolean isDirectInitWithCopyCtor() {
        return this.fIsDirectCopyCtor;
    }
}

